/*
 * Decompiled with CFR 0.152.
 */
package realsurvivor.network;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import realsurvivor.network.client.ClientHandlerMultiply;
import realsurvivor.network.client.ClientHandlerSetCheck;
import realsurvivor.network.client.ClientHandlerSetDirty;
import realsurvivor.network.client.ClientHandlerSetEnergy;
import realsurvivor.network.client.ClientHandlerSetExcretion;
import realsurvivor.network.client.ClientUpdate;
import realsurvivor.network.common.PacketCheckMod;
import realsurvivor.network.common.PacketExcrete;
import realsurvivor.network.common.PacketSetDirty;
import realsurvivor.network.common.PacketSetEnergy;
import realsurvivor.network.common.PacketSetExcretion;
import realsurvivor.network.common.PacketSetMultiply;
import realsurvivor.network.common.PacketSleepy;
import realsurvivor.network.common.PacketStink;
import realsurvivor.network.common.PacketStool;
import realsurvivor.network.common.PacketUpdate;
import realsurvivor.network.server.ServerHandlerExcrete;
import realsurvivor.network.server.ServerHandlerMultiply;
import realsurvivor.network.server.ServerHandlerSetDirty;
import realsurvivor.network.server.ServerHandlerSetEnergy;
import realsurvivor.network.server.ServerHandlerSetExcretion;
import realsurvivor.network.server.ServerHandlerSleepy;
import realsurvivor.network.server.ServerHandlerStink;
import realsurvivor.network.server.ServerHandlerStool;

public class Dispatcher {
    private static final SimpleNetworkWrapper DISPATCHER = NetworkRegistry.INSTANCE.newSimpleChannel("realsurvivor");
    private static byte PACKET_ID;

    public static SimpleNetworkWrapper get() {
        return DISPATCHER;
    }

    public static void updateTrackers(Entity entity, IMessage message) {
        EntityTracker et = ((WorldServer)entity.field_70170_p).func_73039_n();
        for (EntityPlayer player : et.getTrackingPlayers(entity)) {
            DISPATCHER.sendTo(message, (EntityPlayerMP)player);
        }
    }

    public static void sendTo(IMessage message, EntityPlayerMP player) {
        DISPATCHER.sendTo(message, player);
    }

    public static void sendToServer(IMessage message) {
        DISPATCHER.sendToServer(message);
    }

    public static void register() {
        Dispatcher.register(PacketSetEnergy.class, ClientHandlerSetEnergy.class, Side.CLIENT);
        Dispatcher.register(PacketSetEnergy.class, ServerHandlerSetEnergy.class, Side.SERVER);
        Dispatcher.register(PacketSetExcretion.class, ClientHandlerSetExcretion.class, Side.CLIENT);
        Dispatcher.register(PacketSetExcretion.class, ServerHandlerSetExcretion.class, Side.SERVER);
        Dispatcher.register(PacketSetDirty.class, ClientHandlerSetDirty.class, Side.CLIENT);
        Dispatcher.register(PacketSetDirty.class, ServerHandlerSetDirty.class, Side.SERVER);
        Dispatcher.register(PacketExcrete.class, ServerHandlerExcrete.class, Side.SERVER);
        Dispatcher.register(PacketSleepy.class, ServerHandlerSleepy.class, Side.SERVER);
        Dispatcher.register(PacketStink.class, ServerHandlerStink.class, Side.SERVER);
        Dispatcher.register(PacketStool.class, ServerHandlerStool.class, Side.SERVER);
        Dispatcher.register(PacketCheckMod.class, ClientHandlerSetCheck.class, Side.CLIENT);
        Dispatcher.register(PacketSetMultiply.class, ClientHandlerMultiply.class, Side.CLIENT);
        Dispatcher.register(PacketSetMultiply.class, ServerHandlerMultiply.class, Side.SERVER);
        Dispatcher.register(PacketUpdate.class, ClientUpdate.class, Side.CLIENT);
    }

    private static <REQ extends IMessage, REPLY extends IMessage> void register(Class<REQ> message, Class<? extends IMessageHandler<REQ, REPLY>> handler, Side side) {
        byte by = PACKET_ID;
        PACKET_ID = (byte)(by + 1);
        DISPATCHER.registerMessage(handler, message, (int)by, side);
    }
}

