/*
 * Decompiled with CFR 0.152.
 */
package realsurvivor;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import realsurvivor.DataFake;
import realsurvivor.Register;
import realsurvivor.WorldData;
import realsurvivor.capabilities.IStatus;
import realsurvivor.capabilities.StatusProvider;
import realsurvivor.network.Dispatcher;
import realsurvivor.network.client.PacketClientSetCheck;
import realsurvivor.network.client.PacketClientSetDirty;
import realsurvivor.network.client.PacketClientSetEnergy;
import realsurvivor.network.client.PacketClientSetExcretion;
import realsurvivor.network.client.PacketClientUpdate;
import realsurvivor.network.server.PacketServerExcrete;
import realsurvivor.network.server.PacketServerSetDirty;
import realsurvivor.network.server.PacketServerSetEnergy;
import realsurvivor.network.server.PacketServerSetExcretion;
import realsurvivor.network.server.PacketServerSleepy;
import realsurvivor.network.server.PacketServerStink;
import realsurvivor.network.server.PacketServerStool;

public class Event {
    long eg = 0L;
    long et = 0L;
    int dt = 0;
    long sw = 0L;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPlayerSleep(SleepingLocationCheckEvent event) {
        PlayerEntity player;
        if (event.getEntity() instanceof PlayerEntity && (player = (PlayerEntity)event.getEntity()).func_71026_bH()) {
            this.eg = 0L;
            Dispatcher.sendToServer(new PacketServerSetEnergy(20));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onUpdatePlayer(LivingEvent.LivingUpdateEvent e) {
        DataFake data;
        if (e.getEntity().field_70170_p.field_72995_K && e.getEntity() instanceof ClientPlayerEntity && (data = new DataFake()).getxCheck() && !Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
            this.TickStatus((PlayerEntity)Minecraft.func_71410_x().field_71439_g, data.getxEnergy(), data.getxExcretion());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void TickStatus(PlayerEntity player, int en, int et) {
        IStatus status = (IStatus)player.getCapability(StatusProvider.Status_CAP, null).orElse(null);
        if (player.func_70608_bn()) {
            if (this.eg >= 400L) {
                this.eg = 0L;
                if (status.getEnergy() != 20) {
                    Dispatcher.sendToServer(new PacketServerSetEnergy(status.getEnergy() + 1));
                }
            } else {
                ++this.eg;
            }
        } else {
            if (this.eg >= (long)(800 * en)) {
                this.eg = 0L;
                if (status.getEnergy() != 0) {
                    Dispatcher.sendToServer(new PacketServerSetEnergy(status.getEnergy() - 1));
                }
            } else {
                ++this.eg;
            }
            if (player.func_71024_bL().func_75116_a() == 20) {
                if (this.et >= (long)(500 * et)) {
                    this.et = 0L;
                    if (status.getExcretion() != 0) {
                        Dispatcher.sendToServer(new PacketServerSetExcretion(status.getExcretion() - 1));
                    }
                } else {
                    ++this.et;
                }
            }
            if (player.func_70090_H()) {
                if (this.dt >= 80) {
                    this.dt = 0;
                    if (status.getDirty() < 20) {
                        Dispatcher.sendToServer(new PacketServerSetDirty(status.getDirty() + 1));
                    }
                } else {
                    ++this.dt;
                }
            }
            if (status.getEnergy() <= 6) {
                Dispatcher.sendToServer(new PacketServerSleepy());
            }
            if (status.getExcretion() <= 0) {
                Dispatcher.sendToServer(new PacketServerStool());
            }
            if (status.getDirty() <= 0) {
                Dispatcher.sendToServer(new PacketServerStink());
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPlayerAttack(LivingAttackEvent event) {
        Entity source = event.getSource().func_76346_g();
        if (event.getEntity().field_70170_p.field_72995_K && source instanceof ClientPlayerEntity) {
            DataFake data = new DataFake();
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            IStatus status = (IStatus)player.getCapability(StatusProvider.Status_CAP, null).orElse(null);
            if (data.getxCheck()) {
                int dt = data.getxDitry();
                if (!player.func_184812_l_()) {
                    if (this.dt >= 20 * dt) {
                        this.dt = 0;
                        if (status.getDirty() != 0) {
                            Dispatcher.sendToServer(new PacketServerSetDirty(status.getDirty() - 1));
                        }
                    } else {
                        ++this.dt;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        DataFake data;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (Register.excrete.func_151468_f() && player.field_71071_by.func_70431_c(new ItemStack((IItemProvider)Items.field_151133_ar)) && (data = new DataFake()).getExcretion() < 20) {
            Dispatcher.sendToServer(new PacketServerExcrete());
            Dispatcher.sendToServer(new PacketServerSetExcretion(20));
        }
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (Event.canHaveAttributes((Entity)event.getObject())) {
            if (!(event.getObject() instanceof PlayerEntity)) {
                return;
            }
            event.addCapability(new ResourceLocation("realsurvivor", "status"), (ICapabilityProvider)new StatusProvider());
        }
    }

    public static boolean canHaveAttributes(Entity entity) {
        return entity instanceof LivingEntity;
    }

    @SubscribeEvent
    public void onPlayerLogsIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity) {
            PlayerEntity player = event.getPlayer();
            IStatus status = (IStatus)player.getCapability(StatusProvider.Status_CAP, null).orElse(null);
            this.sendStart(status, player);
        }
    }

    private void sendStart(IStatus data, PlayerEntity player) {
        ServerPlayerEntity mp = (ServerPlayerEntity)player;
        Dispatcher.sendTo(new PacketClientSetEnergy(data.getEnergy()), mp);
        Dispatcher.sendTo(new PacketClientSetDirty(data.getDirty()), mp);
        Dispatcher.sendTo(new PacketClientSetExcretion(data.getExcretion()), mp);
        Dispatcher.sendTo(new PacketClientSetCheck(true), mp);
    }

    @SubscribeEvent
    public void onPlayerJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity) {
            WorldData worlddata = WorldData.forWorld((ServerWorld)event.getWorld());
            Dispatcher.sendTo(new PacketClientUpdate(worlddata.getData().func_74767_n("xCheck"), worlddata.getData().func_74762_e("xEnergy"), worlddata.getData().func_74762_e("xDitry"), worlddata.getData().func_74762_e("xExcretion")), (ServerPlayerEntity)event.getEntity());
        }
    }

    @SubscribeEvent
    public void onPlayerSpawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity) {
            PlayerEntity player = event.getPlayer();
            IStatus status = (IStatus)player.getCapability(StatusProvider.Status_CAP, null).orElse(null);
            this.sendStart(status, player);
        }
    }
}

