/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretroomsmod.blocks;

import com.wynprice.secretroomsmod.SecretBlocks;
import com.wynprice.secretroomsmod.base.BaseFakeBlock;
import com.wynprice.secretroomsmod.base.interfaces.ISecretBlock;
import com.wynprice.secretroomsmod.base.interfaces.ISecretTileEntity;
import com.wynprice.secretroomsmod.render.fakemodels.FakeBlockModel;
import com.wynprice.secretroomsmod.render.fakemodels.TrueSightFaceDiffrentModel;
import com.wynprice.secretroomsmod.render.fakemodels.TrueSightModel;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SecretGate
extends BaseFakeBlock {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;
    private static final int MAX_LEVELS = 10;

    public SecretGate() {
        super("secret_gate", Material.field_151573_f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TrueSightModel phaseTrueModel(TrueSightModel model) {
        return new TrueSightFaceDiffrentModel(model, FakeBlockModel.getModel(new ResourceLocation("secretroomsmod", "block/ghost_block")));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        boolean flag1;
        boolean flag = (Boolean)state.func_177229_b((IProperty)POWERED);
        boolean bl = flag1 = worldIn.func_175640_z(pos) || worldIn.func_175687_A(pos) > 0;
        if (flag != flag1) {
            if (flag1) {
                this.buildGate(worldIn, pos);
            } else if (!flag1) {
                this.destroyGate(worldIn, pos, worldIn.func_180495_p(pos));
                worldIn.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, worldIn.func_180495_p(pos).func_177229_b((IProperty)FACING)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    protected void buildGate(World worldIn, BlockPos pos) {
        BlockPos position;
        EnumFacing direction = (EnumFacing)worldIn.func_180495_p(pos).func_177229_b((IProperty)FACING);
        IBlockState state = this.getState((IBlockAccess)worldIn, pos);
        worldIn.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)direction).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)));
        ((ISecretTileEntity)worldIn.func_175625_s(pos)).setMirrorState(state, BlockPos.field_177992_a);
        for (int i = 1; i < 11 && worldIn.func_180495_p(position = new BlockPos(pos.func_177958_n() + i * direction.func_82601_c(), pos.func_177956_o() + i * direction.func_96559_d(), pos.func_177952_p() + i * direction.func_82599_e())).func_177230_c().func_176200_f((IBlockAccess)worldIn, position); ++i) {
            worldIn.func_175656_a(position, SecretBlocks.SECRET_GATE_BLOCK.func_176223_P());
            worldIn.func_175625_s(position).func_70296_d();
            ((ISecretBlock)worldIn.func_180495_p(pos).func_177230_c()).forceBlockState(worldIn, position, BlockPos.field_177992_a, this.getState((IBlockAccess)worldIn, pos));
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        this.destroyGate(worldIn, pos, state);
        super.func_180663_b(worldIn, pos, state);
    }

    protected void destroyGate(World worldIn, BlockPos pos, IBlockState blockstate) {
        EnumFacing direction = (EnumFacing)blockstate.func_177229_b((IProperty)FACING);
        IBlockState state = this.getState((IBlockAccess)worldIn, pos);
        ((ISecretTileEntity)worldIn.func_175625_s(pos)).setMirrorState(state, BlockPos.field_177992_a);
        for (int i = 1; i < 11 && worldIn.func_180495_p(new BlockPos(pos.func_177958_n() + i * direction.func_82601_c(), pos.func_177956_o() + i * direction.func_96559_d(), pos.func_177952_p() + i * direction.func_82599_e())).func_177230_c() == SecretBlocks.SECRET_GATE_BLOCK; ++i) {
            worldIn.func_175698_g(new BlockPos(pos.func_177958_n() + i * direction.func_82601_c(), pos.func_177956_o() + i * direction.func_96559_d(), pos.func_177952_p() + i * direction.func_82599_e()));
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED, FACING});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, ItemStack stack) {
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FACING, (Comparable)BlockPistonBase.func_185647_a((BlockPos)pos, (EntityLivingBase)placer));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7))).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    @Override
    public void onMessageRecieved(World world, BlockPos pos) {
        if (world.func_175640_z(pos) || world.func_175687_A(pos) > 0) {
            this.buildGate(world, pos);
        }
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            i |= 8;
        }
        return i;
    }
}

