/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretroomsmod.blocks;

import com.wynprice.secretroomsmod.SecretBlocks;
import com.wynprice.secretroomsmod.base.interfaces.ISecretBlock;
import com.wynprice.secretroomsmod.tileentity.TileEntitySecretDaylightSensor;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDaylightDetector;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SecretLightDetector
extends BlockDaylightDetector
implements ISecretBlock {
    private final boolean inverted;

    public SecretLightDetector(boolean inverted) {
        super(inverted);
        this.inverted = inverted;
        this.setRegistryName("secret" + (inverted ? "_inverted" : "") + "_light_detector");
        this.func_149663_c("secret" + (inverted ? "_inverted" : "") + "_light_detector");
        this.func_149711_c(0.5f);
        this.field_149785_s = true;
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_175142_cm()) {
            if (worldIn.field_72995_K) {
                return true;
            }
            if (this.inverted) {
                worldIn.func_180501_a(pos, SecretBlocks.SECRET_LIGHT_DETECTOR.func_176223_P().func_177226_a((IProperty)field_176436_a, state.func_177229_b((IProperty)field_176436_a)), 4);
                SecretBlocks.SECRET_LIGHT_DETECTOR.func_180677_d(worldIn, pos);
            } else {
                worldIn.func_180501_a(pos, SecretBlocks.SECRET_LIGHT_DETECTOR_INVERTED.func_176223_P().func_177226_a((IProperty)field_176436_a, state.func_177229_b((IProperty)field_176436_a)), 4);
                SecretBlocks.SECRET_LIGHT_DETECTOR_INVERTED.func_180677_d(worldIn, pos);
            }
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, heldItem, facing, hitX, hitY, hitZ);
    }

    public Material func_149688_o(IBlockState state) {
        return ISecretBlock.super.getMaterial(state, super.func_149688_o(state));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)SecretBlocks.SECRET_LIGHT_DETECTOR);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)SecretBlocks.SECRET_LIGHT_DETECTOR);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ISecretBlock.super.getBoundingBox(state, source, pos);
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntitySecretDaylightSensor();
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    @Override
    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return ISecretBlock.super.isSideSolid(base_state, world, pos, side);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn) {
        ISecretBlock.super.addCollisionBoxToList(state, worldIn, pos, entityBox, collidingBoxes, entityIn);
    }

    @Override
    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        return ISecretBlock.super.getSoundType(state, world, pos, entity);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return ISecretBlock.super.addHitEffects(state, worldObj, target, manager);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return ISecretBlock.super.addDestroyEffects(world, pos, manager);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_185485_f(IBlockState state) {
        return 1.0f;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return ISecretBlock.super.canPlaceBlockOnSide(worldIn, pos, side);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        ISecretBlock.super.onBlockPlacedBy(worldIn, pos, state, placer, stack);
    }
}

