/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretroomsmod.blocks;

import com.wynprice.secretroomsmod.base.BaseFakeBlock;
import com.wynprice.secretroomsmod.render.fakemodels.FakeBlockModel;
import com.wynprice.secretroomsmod.render.fakemodels.TrapDoorFakeModel;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SecretTrapDoor
extends BaseFakeBlock {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool OPEN = PropertyBool.func_177716_a((String)"open");
    public static final PropertyEnum<BlockTrapDoor.DoorHalf> HALF = PropertyEnum.func_177709_a((String)"half", BlockTrapDoor.DoorHalf.class);
    protected static final AxisAlignedBB EAST_OPEN_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.1875, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_OPEN_AABB = new AxisAlignedBB(0.8125, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB SOUTH_OPEN_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1875);
    protected static final AxisAlignedBB NORTH_OPEN_AABB = new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB BOTTOM_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);
    protected static final AxisAlignedBB TOP_AABB = new AxisAlignedBB(0.0, 0.8125, 0.0, 1.0, 1.0, 1.0);

    public SecretTrapDoor(String name, Material materialIn) {
        super(name, materialIn);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false)).func_177226_a(HALF, (Comparable)BlockTrapDoor.DoorHalf.BOTTOM));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public FakeBlockModel phaseModel(FakeBlockModel model) {
        return new TrapDoorFakeModel(model);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        AxisAlignedBB axisalignedbb;
        if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
            switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
                default: {
                    axisalignedbb = NORTH_OPEN_AABB;
                    break;
                }
                case SOUTH: {
                    axisalignedbb = SOUTH_OPEN_AABB;
                    break;
                }
                case WEST: {
                    axisalignedbb = WEST_OPEN_AABB;
                    break;
                }
                case EAST: {
                    axisalignedbb = EAST_OPEN_AABB;
                    break;
                }
            }
        } else {
            axisalignedbb = state.func_177229_b(HALF) == BlockTrapDoor.DoorHalf.TOP ? TOP_AABB : BOTTOM_AABB;
        }
        return axisalignedbb;
    }

    @Override
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn) {
        SecretTrapDoor.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)state.func_185890_d(worldIn, pos));
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return (Boolean)worldIn.func_180495_p(pos).func_177229_b((IProperty)OPEN) == false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.field_149764_J == Material.field_151573_f) {
            return false;
        }
        state = state.func_177231_a((IProperty)OPEN);
        worldIn.func_180501_a(pos, state, 2);
        this.playSound(playerIn, worldIn, pos, (Boolean)state.func_177229_b((IProperty)OPEN));
        return true;
    }

    protected void playSound(@Nullable EntityPlayer player, World worldIn, BlockPos pos, boolean p_185731_4_) {
        if (p_185731_4_) {
            int i = this.field_149764_J == Material.field_151573_f ? 1037 : 1007;
            worldIn.func_180498_a(player, i, pos, 0);
        } else {
            int j = this.field_149764_J == Material.field_151573_f ? 1036 : 1013;
            worldIn.func_180498_a(player, j, pos, 0);
        }
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        boolean flag1;
        boolean flag;
        if (!worldIn.field_72995_K && ((flag = worldIn.func_175640_z(pos)) || blockIn.func_176223_P().func_185897_m()) && (flag1 = ((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) != flag) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(flag)), 2);
            this.playSound(null, worldIn, pos, flag);
        }
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = this.func_176223_P();
        if (facing.func_176740_k().func_176722_c()) {
            iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false));
            iblockstate = iblockstate.func_177226_a(HALF, (Comparable)(hitY > 0.5f ? BlockTrapDoor.DoorHalf.TOP : BlockTrapDoor.DoorHalf.BOTTOM));
        } else {
            iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false));
            iblockstate = iblockstate.func_177226_a(HALF, (Comparable)(facing == EnumFacing.UP ? BlockTrapDoor.DoorHalf.BOTTOM : BlockTrapDoor.DoorHalf.TOP));
        }
        if (worldIn.func_175640_z(pos)) {
            iblockstate = iblockstate.func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(true));
        }
        return iblockstate;
    }

    protected static EnumFacing getFacing(int meta) {
        switch (meta & 3) {
            case 0: {
                return EnumFacing.NORTH;
            }
            case 1: {
                return EnumFacing.SOUTH;
            }
            case 2: {
                return EnumFacing.WEST;
            }
        }
        return EnumFacing.EAST;
    }

    protected static int getMetaForFacing(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return 0;
            }
            case SOUTH: {
                return 1;
            }
            case WEST: {
                return 2;
            }
        }
        return 3;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)SecretTrapDoor.getFacing(meta)).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf((meta & 4) != 0)).func_177226_a(HALF, (Comparable)((meta & 8) == 0 ? BlockTrapDoor.DoorHalf.BOTTOM : BlockTrapDoor.DoorHalf.TOP));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= SecretTrapDoor.getMetaForFacing((EnumFacing)state.func_177229_b((IProperty)FACING));
        if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
            i |= 4;
        }
        if (state.func_177229_b(HALF) == BlockTrapDoor.DoorHalf.TOP) {
            i |= 8;
        }
        return i;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, OPEN, HALF});
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        IBlockState down;
        if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue() && (down = world.func_180495_p(pos.func_177977_b())).func_177230_c() == Blocks.field_150468_ap) {
            return down.func_177229_b((IProperty)BlockLadder.field_176382_a) == state.func_177229_b((IProperty)FACING);
        }
        return false;
    }

    public static enum DoorHalf implements IStringSerializable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private DoorHalf(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

