/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretroomsmod;

import com.wynprice.secretroomsmod.SecretRooms5;
import com.wynprice.secretroomsmod.base.BaseBlockDoor;
import com.wynprice.secretroomsmod.blocks.GhostBlock;
import com.wynprice.secretroomsmod.blocks.OneWayGlass;
import com.wynprice.secretroomsmod.blocks.SecretButton;
import com.wynprice.secretroomsmod.blocks.SecretChest;
import com.wynprice.secretroomsmod.blocks.SecretDispenser;
import com.wynprice.secretroomsmod.blocks.SecretGate;
import com.wynprice.secretroomsmod.blocks.SecretGateEmptyBlock;
import com.wynprice.secretroomsmod.blocks.SecretLever;
import com.wynprice.secretroomsmod.blocks.SecretLightDetector;
import com.wynprice.secretroomsmod.blocks.SecretPlayerPressurePlate;
import com.wynprice.secretroomsmod.blocks.SecretPressurePlate;
import com.wynprice.secretroomsmod.blocks.SecretRedstone;
import com.wynprice.secretroomsmod.blocks.SecretStairs;
import com.wynprice.secretroomsmod.blocks.SecretTrapDoor;
import com.wynprice.secretroomsmod.blocks.SecretTrappedChest;
import com.wynprice.secretroomsmod.blocks.SecretWeightedPressurePlate;
import com.wynprice.secretroomsmod.blocks.SolidAir;
import com.wynprice.secretroomsmod.blocks.TorchLever;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SecretBlocks {
    public static final Block GHOST_BLOCK = new GhostBlock();
    public static final Block FAKE_STAIRS = new SecretStairs();
    public static final Block FAKE_LEVER = new SecretLever();
    public static final Block FAKE_REDSTONE = new SecretRedstone();
    public static final Block ONE_WAY_GLASS = new OneWayGlass();
    public static final Block SECRET_WOODEN_BUTTON = new SecretButton(true);
    public static final Block SECRET_STONE_BUTTON = new SecretButton(false);
    public static final Block TORCH_LEVER = new TorchLever();
    public static final Block SECRET_PRESSURE_PLATE = new SecretPressurePlate();
    public static final Block SECRET_LIGHT_PRESSURE_PLATE = new SecretWeightedPressurePlate("secret_light_pressure_plate", 15);
    public static final Block SECRET_HEAVY_PRESSURE_PLATE = new SecretWeightedPressurePlate("secret_heavy_pressure_plate", 150);
    public static final Block SECRET_PLAYER_PRESSURE_PLATE = new SecretPlayerPressurePlate();
    public static final Block SOLID_AIR = new SolidAir();
    public static final Block SECRET_CHEST = new SecretChest("secret_chest");
    public static final BaseBlockDoor SECRET_WOODEN_DOOR = new BaseBlockDoor("secret_wooden_door", Material.field_151575_d);
    public static final BaseBlockDoor SECRET_IRON_DOOR = new BaseBlockDoor("secret_iron_door", Material.field_151573_f);
    public static final Block SECRET_WOODEN_TRAPDOOR = new SecretTrapDoor("secret_wooden_trapdoor", Material.field_151575_d);
    public static final Block SECRET_IRON_TRAPDOOR = new SecretTrapDoor("secret_iron_trapdoor", Material.field_151573_f);
    public static final Block SECRET_DISPENSER = new SecretDispenser();
    public static final Block SECRET_TRAPPED_CHEST = new SecretTrappedChest();
    public static final Block SECRET_GATE_BLOCK = new SecretGateEmptyBlock();
    public static final Block SECRET_GATE = new SecretGate();
    public static final SecretLightDetector SECRET_LIGHT_DETECTOR = new SecretLightDetector(false);
    public static final SecretLightDetector SECRET_LIGHT_DETECTOR_INVERTED = new SecretLightDetector(true);
    private static final ArrayList<Block> BLOCKS_WITH_ITEMS = new ArrayList();
    private static final HashMap<Block, Integer> BLOCK_STACK_SIZES = new HashMap();
    private static final ArrayList<Block> BLOCKS_WITH_CUSTOM_STATE_MAP = new ArrayList();
    private static final ArrayList<IProperty<?>[]> PROPERTIES_TO_IGNORE_CUSTOM_STATE_MAP = new ArrayList();

    public static void preInit() {
        SecretBlocks.regBlock(GHOST_BLOCK);
        SecretBlocks.regBlockIgnoreAll(FAKE_STAIRS);
        SecretBlocks.regBlockIgnoreAll(FAKE_LEVER);
        SecretBlocks.regBlockIgnoreAll(FAKE_REDSTONE);
        SecretBlocks.regBlockIgnoreAll(ONE_WAY_GLASS);
        SecretBlocks.regBlockIgnoreAll(SECRET_WOODEN_BUTTON);
        SecretBlocks.regBlockIgnoreAll(SECRET_STONE_BUTTON);
        SecretBlocks.regBlock(TORCH_LEVER, 64, new IProperty[]{TorchLever.POWERED});
        SecretBlocks.regBlockIgnoreAll(SECRET_PRESSURE_PLATE);
        SecretBlocks.regBlockIgnoreAll(SECRET_LIGHT_PRESSURE_PLATE);
        SecretBlocks.regBlockIgnoreAll(SECRET_HEAVY_PRESSURE_PLATE);
        SecretBlocks.regBlockIgnoreAll(SECRET_PLAYER_PRESSURE_PLATE);
        SecretBlocks.regBlock(SOLID_AIR);
        SecretBlocks.regBlock(SECRET_CHEST);
        SecretBlocks.regSingleBlockIgnoreAll((Block)SECRET_WOODEN_DOOR);
        SecretBlocks.regSingleBlockIgnoreAll((Block)SECRET_IRON_DOOR);
        SecretBlocks.regBlockIgnoreAll(SECRET_WOODEN_TRAPDOOR);
        SecretBlocks.regBlockIgnoreAll(SECRET_IRON_TRAPDOOR);
        SecretBlocks.regBlockIgnoreAll(SECRET_DISPENSER);
        SecretBlocks.regBlock(SECRET_TRAPPED_CHEST);
        SecretBlocks.regSingleBlock(SECRET_GATE_BLOCK);
        SecretBlocks.regBlockIgnoreAll(SECRET_GATE);
        SecretBlocks.regBlockIgnoreAll((Block)SECRET_LIGHT_DETECTOR);
        SecretBlocks.regSingleBlockIgnoreAll((Block)SECRET_LIGHT_DETECTOR_INVERTED);
    }

    public static void regRenders() {
        for (int i = 0; i < BLOCKS_WITH_CUSTOM_STATE_MAP.size(); ++i) {
            SecretBlocks.createStateMappers(BLOCKS_WITH_CUSTOM_STATE_MAP.get(i), PROPERTIES_TO_IGNORE_CUSTOM_STATE_MAP.get(i));
        }
        for (Block b : BLOCKS_WITH_ITEMS) {
            SecretBlocks.regRender(b);
        }
    }

    private static void regBlock(Block block) {
        SecretBlocks.regBlock(block, 64);
    }

    private static void regBlock(Block block, int stackSize) {
        BLOCKS_WITH_ITEMS.add(block);
        BLOCK_STACK_SIZES.put(block, stackSize);
        block.func_149647_a(SecretRooms5.TAB);
        SecretBlocks.register(block);
    }

    private static void regBlockIgnoreAll(Block block) {
        SecretBlocks.regBlockIgnoreAll(block, 64);
    }

    private static void regBlockIgnoreAll(Block block, int stackSize) {
        SecretBlocks.regBlock(block, stackSize, (IProperty[])block.func_176223_P().func_177228_b().asMultimap().asMap().keySet().toArray((Object[])new IProperty[block.func_176223_P().func_177228_b().asMultimap().asMap().keySet().size()]));
    }

    private static void regSingleBlockIgnoreAll(Block block) {
        SecretBlocks.regSingleBlock(block, (IProperty[])block.func_176223_P().func_177228_b().asMultimap().asMap().keySet().toArray((Object[])new IProperty[block.func_176223_P().func_177228_b().asMultimap().asMap().keySet().size()]));
    }

    private static void regBlock(Block block, int stackSize, IProperty<?> ... toIgnore) {
        BLOCKS_WITH_CUSTOM_STATE_MAP.add(block);
        PROPERTIES_TO_IGNORE_CUSTOM_STATE_MAP.add(toIgnore);
        SecretBlocks.regBlock(block, stackSize);
    }

    @SideOnly(value=Side.CLIENT)
    private static void createStateMappers(Block block, IProperty<?>[] toIgnore) {
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMap.Builder().func_178442_a(toIgnore).func_178441_a());
    }

    private static void regSingleBlock(Block block) {
        SecretBlocks.register(block);
    }

    private static void regSingleBlock(Block block, IProperty<?> ... toIgnore) {
        BLOCKS_WITH_CUSTOM_STATE_MAP.add(block);
        PROPERTIES_TO_IGNORE_CUSTOM_STATE_MAP.add(toIgnore);
        SecretBlocks.register(block);
    }

    private static void regRender(Block block) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), "inventory"));
    }

    private static void register(Block block) {
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        if (BLOCKS_WITH_ITEMS.contains(block)) {
            ItemBlock item = new ItemBlock(block);
            item.setRegistryName(block.getRegistryName());
            item.func_77625_d(BLOCK_STACK_SIZES.get(block).intValue());
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
        }
    }
}

