/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretroomsmod.base.interfaces;

import com.wynprice.secretroomsmod.base.interfaces.ISecretTileEntity;
import com.wynprice.secretroomsmod.handler.ParticleHandler;
import com.wynprice.secretroomsmod.network.SecretNetwork;
import com.wynprice.secretroomsmod.network.packets.MessagePacketFakeBlockPlaced;
import com.wynprice.secretroomsmod.render.fakemodels.FakeBlockModel;
import com.wynprice.secretroomsmod.render.fakemodels.TrueSightModel;
import com.wynprice.secretroomsmod.tileentity.TileEntityInfomationHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import scala.util.Random;

public interface ISecretBlock
extends ITileEntityProvider {
    public static final ArrayList<TileEntity> ALL_SECRET_TILE_ENTITIES = new ArrayList();
    public static final HashMap<BlockPos, IBlockState> REPLACEABLE_BLOCK_MAP = new HashMap();

    default public IBlockState getState(IBlockAccess world, BlockPos pos) {
        return world.func_175625_s(pos) instanceof ISecretTileEntity ? ((ISecretTileEntity)world.func_175625_s(pos)).getMirrorState() : null;
    }

    default public void forceBlockState(World world, BlockPos tePos, BlockPos hitPos, IBlockState state) {
        if (world.func_175625_s(tePos) instanceof ISecretTileEntity) {
            ((ISecretTileEntity)world.func_175625_s(tePos)).setMirrorStateForcable(state, hitPos);
        }
    }

    default public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityInfomationHolder();
    }

    default public boolean allowForcedBlockColors() {
        return true;
    }

    default public void onMessageRecieved(World world, BlockPos pos) {
    }

    @SideOnly(value=Side.CLIENT)
    default public FakeBlockModel phaseModel(FakeBlockModel model) {
        return model;
    }

    @SideOnly(value=Side.CLIENT)
    default public TrueSightModel phaseTrueModel(TrueSightModel model) {
        return model;
    }

    @SideOnly(value=Side.CLIENT)
    default public IBlockState overrideThisState(World world, BlockPos pos, IBlockState defaultState) {
        return defaultState;
    }

    default public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (source.func_175625_s(pos) instanceof ISecretTileEntity && ((ISecretTileEntity)source.func_175625_s(pos)).getMirrorState() != null) {
            return ((ISecretTileEntity)source.func_175625_s(pos)).getMirrorState().func_185900_c(source, pos);
        }
        return Block.field_185505_j;
    }

    default public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.getState(world, pos).func_177230_c().canBeConnectedTo(world, pos, facing) || this.getState(world, pos).func_177230_c() instanceof BlockFence;
    }

    default public Material getMaterial(IBlockState state, Material material) {
        IBlockState blockstate = null;
        ArrayList<TileEntity> list = new ArrayList<TileEntity>(ALL_SECRET_TILE_ENTITIES);
        for (TileEntity tileentity : list) {
            if (tileentity.func_145831_w() == null || tileentity.func_145831_w().func_180495_p(tileentity.func_174877_v()) != state || !(tileentity instanceof ISecretTileEntity)) continue;
            blockstate = ISecretTileEntity.getMirrorState(tileentity.func_145831_w(), tileentity.func_174877_v());
        }
        return blockstate != null && !(blockstate.func_177230_c() instanceof ISecretBlock) ? blockstate.func_185904_a() : material;
    }

    default public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return ISecretTileEntity.getMirrorState(world, pos).isSideSolid(world, pos, side);
    }

    default public void addCollisionBoxToList(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        if (worldIn.func_175625_s(pos) instanceof ISecretTileEntity && ISecretTileEntity.getMirrorState(worldIn, pos) != null) {
            ISecretTileEntity.getMirrorState(worldIn, pos).func_185908_a(worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
        } else {
            Blocks.field_150348_b.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
        }
    }

    default public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        return world.func_175625_s(pos) instanceof ISecretTileEntity && ISecretTileEntity.getMirrorState(world, pos) != null ? ISecretTileEntity.getMirrorState(world, pos).func_177230_c().func_185467_w() : SoundType.field_185851_d;
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        if (target.func_178782_a() != null && worldObj.func_175625_s(target.func_178782_a()) instanceof ISecretTileEntity && ((ISecretTileEntity)worldObj.func_175625_s(target.func_178782_a())).getMirrorState() != null) {
            int i = target.func_178782_a().func_177958_n();
            int j = target.func_178782_a().func_177956_o();
            int k = target.func_178782_a().func_177952_p();
            float f = 0.1f;
            AxisAlignedBB axisalignedbb = ((ISecretTileEntity)worldObj.func_175625_s(target.func_178782_a())).getMirrorState().func_185900_c((IBlockAccess)worldObj, target.func_178782_a());
            double d0 = (double)i + new Random().nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)0.2f) + (double)0.1f + axisalignedbb.field_72340_a;
            double d1 = (double)j + new Random().nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)0.2f) + (double)0.1f + axisalignedbb.field_72338_b;
            double d2 = (double)k + new Random().nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)0.2f) + (double)0.1f + axisalignedbb.field_72339_c;
            if (target.field_178784_b == EnumFacing.DOWN) {
                d1 = (double)j + axisalignedbb.field_72338_b - (double)0.1f;
            }
            if (target.field_178784_b == EnumFacing.UP) {
                d1 = (double)j + axisalignedbb.field_72337_e + (double)0.1f;
            }
            if (target.field_178784_b == EnumFacing.NORTH) {
                d2 = (double)k + axisalignedbb.field_72339_c - (double)0.1f;
            }
            if (target.field_178784_b == EnumFacing.SOUTH) {
                d2 = (double)k + axisalignedbb.field_72334_f + (double)0.1f;
            }
            if (target.field_178784_b == EnumFacing.WEST) {
                d0 = (double)i + axisalignedbb.field_72340_a - (double)0.1f;
            }
            if (target.field_178784_b == EnumFacing.EAST) {
                d0 = (double)i + axisalignedbb.field_72336_d + (double)0.1f;
            }
            manager.func_78873_a(((ParticleDigging)new ParticleDigging.Factory().func_178902_a(0, worldObj, d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)((ISecretTileEntity)worldObj.func_175625_s(target.func_178782_a())).getMirrorState())})).func_174846_a(target.func_178782_a()).func_70543_e(0.2f).func_70541_f(0.6f));
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        if (ParticleHandler.BLOCKBRAKERENDERMAP.get(pos) != null) {
            IBlockState state = ParticleHandler.BLOCKBRAKERENDERMAP.get(pos).func_185899_b((IBlockAccess)world, pos);
            int i = 4;
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    for (int l = 0; l < 4; ++l) {
                        double d0 = ((double)j + 0.5) / 4.0;
                        double d1 = ((double)k + 0.5) / 4.0;
                        double d2 = ((double)l + 0.5) / 4.0;
                        manager.func_78873_a((Particle)((ParticleDigging)new ParticleDigging.Factory().func_178902_a(0, world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, d0 - 0.5, d1 - 0.5, d2 - 0.5, new int[]{Block.func_176210_f((IBlockState)state)})).func_174846_a(pos));
                    }
                }
            }
        }
        return false;
    }

    default public boolean canPlaceBlockOnSide(World worldIn, BlockPos pos, EnumFacing side) {
        if (worldIn.field_72995_K && worldIn.func_180495_p(Minecraft.func_71410_x().field_71476_x.func_178782_a()).func_177230_c().func_176200_f((IBlockAccess)worldIn, Minecraft.func_71410_x().field_71476_x.func_178782_a()) && !(worldIn.func_180495_p(Minecraft.func_71410_x().field_71476_x.func_178782_a()).func_177230_c() instanceof IFluidBlock) && !(worldIn.func_180495_p(Minecraft.func_71410_x().field_71476_x.func_178782_a()).func_177230_c() instanceof BlockLiquid)) {
            REPLACEABLE_BLOCK_MAP.put(pos, worldIn.func_180495_p(Minecraft.func_71410_x().field_71476_x.func_178782_a()));
        }
        return worldIn.func_180495_p(pos).func_177230_c().func_176196_c(worldIn, pos);
    }

    default public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (worldIn.field_72995_K) {
            IBlockState blockstate = Blocks.field_150350_a.func_176223_P();
            BlockPos overPosition = new BlockPos((Vec3i)pos);
            if (REPLACEABLE_BLOCK_MAP.containsKey(pos)) {
                blockstate = REPLACEABLE_BLOCK_MAP.get(pos);
                REPLACEABLE_BLOCK_MAP.remove(pos);
            }
            if (blockstate.func_177230_c() == Blocks.field_150350_a) {
                overPosition = Minecraft.func_71410_x().field_71476_x.func_178782_a();
                blockstate = worldIn.func_180495_p(overPosition);
                if (worldIn.func_175625_s(overPosition) instanceof ISecretTileEntity) {
                    blockstate = ISecretTileEntity.getMirrorState(worldIn, overPosition);
                }
            }
            SecretNetwork.sendToServer(new MessagePacketFakeBlockPlaced(pos, overPosition, blockstate));
            ((ISecretTileEntity)worldIn.func_175625_s(pos)).setMirrorState(blockstate, overPosition);
        }
    }
}

