/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretroomsmod.handler;

import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.wynprice.secretroomsmod.SecretConfig;
import com.wynprice.secretroomsmod.SecretRooms5;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Map;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.versioning.ComparableVersion;

public class HandlerUpdateChecker {
    private boolean hasPosted;

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!this.hasPosted) {
            this.hasPosted = true;
            if (!SecretConfig.updateChecker) {
                return;
            }
            ForgeVersion.Status status = ForgeVersion.Status.PENDING;
            ComparableVersion target = null;
            InputStream con = null;
            String data = null;
            try {
                URL url = new URL("http://www.wynprice.com/update_jsons/secretroomsmod.json");
                con = url.openStream();
                data = new String(ByteStreams.toByteArray((InputStream)con), "UTF-8");
                con.close();
            }
            catch (UnknownHostException h) {
                SecretRooms5.LOGGER.warn("Host Cannot be found for update checker. Either the Site is offline or the checker has moved. Please report this");
                return;
            }
            catch (IOException e) {
                SecretRooms5.LOGGER.warn("The URL is in the wrong format. Please report this");
                return;
            }
            Map json = (Map)new Gson().fromJson(data, Map.class);
            Map promos = (Map)json.get("promos");
            String rec = (String)promos.get("1.11.2-recommended");
            String lat = (String)promos.get("1.11.2-latest");
            ComparableVersion current = new ComparableVersion("5.1.9");
            if (rec != null) {
                ComparableVersion recommended = new ComparableVersion(rec);
                int diff = recommended.compareTo(current);
                if (diff == 0) {
                    status = ForgeVersion.Status.UP_TO_DATE;
                } else if (diff < 0) {
                    ComparableVersion latest;
                    status = ForgeVersion.Status.AHEAD;
                    if (lat != null && current.compareTo(latest = new ComparableVersion(lat)) < 0) {
                        status = ForgeVersion.Status.OUTDATED;
                        target = latest;
                    }
                } else {
                    status = ForgeVersion.Status.OUTDATED;
                    target = recommended;
                }
            } else if (lat != null) {
                ComparableVersion latest = new ComparableVersion(lat);
                if (current.compareTo(latest) < 0) {
                    status = ForgeVersion.Status.BETA_OUTDATED;
                    target = latest;
                } else {
                    status = ForgeVersion.Status.BETA;
                }
            } else {
                status = ForgeVersion.Status.BETA;
            }
            if (status == ForgeVersion.Status.OUTDATED || status == ForgeVersion.Status.BETA_OUTDATED) {
                ITextComponent componant = new TextComponentTranslation("update.version", new Object[]{"Secret Rooms 5", "5.1.9", target}).func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, (String)json.get("homepage"))));
                componant.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("update.hover", new Object[]{(String)json.get("homepage")})));
                event.player.func_145747_a(componant);
            } else {
                SecretRooms5.LOGGER.info("Update checker returned: " + status);
            }
        }
    }
}

