/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretroomsmod.network.packets;

import com.wynprice.secretroomsmod.base.BaseMessagePacket;
import com.wynprice.secretroomsmod.base.interfaces.ISecretTileEntity;
import com.wynprice.secretroomsmod.handler.ServerRecievePacketHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessagePacketFakeBlockPlaced
extends BaseMessagePacket<MessagePacketFakeBlockPlaced> {
    private BlockPos pos;
    private BlockPos lookPos;
    private IBlockState mouseOver;
    private int multiplyColor;

    public MessagePacketFakeBlockPlaced() {
    }

    @SideOnly(value=Side.CLIENT)
    public MessagePacketFakeBlockPlaced(BlockPos pos, BlockPos lookPos, IBlockState state) {
        this.pos = pos;
        this.lookPos = lookPos;
        if (state == null) {
            return;
        }
        this.mouseOver = state;
        if (this.mouseOver != null) {
            this.multiplyColor = Minecraft.func_71410_x().func_184125_al().func_186724_a(this.mouseOver, (IBlockAccess)Minecraft.func_71410_x().field_71441_e, Minecraft.func_71410_x().field_71476_x.func_178782_a(), 0);
        }
        ISecretTileEntity.getMap((World)Minecraft.func_71410_x().field_71441_e).put(pos, this.mouseOver);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.lookPos.func_177958_n());
        buf.writeInt(this.lookPos.func_177956_o());
        buf.writeInt(this.lookPos.func_177952_p());
        if (this.mouseOver != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.mouseOver.func_177230_c().getRegistryName().toString());
            buf.writeInt(this.mouseOver.func_177230_c().func_176201_c(this.mouseOver));
        } else {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)"");
            buf.writeInt(0);
        }
        buf.writeInt(this.multiplyColor);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.lookPos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        Block testBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf)));
        int meta = buf.readInt();
        if (testBlock != Blocks.field_150350_a) {
            this.mouseOver = testBlock.func_176203_a(meta);
        }
        this.multiplyColor = buf.readInt();
    }

    @Override
    public void onReceived(MessagePacketFakeBlockPlaced message, EntityPlayer player) {
        ISecretTileEntity.getMap(player.field_70170_p).put(message.pos, message.mouseOver);
        ServerRecievePacketHandler.UPDATE_MAP.put(message.pos, new ServerRecievePacketHandler.ObjectInfo(message.mouseOver, message.lookPos));
    }
}

