/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretroomsmod.blocks;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.wynprice.secretroomsmod.SecretBlocks;
import com.wynprice.secretroomsmod.base.interfaces.ISecretBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockObserver;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SecretRedstone
extends Block
implements ISecretBlock {
    public static final PropertyInteger POWER = BlockRedstoneWire.field_176351_O;
    private final Set<BlockPos> blocksNeedingUpdate = Sets.newHashSet();
    private boolean canProvidePower = true;

    public SecretRedstone() {
        super(Material.field_151594_q);
        this.setRegistryName("secret_redstone");
        this.func_149663_c("secret_redstone");
        this.func_149711_c(0.5f);
        this.field_149785_s = true;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(0)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ISecretBlock.super.getBoundingBox(state, source, pos);
    }

    @Override
    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)SecretBlocks.FAKE_REDSTONE);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(SecretBlocks.FAKE_REDSTONE);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        ISecretBlock.super.addCollisionBoxToList(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
    }

    @Override
    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        return ISecretBlock.super.getSoundType(state, world, pos, entity);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return ISecretBlock.super.getBlockFaceShape(worldIn, state, pos, face);
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return ISecretBlock.super.getBlockHardness(blockState, worldIn, pos);
    }

    @Override
    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return ISecretBlock.super.isSideSolid(base_state, world, pos, side);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return ISecretBlock.super.addHitEffects(state, worldObj, target, manager);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return ISecretBlock.super.addDestroyEffects(world, pos, manager);
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return ISecretBlock.super.canRenderInLayer(state, layer);
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return super.getExtendedState(ISecretBlock.super.getExtendedState(state, world, pos), world, pos);
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{POWER}, new IUnlistedProperty[]{RENDER_PROPERTY});
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149662_c(IBlockState state) {
        return ISecretBlock.super.isOpaqueCube(state);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_185485_f(IBlockState state) {
        return ISecretBlock.super.getAmbientOcclusionLightValue(state);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return true;
    }

    private IBlockState updateSurroundingRedstone(World worldIn, BlockPos pos, IBlockState state) {
        state = this.calculateCurrentChanges(worldIn, pos, pos, state);
        ArrayList list = Lists.newArrayList(this.blocksNeedingUpdate);
        this.blocksNeedingUpdate.clear();
        for (BlockPos blockpos : list) {
            worldIn.func_175685_c(blockpos, (Block)this, false);
        }
        return state;
    }

    public boolean func_149744_f(IBlockState state) {
        return this.canProvidePower;
    }

    private IBlockState calculateCurrentChanges(World worldIn, BlockPos pos1, BlockPos pos2, IBlockState state) {
        IBlockState iblockstate = state;
        int i = (Integer)state.func_177229_b((IProperty)POWER);
        int j = 0;
        j = this.getMaxCurrentStrength(worldIn, pos2, j);
        this.canProvidePower = false;
        int k = worldIn.func_175687_A(pos1);
        this.canProvidePower = true;
        if (k > 0 && k > j - 1) {
            j = k;
        }
        int l = 0;
        for (EnumFacing enumfacing : EnumFacing.field_82609_l) {
            BlockPos blockpos = pos1.func_177972_a(enumfacing);
            if (blockpos.func_177958_n() == pos2.func_177958_n() && blockpos.func_177952_p() == pos2.func_177952_p() && blockpos.func_177956_o() == pos2.func_177956_o()) continue;
            l = this.getMaxCurrentStrength(worldIn, blockpos, l);
        }
        j = l > j ? l - 1 : (j > 0 ? --j : 0);
        if (k > j - 1) {
            j = k;
        }
        if (i != j) {
            state = state.func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(j));
            if (worldIn.func_180495_p(pos1) == iblockstate) {
                worldIn.func_180501_a(pos1, state, 2);
            }
            this.blocksNeedingUpdate.add(pos1);
            for (EnumFacing enumfacing1 : EnumFacing.values()) {
                this.blocksNeedingUpdate.add(pos1.func_177972_a(enumfacing1));
            }
        }
        return state;
    }

    private void notifyWireNeighborsOfStateChange(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177230_c() instanceof BlockRedstoneWire || worldIn.func_180495_p(pos).func_177230_c() == this) {
            worldIn.func_175685_c(pos, (Block)this, false);
            for (EnumFacing enumfacing : EnumFacing.values()) {
                worldIn.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, false);
            }
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            this.updateSurroundingRedstone(worldIn, pos, state);
            for (EnumFacing enumfacing : EnumFacing.Plane.VERTICAL) {
                worldIn.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, false);
            }
            for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
                this.notifyWireNeighborsOfStateChange(worldIn, pos.func_177972_a(enumfacing1));
            }
            for (EnumFacing enumfacing2 : EnumFacing.Plane.HORIZONTAL) {
                BlockPos blockpos = pos.func_177972_a(enumfacing2);
                if (worldIn.func_180495_p(blockpos).func_185915_l()) {
                    this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177984_a());
                    continue;
                }
                this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177977_b());
            }
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        if (!worldIn.field_72995_K) {
            for (EnumFacing enumfacing : EnumFacing.values()) {
                worldIn.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, false);
            }
            this.updateSurroundingRedstone(worldIn, pos, state);
            for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
                this.notifyWireNeighborsOfStateChange(worldIn, pos.func_177972_a(enumfacing1));
            }
            for (EnumFacing enumfacing2 : EnumFacing.Plane.HORIZONTAL) {
                BlockPos blockpos = pos.func_177972_a(enumfacing2);
                if (worldIn.func_180495_p(blockpos).func_185915_l()) {
                    this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177984_a());
                    continue;
                }
                this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177977_b());
            }
        }
    }

    private int getMaxCurrentStrength(World worldIn, BlockPos pos, int strength) {
        if (!(worldIn.func_180495_p(pos).func_177230_c() instanceof BlockRedstoneWire) && worldIn.func_180495_p(pos).func_177230_c() != this) {
            return strength;
        }
        int i = (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)POWER);
        if (worldIn.func_180495_p(pos).func_177230_c() == Blocks.field_150488_af) {
            --i;
        }
        return i > strength ? i : strength;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K) {
            if (this.func_176196_c(worldIn, pos)) {
                this.updateSurroundingRedstone(worldIn, pos, state);
            } else {
                this.func_176226_b(worldIn, pos, state, 0);
                worldIn.func_175698_g(pos);
            }
        }
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        boolean sidesPowered = false;
        for (EnumFacing face : EnumFacing.values()) {
            if (face == side || face == side.func_176734_d() || !blockAccess.func_180495_p(pos.func_177972_a(face)).func_177230_c().canConnectRedstone(blockAccess.func_180495_p(pos.func_177972_a(face)), blockAccess, pos.func_177972_a(face), face.func_176734_d())) continue;
            sidesPowered = true;
        }
        return sidesPowered ? 0 : this.func_180656_a(blockState, blockAccess, pos, side);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!this.canProvidePower) {
            return 0;
        }
        int ret = 0;
        int i = (Integer)blockState.func_177229_b((IProperty)POWER);
        if (i == 0) {
            ret = 0;
        }
        return (ret = i) < 1 ? 0 : ret - 1;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)POWER);
    }

    private boolean isPowerSourceAt(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        BlockPos blockpos = pos.func_177972_a(side);
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        boolean flag = iblockstate.func_185915_l();
        boolean flag1 = worldIn.func_180495_p(pos.func_177984_a()).func_185915_l();
        if (!flag1 && flag && SecretRedstone.canConnectUpwardsTo(worldIn, blockpos.func_177984_a())) {
            return true;
        }
        if (SecretRedstone.canConnectTo(iblockstate, side, worldIn, pos)) {
            return true;
        }
        if (iblockstate.func_177230_c() == Blocks.field_150416_aS && iblockstate.func_177229_b((IProperty)BlockRedstoneDiode.field_185512_D) == side) {
            return true;
        }
        return !flag && SecretRedstone.canConnectUpwardsTo(worldIn, blockpos.func_177977_b());
    }

    protected static boolean canConnectUpwardsTo(IBlockAccess worldIn, BlockPos pos) {
        return SecretRedstone.canConnectTo(worldIn.func_180495_p(pos), null, worldIn, pos);
    }

    protected static boolean canConnectTo(IBlockState blockState, @Nullable EnumFacing side, IBlockAccess world, BlockPos pos) {
        Block block = blockState.func_177230_c();
        if (block == Blocks.field_150488_af) {
            return true;
        }
        if (Blocks.field_150413_aR.func_185547_C(blockState)) {
            EnumFacing enumfacing = (EnumFacing)blockState.func_177229_b((IProperty)BlockRedstoneRepeater.field_185512_D);
            return enumfacing == side || enumfacing.func_176734_d() == side;
        }
        if (Blocks.field_190976_dk == blockState.func_177230_c()) {
            return side == blockState.func_177229_b((IProperty)BlockObserver.field_176387_N);
        }
        return blockState.func_177230_c().canConnectRedstone(blockState, world, pos, side);
    }

    @Override
    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return ISecretBlock.super.canCreatureSpawn(state, world, pos, type);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return ISecretBlock.super.getActualState(state, worldIn, pos, super.func_176221_a(state, worldIn, pos));
    }

    @Override
    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return ISecretBlock.super.canHarvestBlock(world, pos, player);
    }

    @Override
    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return ISecretBlock.super.canBeConnectedTo(world, pos, facing);
    }

    @Override
    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ISecretBlock.super.getLightOpacity(state, world, pos);
    }

    @Override
    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ISecretBlock.super.getLightValue(state, world, pos);
    }

    @Override
    public String getHarvestTool(IBlockState state) {
        return ISecretBlock.super.getHarvestTool(state);
    }

    @Override
    public int getHarvestLevel(IBlockState state) {
        return ISecretBlock.super.getHarvestLevel(state);
    }

    @Override
    public boolean addRunningEffects(IBlockState state, World world, BlockPos pos, Entity entity) {
        return ISecretBlock.super.addRunningEffects(state, world, pos, entity);
    }

    @Override
    public boolean addLandingEffects(IBlockState state, WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        return ISecretBlock.super.addLandingEffects(state, worldObj, blockPosition, iblockstate, entity, numberOfParticles);
    }

    @Override
    public float getSlipperiness(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return ISecretBlock.super.getSlipperiness(state, world, pos, entity);
    }

    @Override
    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ISecretBlock.super.canPlaceTorchOnTop(state, world, pos);
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        return ISecretBlock.super.collisionRayTrace(blockState, worldIn, pos, start, end);
    }

    public int func_185484_c(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ISecretBlock.super.getPackedLightmapCoords(state, source, pos);
    }
}

