/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretroomsmod.core;

import com.wynprice.secretroomsmod.core.SecretRoomsCore;
import java.util.function.Consumer;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.common.FMLLog;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class SecretRoomsTransformer
implements IClassTransformer {
    private final Consumer<ClassNode> RenderChunk = node -> {
        for (MethodNode methodNode : node.methods) {
            if (!methodNode.name.equals(this.getName("rebuildChunk", "func_178581_b"))) continue;
            for (int i = 0; i < methodNode.instructions.size(); ++i) {
                MethodInsnNode mIns;
                AbstractInsnNode ins = methodNode.instructions.get(i);
                if (!(ins instanceof MethodInsnNode) || (mIns = (MethodInsnNode)ins).getOpcode() != 182 || !mIns.owner.equals("ChunkCacheOF") && !mIns.owner.equals("net/minecraft/world/ChunkCache") || !mIns.name.equals(this.getName("getBlockState", "func_180495_p")) || !mIns.desc.equals("(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;")) continue;
                methodNode.instructions.set(ins, (AbstractInsnNode)new MethodInsnNode(184, "com/wynprice/secretroomsmod/core/SecretRoomsHooksClient", "getBlockState", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;", false));
                return;
            }
        }
    };
    private final Consumer<ClassNode> StateImplementation = node -> {
        for (MethodNode methodNode : node.methods) {
            MethodInsnNode mIns;
            AbstractInsnNode ins;
            if (methodNode.name.equals("doesSideBlockRendering")) {
                AbstractInsnNode startLabel = methodNode.instructions.getFirst();
                AbstractInsnNode lineNumberLabel = methodNode.instructions.get(1);
                AbstractInsnNode endLabel = methodNode.instructions.getLast();
                InsnList list = new InsnList();
                list.add(startLabel);
                list.add(lineNumberLabel);
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/block/state/BlockStateContainer$StateImplementation", this.getName("block", "field_177239_a"), "Lnet/minecraft/block/Block;"));
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)new VarInsnNode(25, 1));
                list.add((AbstractInsnNode)new VarInsnNode(25, 2));
                list.add((AbstractInsnNode)new VarInsnNode(25, 3));
                list.add((AbstractInsnNode)new MethodInsnNode(184, "com/wynprice/secretroomsmod/core/SecretRoomsHooksClient", "doesSideBlockRendering", "(Lnet/minecraft/block/Block;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)Z", false));
                list.add((AbstractInsnNode)new InsnNode(172));
                list.add(endLabel);
                methodNode.instructions = list;
                continue;
            }
            if (methodNode.name.equals(this.getName("shouldSideBeRendered", "func_185894_c"))) {
                for (int i = 0; i < methodNode.instructions.size(); ++i) {
                    ins = methodNode.instructions.get(i);
                    if (!(ins instanceof MethodInsnNode) || (mIns = (MethodInsnNode)ins).getOpcode() != 182 || !mIns.owner.equals("net/minecraft/block/Block") || !mIns.name.equals(this.getName("shouldSideBeRendered", "func_176225_a")) || !mIns.desc.equals("(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)Z")) continue;
                    methodNode.instructions.set(ins, (AbstractInsnNode)new MethodInsnNode(184, "com/wynprice/secretroomsmod/core/SecretRoomsHooksClient", "shouldSideBeRendered", "(Lnet/minecraft/block/Block;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)Z", false));
                }
                continue;
            }
            if (!methodNode.name.equals(this.getName("addCollisionBoxToList", "func_185908_a"))) continue;
            for (int i = 0; i < methodNode.instructions.size(); ++i) {
                ins = methodNode.instructions.get(i);
                if (!(ins instanceof MethodInsnNode) || (mIns = (MethodInsnNode)ins).getOpcode() != 182 || !mIns.owner.equals("net/minecraft/block/Block") || !mIns.name.equals(this.getName("addCollisionBoxToList", "func_185477_a")) || !mIns.desc.equals("(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/AxisAlignedBB;Ljava/util/List;Lnet/minecraft/entity/Entity;Z)V")) continue;
                methodNode.instructions.set(ins, (AbstractInsnNode)new MethodInsnNode(184, "com/wynprice/secretroomsmod/core/SecretRoomsHooks", "addCollisionBoxToList", "(Lnet/minecraft/block/Block;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/AxisAlignedBB;Ljava/util/List;Lnet/minecraft/entity/Entity;Z)V", false));
            }
        }
    };
    private final Consumer<ClassNode> BlockModelRenderer = node -> {
        for (MethodNode methodNode : node.methods) {
            if (!methodNode.name.equals(this.getName("renderModel", "func_187493_a")) || !methodNode.desc.equals("(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/client/renderer/block/model/IBakedModel;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/client/renderer/BufferBuilder;ZJ)Z")) continue;
            methodNode.instructions.insert((AbstractInsnNode)new VarInsnNode(58, 2));
            methodNode.instructions.insert((AbstractInsnNode)new MethodInsnNode(184, "com/wynprice/secretroomsmod/core/SecretRoomsHooksClient", "getActualModel", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/client/renderer/block/model/IBakedModel;)Lnet/minecraft/client/renderer/block/model/IBakedModel;", false));
            methodNode.instructions.insert((AbstractInsnNode)new VarInsnNode(25, 2));
            methodNode.instructions.insert((AbstractInsnNode)new VarInsnNode(25, 4));
            methodNode.instructions.insert((AbstractInsnNode)new VarInsnNode(25, 1));
            return;
        }
    };
    private final Consumer<ClassNode> BlockRendererDispatcher = node -> {
        for (MethodNode methodNode : node.methods) {
            if (!methodNode.name.equals(this.getName("renderBlock", "func_175018_a")) || !methodNode.desc.equals("(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/client/renderer/BufferBuilder;)Z")) continue;
            methodNode.instructions.insert((AbstractInsnNode)new VarInsnNode(58, 1));
            methodNode.instructions.insert((AbstractInsnNode)new MethodInsnNode(184, "com/wynprice/secretroomsmod/core/SecretRoomsHooksClient", "getActualState", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Lnet/minecraft/block/state/IBlockState;", false));
            methodNode.instructions.insert((AbstractInsnNode)new VarInsnNode(25, 1));
            methodNode.instructions.insert((AbstractInsnNode)new VarInsnNode(25, 2));
            methodNode.instructions.insert((AbstractInsnNode)new VarInsnNode(25, 3));
            return;
        }
    };
    private final Consumer<ClassNode> BlockBreakable = node -> {
        for (MethodNode methodNode : node.methods) {
            if (!methodNode.name.equals(this.getName("shouldSideBeRendered", "func_176225_a")) || !methodNode.desc.equals("(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)Z")) continue;
            AbstractInsnNode startLabel = methodNode.instructions.getFirst();
            AbstractInsnNode lineNumberLabel = methodNode.instructions.get(1);
            AbstractInsnNode endLabel = methodNode.instructions.getLast();
            InsnList list = new InsnList();
            list.add(startLabel);
            list.add(lineNumberLabel);
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)new VarInsnNode(25, 3));
            list.add((AbstractInsnNode)new VarInsnNode(25, 4));
            list.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/util/math/BlockPos", this.getName("offset", "func_177972_a"), "(Lnet/minecraft/util/EnumFacing;)Lnet/minecraft/util/math/BlockPos;", false));
            list.add((AbstractInsnNode)new MethodInsnNode(185, "net/minecraft/world/IBlockAccess", this.getName("getBlockState", "func_180495_p"), "(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;", true));
            LabelNode label32 = new LabelNode();
            list.add((AbstractInsnNode)new JumpInsnNode(165, label32));
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)new VarInsnNode(25, 3));
            list.add((AbstractInsnNode)new VarInsnNode(25, 4));
            list.add((AbstractInsnNode)new MethodInsnNode(183, "net/minecraft/block/Block", this.getName("shouldSideBeRendered", "func_176225_a"), "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)Z", false));
            list.add((AbstractInsnNode)new JumpInsnNode(153, label32));
            list.add((AbstractInsnNode)new InsnNode(4));
            LabelNode label33 = new LabelNode();
            list.add((AbstractInsnNode)new JumpInsnNode(167, label33));
            list.add((AbstractInsnNode)label32);
            list.add((AbstractInsnNode)new InsnNode(3));
            list.add((AbstractInsnNode)label33);
            list.add((AbstractInsnNode)new InsnNode(172));
            list.add(endLabel);
            methodNode.instructions = list;
            return;
        }
    };

    public SecretRoomsTransformer() {
        FMLLog.info((String)"[SecretRoomsTransformer] Registered", (Object[])new Object[0]);
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraft.client.renderer.chunk.RenderChunk")) {
            basicClass = this.runConsumer(this.RenderChunk, transformedName, basicClass);
        } else if (transformedName.equals("net.minecraft.block.state.BlockStateContainer$StateImplementation")) {
            basicClass = this.runConsumer(this.StateImplementation, transformedName, basicClass);
        } else if (transformedName.equals("net.minecraft.client.renderer.BlockModelRenderer")) {
            basicClass = this.runConsumer(this.BlockModelRenderer, transformedName, basicClass);
        } else if (transformedName.equals("net.minecraft.client.renderer.BlockRendererDispatcher")) {
            basicClass = this.runConsumer(this.BlockRendererDispatcher, transformedName, basicClass);
        } else if (transformedName.equals("net.minecraft.block.BlockBreakable")) {
            basicClass = this.runConsumer(this.BlockBreakable, transformedName, basicClass);
        }
        return basicClass;
    }

    private byte[] runConsumer(Consumer<ClassNode> cons, String transformedName, byte[] basicClass) {
        FMLLog.info((String)("[SecretRoomsTransformer] Running Transform on " + transformedName), (Object[])new Object[0]);
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(basicClass);
        reader.accept((ClassVisitor)node, 0);
        cons.accept(node);
        ClassWriter writer = new ClassWriter(3);
        node.accept((ClassVisitor)writer);
        byte[] abyte = writer.toByteArray();
        FMLLog.info((String)("[SecretRoomsTransformer] Finished Transform on: " + transformedName), (Object[])new Object[0]);
        return abyte;
    }

    private String getName(String workspaceName, String mcpName) {
        return SecretRoomsCore.isDebofEnabled ? mcpName : workspaceName;
    }
}

