/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretroomsmod.integration.malisisdoors;

import com.wynprice.secretroomsmod.SecretRooms5;
import com.wynprice.secretroomsmod.handler.HandlerModContainer;
import com.wynprice.secretroomsmod.integration.malisisdoors.DescriptorFactory;
import com.wynprice.secretroomsmod.integration.malisisdoors.registries.blocks.SecretMalisisDoorBlock;
import com.wynprice.secretroomsmod.integration.malisisdoors.registries.blocks.SecretMalisisTrapDoorBlock;
import com.wynprice.secretroomsmod.integration.malisisdoors.registries.items.SecretMalisiItemDoor;
import com.wynprice.secretroomsmod.integration.malisisdoors.registries.tileentities.SecretMalisisTileEntityDoor;
import com.wynprice.secretroomsmod.integration.malisisdoors.registries.tileentities.SecretMalisisTileEntityTrapDoor;
import net.malisis.doors.DoorDescriptor;
import net.malisis.doors.DoorRegistry;
import net.malisis.doors.TrapDoorDescriptor;
import net.malisis.doors.movement.TrapDoorMovement;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class SecretCompactMalisisDoors {
    private static final DoorDescriptor wooden_desc = SecretCompactMalisisDoors.createDoorDescriptor(DoorDescriptor.class, () -> {
        Loader.instance().setActiveModContainer(HandlerModContainer.getContainer("malisisdoors"));
        DoorDescriptor door = new DoorDescriptor();
        Loader.instance().setActiveModContainer(HandlerModContainer.getContainer("secretroomsmod"));
        door.setName("secret_wooden_door");
        door.setTab(SecretRooms5.TAB);
        door.setTextureName("secretroomsmod", "secret_wooden_door");
        return door;
    });
    private static final DoorDescriptor iron_desc = SecretCompactMalisisDoors.createDoorDescriptor(DoorDescriptor.class, () -> {
        DoorDescriptor door = new DoorDescriptor();
        door.setName("secret_iron_door");
        door.setTab(SecretRooms5.TAB);
        door.setTextureName("secretroomsmod", "secret_iron_door");
        door.setRedstoneBehavior(DoorDescriptor.RedstoneBehavior.REDSTONE_ONLY);
        return door;
    });
    private static final TrapDoorDescriptor wooden_trap_desc = SecretCompactMalisisDoors.createDoorDescriptor(TrapDoorDescriptor.class, () -> {
        TrapDoorDescriptor desc = new TrapDoorDescriptor();
        desc.setName("secret_wooden_trapdoor");
        desc.setTab(SecretRooms5.TAB);
        desc.setTextureName("secretroomsmod", "items/secret_wooden_trapdoor");
        desc.setMaterial(Material.field_151575_d);
        desc.setMovement(DoorRegistry.getMovement(TrapDoorMovement.class));
        return desc;
    });
    private static final TrapDoorDescriptor iron_trap_desc = SecretCompactMalisisDoors.createDoorDescriptor(TrapDoorDescriptor.class, () -> {
        TrapDoorDescriptor desc = new TrapDoorDescriptor();
        desc.setName("secret_iron_trapdoor");
        desc.setTab(SecretRooms5.TAB);
        desc.setTextureName("secretroomsmod", "items/secret_iron_trapdoor");
        desc.setMaterial(Material.field_151573_f);
        desc.setRedstoneBehavior(DoorDescriptor.RedstoneBehavior.REDSTONE_ONLY);
        desc.setMovement(DoorRegistry.getMovement(TrapDoorMovement.class));
        return desc;
    });
    public static final Block WOODEN_DOOR = new SecretMalisisDoorBlock(wooden_desc);
    public static final Item WOODEN_DOOR_ITEM = new SecretMalisiItemDoor(wooden_desc);
    public static final Block IRON_DOOR = new SecretMalisisDoorBlock(iron_desc);
    public static final Item IRON_DOOR_ITEM = new SecretMalisiItemDoor(iron_desc);
    public static final Block WOODEN_TRAPDOOR = new SecretMalisisTrapDoorBlock(wooden_trap_desc);
    public static final Block IRON_TRAPDOOR = new SecretMalisisTrapDoorBlock(iron_trap_desc);

    private static <T extends DoorDescriptor> T createDoorDescriptor(Class<T> clas, DescriptorFactory<T> factory) {
        return factory.getDescriptor();
    }

    public static void registerTileEntity() {
        GameRegistry.registerTileEntity(SecretMalisisTileEntityDoor.class, (String)("secretroomsmod" + SecretMalisisTileEntityDoor.class.getSimpleName()));
        GameRegistry.registerTileEntity(SecretMalisisTileEntityTrapDoor.class, (String)("secretroomsmod" + SecretMalisisTileEntityTrapDoor.class.getSimpleName()));
    }
}

