/*
 * Decompiled with CFR 0.152.
 */
package com.github.abrarsyed.secretroomsmod.common;

import com.google.common.base.Throwables;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class BlockLocation {
    public final int x;
    public final int y;
    public final int z;
    public final int dimId;

    public BlockLocation(World world, int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimId = world.field_73011_w.field_76574_g;
    }

    public BlockLocation(int x, int y, int z, int dimid) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimId = dimid;
    }

    public World getWorld() {
        return DimensionManager.getWorld((int)this.dimId);
    }

    public void writeToNbt(NBTTagCompound nbt) {
        nbt.func_74768_a("x", this.x);
        nbt.func_74768_a("y", this.y);
        nbt.func_74768_a("z", this.z);
        nbt.func_74768_a("dim", this.dimId);
    }

    public static BlockLocation readFromNbt(NBTTagCompound nbt) {
        int x = nbt.func_74762_e("x");
        int y = nbt.func_74762_e("y");
        int z = nbt.func_74762_e("z");
        int dim = nbt.func_74762_e("dim");
        return new BlockLocation(x, y, z, dim);
    }

    public void writeToData(DataOutput out, boolean writeWorld) {
        try {
            out.writeInt(this.x);
            out.writeInt(this.y);
            out.writeInt(this.z);
            if (writeWorld) {
                out.writeInt(this.dimId);
            }
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
            e.printStackTrace();
        }
    }

    public static BlockLocation readFromData(DataInput in, boolean readWorld, int dim) {
        try {
            return new BlockLocation(in.readInt(), in.readInt(), in.readInt(), readWorld ? in.readInt() : dim);
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
            return null;
        }
    }

    public String toString() {
        return "" + this.x + ", " + this.y + ", " + this.z + ", DIM" + this.dimId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dimId;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        BlockLocation other = (BlockLocation)obj;
        if (this.dimId != other.dimId) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }
}

