/*
 * Decompiled with CFR 0.152.
 */
package com.github.AbrarSyed.secretroomsmod.common;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockHolder {
    private final NBTTagCompound nbt;
    public int blockID;
    public final int metadata;

    public BlockHolder(IBlockAccess world, int x, int y, int z) {
        this.blockID = world.func_72798_a(x, y, z);
        this.metadata = world.func_72805_g(x, y, z);
        TileEntity te = world.func_72796_p(x, y, z);
        if (te != null) {
            this.nbt = new NBTTagCompound();
            te.func_70310_b(this.nbt);
            this.nbt.func_74768_a("x", 0);
            this.nbt.func_74768_a("y", 0);
            this.nbt.func_74768_a("z", 0);
        } else {
            this.nbt = null;
        }
    }

    public BlockHolder(int ID, int meta, NBTTagCompound nbt) {
        this.nbt = nbt;
        this.blockID = ID;
        this.metadata = meta;
    }

    public TileEntity getTileEntity(World world, int x, int y, int z) {
        if (this.blockID == 0 || this.nbt == null) {
            return null;
        }
        TileEntity te = TileEntity.func_70317_c((NBTTagCompound)this.nbt);
        te.field_70331_k = world;
        te.field_70329_l = x;
        te.field_70330_m = y;
        te.field_70327_n = z;
        return te;
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74768_a("copyID", this.blockID);
        compound.func_74768_a("copyMeta", this.metadata);
        compound.func_74757_a("hasCopyTE", this.nbt != null);
        if (this.nbt != null) {
            compound.func_74766_a("copyTE", this.nbt);
        }
    }

    public boolean equals(Object equals) {
        return false;
    }

    public boolean equals(BlockHolder holder) {
        if (holder == null) {
            return false;
        }
        boolean compound = false;
        compound = this.nbt == null || holder.nbt == null ? this.nbt == holder.nbt : this.nbt.equals((Object)holder.nbt);
        return this.blockID == holder.blockID && this.metadata == holder.metadata && compound;
    }

    public static BlockHolder buildFromNBT(NBTTagCompound nbt) {
        int ID = nbt.func_74762_e("copyID");
        int meta = nbt.func_74762_e("copyMeta");
        NBTTagCompound nbtNew = null;
        boolean hasNBT = nbt.func_74767_n("hasCopyTE");
        if (hasNBT) {
            nbtNew = nbt.func_74775_l("copyTE");
        }
        return new BlockHolder(ID, meta, nbtNew);
    }
}

