/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats;

import com.github.mnesikos.simplycats.CatDataFixer;
import com.github.mnesikos.simplycats.NetworkGuiHandler;
import com.github.mnesikos.simplycats.Ref;
import com.github.mnesikos.simplycats.SCNetworking;
import com.github.mnesikos.simplycats.block.CatBlocks;
import com.github.mnesikos.simplycats.client.render.entity.RenderCat;
import com.github.mnesikos.simplycats.commands.CommandCatCount;
import com.github.mnesikos.simplycats.entity.EntityCat;
import com.github.mnesikos.simplycats.event.SCEvents;
import com.github.mnesikos.simplycats.init.CatSounds;
import com.github.mnesikos.simplycats.item.CatItems;
import com.github.mnesikos.simplycats.tileentity.TileEntityCatBowl;
import com.github.mnesikos.simplycats.worldgen.villages.CatProfessions;
import com.github.mnesikos.simplycats.worldgen.villages.ComponentPetShelter;
import com.github.mnesikos.simplycats.worldgen.villages.VillagePetShelterHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="simplycats", name="Simply Cats", version="1.12.2-0.0.4.1", acceptedMinecraftVersions="[1.12.2]")
public class SimplyCats {
    @Mod.Instance
    public static SimplyCats instance;
    public static final int FIXER_VERSION = 5;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)new SCEvents());
        SCNetworking.CHANNEL.registerMessage(SCNetworking::onMessage, SCNetworking.class, 0, Side.CLIENT);
        int ENTITY_ID = 0;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("simplycats:cat"), EntityCat.class, (String)"Cat", (int)ENTITY_ID++, (Object)instance, (int)80, (int)1, (boolean)true);
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            RenderingRegistry.registerEntityRenderingHandler(EntityCat.class, RenderCat::new);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        CatItems.registerOres();
        ModFixs fixer = FMLCommonHandler.instance().getDataFixer().init("simplycats", 5);
        fixer.registerFix((IFixType)FixTypes.ENTITY, (IFixableData)new CatDataFixer());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)NetworkGuiHandler.INSTANCE);
        CatProfessions.associateCareersAndTrades();
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillagePetShelterHandler());
        MapGenStructureIO.func_143031_a(ComponentPetShelter.class, (String)"simplycats:PetShelterStructure");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        Ref.registerCatFoods();
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandCatCount());
    }

    @Mod.EventBusSubscriber
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            CatBlocks.BLOCKS.forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
            GameRegistry.registerTileEntity(TileEntityCatBowl.class, (ResourceLocation)new ResourceLocation("simplycats", "cat_bowl"));
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            CatItems.ITEMS.forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
            if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
                CatItems.collectModelVariants();
            }
        }

        @SubscribeEvent
        public static void registerModels(ModelRegistryEvent event) {
            for (CatItems.ItemVariant variant : CatItems.VARIANTS) {
                ModelLoader.setCustomModelResourceLocation((Item)variant.item, (int)variant.meta, (ModelResourceLocation)new ModelResourceLocation("simplycats:" + variant.name, "inventory"));
            }
        }

        @SubscribeEvent
        public static void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
            event.getRegistry().register((IForgeRegistryEntry)CatSounds.SHAKE_TREATS);
        }
    }
}

