/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.block;

import com.github.mnesikos.simplycats.entity.EntityCat;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCatTree
extends Block {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    protected final AxisAlignedBB axisAlignedBB;

    public BlockCatTree(EnumDyeColor color, AxisAlignedBB axisAlignedBB) {
        super(Material.field_151580_n, MapColor.func_193558_a((EnumDyeColor)color));
        this.axisAlignedBB = axisAlignedBB;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return entity instanceof EntityCat;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.axisAlignedBB;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public static class Bed
    extends Facing {
        protected static final AxisAlignedBB AABB_BOTTOM = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);

        public Bed(EnumDyeColor color, AxisAlignedBB axisAlignedBB) {
            super(color, axisAlignedBB);
        }

        public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
            Bed.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BOTTOM);
        }
    }

    public static class Box
    extends Facing {
        protected static final AxisAlignedBB AABB_BOTTOM = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
        protected static final AxisAlignedBB AABB_TOP = new AxisAlignedBB(0.0, 0.875, 0.0, 1.0, 1.0, 1.0);
        protected static final AxisAlignedBB AABB_WALL_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
        protected static final AxisAlignedBB AABB_WALL_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
        protected static final AxisAlignedBB AABB_WALL_EAST = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
        protected static final AxisAlignedBB AABB_WALL_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);

        public Box(EnumDyeColor color) {
            super(color, field_185505_j);
        }

        public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
            EnumFacing enumFacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            Box.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BOTTOM);
            Box.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_TOP);
            if (enumFacing != EnumFacing.WEST) {
                Box.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_WEST);
            }
            if (enumFacing != EnumFacing.EAST) {
                Box.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_EAST);
            }
            if (enumFacing != EnumFacing.SOUTH) {
                Box.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_SOUTH);
            }
            if (enumFacing != EnumFacing.NORTH) {
                Box.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_NORTH);
            }
        }

        public boolean func_185481_k(IBlockState state) {
            return true;
        }
    }

    public static class Facing
    extends BlockCatTree {
        public Facing(EnumDyeColor color, AxisAlignedBB axisAlignedBB) {
            super(color, axisAlignedBB);
            this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        }

        public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
            EnumFacing enumFacing = placer.func_174811_aO().func_176734_d();
            return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)FACING, (Comparable)enumFacing);
        }

        public IBlockState func_176203_a(int meta) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
        }

        public int func_176201_c(IBlockState state) {
            int i = 0;
            return i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        }

        public IBlockState func_185499_a(IBlockState state, Rotation rot) {
            return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
        }

        protected BlockStateContainer func_180661_e() {
            return new BlockStateContainer((Block)this, new IProperty[]{FACING});
        }
    }
}

