/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLitterBox
extends Block {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyEnum<EnumLevel> LEVEL = PropertyEnum.func_177709_a((String)"level", EnumLevel.class);
    protected static final AxisAlignedBB X_AXIS_AABB = new AxisAlignedBB(0.0, 0.0, 0.125, 1.0, 0.25, 0.875);
    protected static final AxisAlignedBB Z_AXIS_AABB = new AxisAlignedBB(0.125, 0.0, 0.0, 0.875, 0.25, 1.0);

    public BlockLitterBox() {
        super(Material.field_151578_c);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(0.2f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(LEVEL, (Comparable)((Object)EnumLevel.EMPTY)));
    }

    public void setLevel(World world, BlockPos pos, IBlockState state, EnumLevel level) {
        world.func_180501_a(pos, state.func_177226_a(LEVEL, (Comparable)((Object)level)), 2);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = playerIn.func_184586_b(hand);
        EnumLevel level = (EnumLevel)((Object)state.func_177229_b(LEVEL));
        if (level.equals((Object)EnumLevel.EMPTY)) {
            if (itemstack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150354_m)) {
                return false;
            }
            this.setLevel(world, pos, state, EnumLevel.CLEAN);
            if (!playerIn.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
        } else if (level.equals((Object)EnumLevel.CLEAN)) {
            if (itemstack.func_77973_b() == Items.field_151103_aS) {
                this.setLevel(world, pos, state, EnumLevel.DIRTY);
            } else {
                ItemStack returnSand = new ItemStack((Block)Blocks.field_150354_m);
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    if (itemstack.func_190926_b()) {
                        playerIn.func_184611_a(hand, returnSand);
                    } else if (!playerIn.func_191521_c(returnSand)) {
                        playerIn.func_71019_a(returnSand, false);
                    }
                }
                this.setLevel(world, pos, state, EnumLevel.EMPTY);
            }
        } else {
            if (itemstack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150354_m)) {
                return false;
            }
            this.setLevel(world, pos, state, EnumLevel.CLEAN);
            if (!playerIn.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
        }
        return true;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, fortune);
        if (((EnumLevel)((Object)state.func_177229_b(LEVEL))).equals((Object)EnumLevel.CLEAN)) {
            drops.add((Object)new ItemStack((Block)Blocks.field_150354_m));
        }
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing enumfacing = placer.func_174811_aO().func_176746_e();
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a(LEVEL, (Comparable)((Object)EnumLevel.byMetadata(MathHelper.func_76125_a((int)(meta >> 2), (int)0, (int)2))));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a(LEVEL, (Comparable)((Object)EnumLevel.byMetadata((meta & 0xF) >> 2)));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        return i |= ((EnumLevel)((Object)state.func_177229_b(LEVEL))).getMetadata() << 2;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177230_c() != this ? state : state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, LEVEL});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return enumfacing.func_176740_k() == EnumFacing.Axis.X ? X_AXIS_AABB : Z_AXIS_AABB;
    }

    public static enum EnumLevel implements IStringSerializable
    {
        EMPTY(0, "empty"),
        CLEAN(1, "clean"),
        DIRTY(2, "dirty");

        private static final EnumLevel[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final String translationKey;

        private EnumLevel(int metaIn, String nameIn) {
            this(metaIn, nameIn, nameIn);
        }

        private EnumLevel(int metaIn, String nameIn, String unlocalizedNameIn) {
            this.meta = metaIn;
            this.name = nameIn;
            this.translationKey = unlocalizedNameIn;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumLevel byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        static {
            META_LOOKUP = new EnumLevel[EnumLevel.values().length];
            EnumLevel[] enumLevelArray = EnumLevel.values();
            int n = enumLevelArray.length;
            for (int i = 0; i < n; ++i) {
                EnumLevel state;
                EnumLevel.META_LOOKUP[state.getMetadata()] = state = enumLevelArray[i];
            }
        }
    }
}

