/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.block;

import com.github.mnesikos.simplycats.block.BlockCatBowl;
import com.github.mnesikos.simplycats.block.BlockCatTree;
import com.github.mnesikos.simplycats.block.BlockCropCatnip;
import com.github.mnesikos.simplycats.block.BlockLitterBox;
import com.github.mnesikos.simplycats.block.BlockScratchingPost;
import com.github.mnesikos.simplycats.block.BlockWindowPerch;
import com.github.mnesikos.simplycats.item.CatItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSeeds;
import net.minecraft.util.math.AxisAlignedBB;

public class CatBlocks {
    public static final List<Block> BLOCKS = new ArrayList<Block>();
    public static final BlockCropCatnip CROP_CATNIP = CatBlocks.registerBlock("crop_catnip", new BlockCropCatnip(), block -> new ItemSeeds((Block)block, Blocks.field_150458_ak));
    public static final Map<EnumDyeColor, BlockCatBowl> CAT_BOWLS = new HashMap<EnumDyeColor, BlockCatBowl>();
    public static final Map<EnumDyeColor, BlockLitterBox> LITTER_BOXES = new HashMap<EnumDyeColor, BlockLitterBox>();
    public static final Map<BlockPlanks.EnumType, BlockScratchingPost> SCRATCHING_POSTS = new HashMap<BlockPlanks.EnumType, BlockScratchingPost>();
    public static final Map<BlockPlanks.EnumType, BlockWindowPerch> WINDOW_PERCHES = new HashMap<BlockPlanks.EnumType, BlockWindowPerch>();
    public static final Map<EnumDyeColor, BlockCatTree.Bed> CAT_TREE_BEDS = new HashMap<EnumDyeColor, BlockCatTree.Bed>();
    public static final Map<EnumDyeColor, BlockCatTree> CAT_TREE_POSTS = new HashMap<EnumDyeColor, BlockCatTree>();
    public static final Map<EnumDyeColor, BlockCatTree.Box> CAT_TREE_BOXES = new HashMap<EnumDyeColor, BlockCatTree.Box>();

    public static <T extends Block> T registerBlock(String name, T block) {
        return (T)CatBlocks.registerBlock(name, block, ItemBlock::new);
    }

    public static <T extends Block> T registerBlock(String name, T block, Function<T, Item> itemFunction) {
        block.setRegistryName(name);
        block.func_149663_c("simplycats." + name);
        block.func_149647_a(CatItems.CREATIVE_TAB);
        Item item = itemFunction.apply(block);
        CatItems.registerItem(name, item);
        BLOCKS.add(block);
        return block;
    }

    static {
        for (EnumDyeColor enumDyeColor : EnumDyeColor.values()) {
            CAT_BOWLS.put(enumDyeColor, CatBlocks.registerBlock("cat_bowl_" + enumDyeColor.func_176610_l(), new BlockCatBowl(enumDyeColor)));
            LITTER_BOXES.put(enumDyeColor, CatBlocks.registerBlock("litter_box_" + enumDyeColor.func_176610_l(), new BlockLitterBox()));
            CAT_TREE_BEDS.put(enumDyeColor, CatBlocks.registerBlock("cat_tree_bed_" + enumDyeColor.func_176610_l(), new BlockCatTree.Bed(enumDyeColor, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0))));
            CAT_TREE_POSTS.put(enumDyeColor, CatBlocks.registerBlock("cat_tree_post_" + enumDyeColor.func_176610_l(), new BlockCatTree(enumDyeColor, new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 1.0, 0.6875))));
            CAT_TREE_BOXES.put(enumDyeColor, CatBlocks.registerBlock("cat_tree_box_" + enumDyeColor.func_176610_l(), new BlockCatTree.Box(enumDyeColor)));
        }
        for (EnumDyeColor enumDyeColor : BlockPlanks.EnumType.values()) {
            SCRATCHING_POSTS.put((BlockPlanks.EnumType)enumDyeColor, CatBlocks.registerBlock("scratching_post_" + enumDyeColor.func_176610_l(), new BlockScratchingPost()));
            WINDOW_PERCHES.put((BlockPlanks.EnumType)enumDyeColor, CatBlocks.registerBlock("window_perch_" + enumDyeColor.func_176610_l(), new BlockWindowPerch()));
        }
    }
}

