/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.client.gui;

import com.github.mnesikos.simplycats.entity.EntityCat;
import com.github.mnesikos.simplycats.entity.core.Genetics;
import java.io.IOException;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiCatBook
extends GuiScreen {
    private static final int bookImageHeight = 182;
    private static final int bookImageWidth = 281;
    private static final ResourceLocation BG_TEXTURE = new ResourceLocation("simplycats", "textures/gui/cat_book.png");
    private int bookTotalPages = 1;
    private int currPage;
    private NBTTagList bookPages;
    private NextPageButton buttonNextPage;
    private NextPageButton buttonPreviousPage;
    private HomePageButton buttonHome;
    private AddBookmarkButton buttonAddBookmark;
    private BookmarkButton buttonBookmark;
    public EntityCat cat;
    NBTTagCompound nbt;
    protected int catHealth;
    public static ItemStack book;
    protected final Random rand = new Random();

    public GuiCatBook(EntityCat cat) {
        this();
        this.cat = cat;
        this.nbt = new NBTTagCompound();
        cat.func_189511_e(this.nbt);
    }

    public GuiCatBook() {
        if (book != null) {
            if (book.func_77942_o()) {
                NBTTagCompound nbttagcompound = book.func_77978_p();
                this.bookPages = nbttagcompound.func_150295_c("pages", 10).func_74737_b();
                this.bookTotalPages = this.bookPages.func_74745_c();
                if (this.bookTotalPages < 1) {
                    this.bookPages.func_74742_a((NBTBase)new NBTTagString(""));
                    this.bookTotalPages = 1;
                }
            }
            if (this.bookPages == null) {
                this.bookPages = new NBTTagList();
                this.bookPages.func_74742_a((NBTBase)new NBTTagString(""));
                this.bookTotalPages = 1;
            }
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        int centerX = (this.field_146294_l - 281) / 2;
        this.buttonNextPage = (NextPageButton)this.func_189646_b(new NextPageButton(1, centerX + 236, 157, true));
        this.buttonPreviousPage = (NextPageButton)this.func_189646_b(new NextPageButton(2, centerX + 25, 157, false));
        this.buttonHome = (HomePageButton)this.func_189646_b(new HomePageButton(3, centerX + -3, 18));
        this.buttonAddBookmark = (AddBookmarkButton)this.func_189646_b(new AddBookmarkButton(4, centerX + 116, 153));
        this.buttonBookmark = (BookmarkButton)this.func_189646_b(new BookmarkButton(5, centerX + 268, 18));
        this.updateButtons();
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private void updateButtons() {
        this.buttonNextPage.field_146125_m = this.currPage < this.bookTotalPages - 1;
        this.buttonPreviousPage.field_146125_m = this.currPage > 0;
        this.buttonHome.isActive = this.currPage == 0;
        this.buttonAddBookmark.field_146125_m = this.currPage > 0;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            if (button.field_146127_k == 3) {
                if (this.currPage > 0) {
                    this.currPage = 0;
                }
            } else if (button.field_146127_k == 1) {
                if (this.currPage < this.bookTotalPages - 1) {
                    ++this.currPage;
                }
            } else if (button.field_146127_k == 2) {
                if (this.currPage > 0) {
                    --this.currPage;
                }
            } else if (button.field_146127_k == 4) {
                // empty if block
            }
            this.updateButtons();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int leftX = (this.field_146294_l - 281) / 2;
        int leftCenterX = leftX + 70;
        this.field_146297_k.func_110434_K().func_110577_a(BG_TEXTURE);
        GuiCatBook.func_146110_a((int)leftX, (int)2, (float)0.0f, (float)0.0f, (int)281, (int)182, (float)288.0f, (float)256.0f);
        if (this.cat != null) {
            GuiInventory.func_147046_a((int)(leftX + 40), (int)74, (int)50, (float)(leftX + 51 - mouseX), (float)(50 - mouseY), (EntityLivingBase)this.cat);
            int nameWidth = this.field_146289_q.func_78256_a(this.cat.func_70005_c_());
            this.field_146289_q.func_78276_b(this.cat.func_70005_c_(), leftCenterX - nameWidth / 2, 14, 0);
            String sex = (this.cat.isFixed() ? I18n.func_135052_a((String)"cat.fixed.name", (Object[])new Object[0]) : I18n.func_135052_a((String)"cat.intact.name", (Object[])new Object[0])) + " " + Genetics.Sex.getPrettyName(this.cat.getSex().getName());
            this.field_146289_q.func_78276_b(sex, leftX + 66, 28, 0);
            this.renderCatHealth(leftX + 66, 42);
            String ownerName = "";
            if (this.cat.func_70909_n()) {
                ownerName = this.cat.getOwnerName().func_150254_d();
                this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"tooltip.pet_carrier.owner", (Object[])new Object[]{ownerName}), leftX + 16, 84, 0);
            } else {
                this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"entity.simplycats.cat.untamed", (Object[])new Object[0]), leftX + 16, 84, 0);
            }
            this.field_146289_q.func_78279_b(Genetics.getPhenotypeDescription(this.nbt, false), leftX + 16, 98, 120, 0);
            String eyeColor = TextFormatting.GRAY + this.nbt.func_74779_i("EyeColor");
            String furLength = TextFormatting.GRAY + this.nbt.func_74779_i("FurLength");
            String eumelanin = TextFormatting.GRAY + this.nbt.func_74779_i("Eumelanin");
            String phaeomelanin = TextFormatting.GRAY + this.nbt.func_74779_i("Phaeomelanin");
            String dilution = TextFormatting.GRAY + this.nbt.func_74779_i("Dilution");
            String diluteMod = TextFormatting.GRAY + this.nbt.func_74779_i("DiluteMod");
            String agouti = TextFormatting.GRAY + this.nbt.func_74779_i("Agouti");
            String tabby = TextFormatting.GRAY + this.nbt.func_74779_i("Tabby");
            String spotted = TextFormatting.GRAY + this.nbt.func_74779_i("Spotted");
            String ticked = TextFormatting.GRAY + this.nbt.func_74779_i("Ticked");
            String colorpoint = TextFormatting.GRAY + this.nbt.func_74779_i("Colorpoint");
            String white = TextFormatting.GRAY + this.nbt.func_74779_i("White");
            String bobtail = TextFormatting.GRAY + this.nbt.func_74779_i("Bobtail");
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"book.genetics.eye_color", (Object[])new Object[]{eyeColor}), leftX + 152, 24, 0);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"book.genetics.fur_length", (Object[])new Object[]{furLength}), leftX + 152, 34, 0);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"book.genetics.eumelanin", (Object[])new Object[]{eumelanin}), leftX + 152, 44, 0);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"book.genetics.phaeomelanin", (Object[])new Object[]{phaeomelanin}), leftX + 152, 54, 0);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"book.genetics.dilute", (Object[])new Object[]{dilution}), leftX + 152, 64, 0);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"book.genetics.dilute_modifier", (Object[])new Object[]{diluteMod}), leftX + 152, 74, 0);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"book.genetics.agouti", (Object[])new Object[]{agouti}), leftX + 152, 84, 0);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"book.genetics.tabby", (Object[])new Object[]{tabby}), leftX + 152, 94, 0);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"book.genetics.spotted", (Object[])new Object[]{spotted}), leftX + 152, 104, 0);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"book.genetics.ticked", (Object[])new Object[]{ticked}), leftX + 152, 114, 0);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"book.genetics.colorpoint", (Object[])new Object[]{colorpoint}), leftX + 152, 124, 0);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"book.genetics.white", (Object[])new Object[]{white}), leftX + 152, 134, 0);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"book.genetics.bobtail", (Object[])new Object[]{bobtail}), leftX + 152, 144, 0);
        } else if (book != null) {
            this.field_146289_q.func_78279_b(I18n.func_135052_a((String)"book.index_page.info", (Object[])new Object[0]), leftX + 16, 60, 120, 0);
        } else {
            this.field_146289_q.func_78279_b("Error page, this should not happen, please report to github issue tracker, thanks.", leftX + 16, 60, 120, 0);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void renderCatHealth(int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(field_110324_m);
        this.catHealth = MathHelper.func_76123_f((float)this.cat.func_110143_aJ());
        IAttributeInstance iattributeinstance = this.cat.func_110148_a(SharedMonsterAttributes.field_111267_a);
        float maxHealth = (float)iattributeinstance.func_111126_e();
        int l1 = MathHelper.func_76123_f((float)(maxHealth / 2.0f / 10.0f));
        int i2 = Math.max(10 - (l1 - 2), 3);
        for (int wholeHearts = MathHelper.func_76123_f((float)(maxHealth / 2.0f)) - 1; wholeHearts >= 0; --wholeHearts) {
            int textureX = 16;
            int textureY = 0;
            int j4 = MathHelper.func_76123_f((float)((float)(wholeHearts + 1) / 10.0f)) - 1;
            int guiX = x + wholeHearts % 10 * 8;
            int guiY = y - j4 * i2;
            this.func_73729_b(guiX, guiY, 16 + textureY * 9, 9 * textureY, 9, 9);
            if (wholeHearts * 2 + 1 < this.catHealth) {
                this.func_73729_b(guiX, guiY, textureX + 36, 9 * textureY, 9, 9);
            }
            if (wholeHearts * 2 + 1 != this.catHealth) continue;
            this.func_73729_b(guiX, guiY, textureX + 45, 9 * textureY, 9, 9);
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class BookmarkButton
    extends GuiButton {
        boolean isActive = false;

        BookmarkButton(int buttonId, int x, int y) {
            super(buttonId, x, y, 16, 16, "");
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(BG_TEXTURE);
                int textureX = 3;
                int textureY = 220;
                if (this.isActive) {
                    textureX += 21;
                }
                BookmarkButton.func_146110_a((int)this.field_146128_h, (int)this.field_146129_i, (float)textureX, (float)textureY, (int)this.field_146120_f, (int)this.field_146121_g, (float)288.0f, (float)256.0f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class AddBookmarkButton
    extends GuiButton {
        AddBookmarkButton(int buttonId, int x, int y) {
            super(buttonId, x, y, 15, 15, "");
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean isButtonPressed = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(BG_TEXTURE);
                int textureX = 42;
                int textureY = 220;
                if (isButtonPressed) {
                    textureX += 14;
                }
                AddBookmarkButton.func_146110_a((int)this.field_146128_h, (int)this.field_146129_i, (float)textureX, (float)textureY, (int)this.field_146120_f, (int)this.field_146121_g, (float)288.0f, (float)256.0f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class HomePageButton
    extends GuiButton {
        boolean isActive = false;

        HomePageButton(int buttonId, int x, int y) {
            super(buttonId, x, y, 16, 16, "");
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(BG_TEXTURE);
                int textureX = 3;
                int textureY = 239;
                if (this.isActive) {
                    textureX += 21;
                }
                HomePageButton.func_146110_a((int)this.field_146128_h, (int)this.field_146129_i, (float)textureX, (float)textureY, (int)this.field_146120_f, (int)this.field_146121_g, (float)288.0f, (float)256.0f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class NextPageButton
    extends GuiButton {
        private final boolean isNextButton;

        NextPageButton(int buttonId, int x, int y, boolean nextButton) {
            super(buttonId, x, y, 20, 12, "");
            this.isNextButton = nextButton;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean isButtonPressed = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(BG_TEXTURE);
                int textureX = 2;
                int textureY = 193;
                if (isButtonPressed) {
                    textureX += 23;
                }
                if (!this.isNextButton) {
                    textureY += 13;
                }
                NextPageButton.func_146110_a((int)this.field_146128_h, (int)this.field_146129_i, (float)textureX, (float)textureY, (int)this.field_146120_f, (int)this.field_146121_g, (float)288.0f, (float)256.0f);
            }
        }
    }
}

