/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.entity;

import com.github.mnesikos.simplycats.Ref;
import com.github.mnesikos.simplycats.SCNetworking;
import com.github.mnesikos.simplycats.configuration.SCConfig;
import com.github.mnesikos.simplycats.entity.EntityCat;
import com.github.mnesikos.simplycats.entity.core.Genetics;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractCat
extends EntityTameable {
    private static final DataParameter<String> EYE_COLOR = EntityDataManager.func_187226_a(AbstractCat.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> FUR_LENGTH = EntityDataManager.func_187226_a(AbstractCat.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> EUMELANIN = EntityDataManager.func_187226_a(AbstractCat.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> PHAEOMELANIN = EntityDataManager.func_187226_a(AbstractCat.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> DILUTION = EntityDataManager.func_187226_a(AbstractCat.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> DILUTE_MOD = EntityDataManager.func_187226_a(AbstractCat.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> AGOUTI = EntityDataManager.func_187226_a(AbstractCat.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> TABBY = EntityDataManager.func_187226_a(AbstractCat.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> SPOTTED = EntityDataManager.func_187226_a(AbstractCat.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> TICKED = EntityDataManager.func_187226_a(AbstractCat.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> COLORPOINT = EntityDataManager.func_187226_a(AbstractCat.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> WHITE = EntityDataManager.func_187226_a(AbstractCat.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> BOBTAIL = EntityDataManager.func_187226_a(AbstractCat.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> WHITE_0 = EntityDataManager.func_187226_a(AbstractCat.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> WHITE_1 = EntityDataManager.func_187226_a(AbstractCat.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> WHITE_2 = EntityDataManager.func_187226_a(AbstractCat.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> WHITE_PAWS_0 = EntityDataManager.func_187226_a(AbstractCat.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> WHITE_PAWS_1 = EntityDataManager.func_187226_a(AbstractCat.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> WHITE_PAWS_2 = EntityDataManager.func_187226_a(AbstractCat.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> WHITE_PAWS_3 = EntityDataManager.func_187226_a(AbstractCat.class, (DataSerializer)DataSerializers.field_187194_d);
    private final String[] whiteTexturesArray = new String[3];
    private final String[] whitePawTexturesArray = new String[4];
    private String texturePrefix;
    private final String[] catTexturesArray = new String[12];
    private static final DataParameter<Optional<BlockPos>> HOME_POSITION = EntityDataManager.func_187226_a(AbstractCat.class, (DataSerializer)DataSerializers.field_187201_k);
    public static final DataParameter<String> OWNER_NAME = EntityDataManager.func_187226_a(AbstractCat.class, (DataSerializer)DataSerializers.field_187194_d);
    private boolean PURR;
    private int PURR_TIMER;

    public AbstractCat(World world) {
        super(world);
        this.setPhenotype();
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        return super.func_180482_a(difficulty, livingdata);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(EYE_COLOR, (Object)Genetics.EyeColor.COPPER.toString());
        this.field_70180_af.func_187214_a(FUR_LENGTH, (Object)"L-L");
        this.field_70180_af.func_187214_a(EUMELANIN, (Object)"B-B");
        this.field_70180_af.func_187214_a(PHAEOMELANIN, (Object)"Xo-Xo");
        this.field_70180_af.func_187214_a(DILUTION, (Object)"D-D");
        this.field_70180_af.func_187214_a(DILUTE_MOD, (Object)"dm-dm");
        this.field_70180_af.func_187214_a(AGOUTI, (Object)"a-a");
        this.field_70180_af.func_187214_a(TABBY, (Object)"Mc-Mc");
        this.field_70180_af.func_187214_a(SPOTTED, (Object)"sp-sp");
        this.field_70180_af.func_187214_a(TICKED, (Object)"ta-ta");
        this.field_70180_af.func_187214_a(COLORPOINT, (Object)"C-C");
        this.field_70180_af.func_187214_a(WHITE, (Object)"w-w");
        this.field_70180_af.func_187214_a(BOBTAIL, (Object)"Jb-Jb");
        this.field_70180_af.func_187214_a(WHITE_0, (Object)"");
        this.field_70180_af.func_187214_a(WHITE_1, (Object)"");
        this.field_70180_af.func_187214_a(WHITE_2, (Object)"");
        this.field_70180_af.func_187214_a(WHITE_PAWS_0, (Object)"");
        this.field_70180_af.func_187214_a(WHITE_PAWS_1, (Object)"");
        this.field_70180_af.func_187214_a(WHITE_PAWS_2, (Object)"");
        this.field_70180_af.func_187214_a(WHITE_PAWS_3, (Object)"");
        this.field_70180_af.func_187214_a(HOME_POSITION, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(OWNER_NAME, (Object)"");
    }

    public void setPhenotype() {
        this.setGenotype(FUR_LENGTH, Genetics.FurLength.init() + "-" + Genetics.FurLength.init());
        this.setGenotype(EUMELANIN, Genetics.Eumelanin.init() + "-" + Genetics.Eumelanin.init());
        this.setGenotype(PHAEOMELANIN, Genetics.Phaeomelanin.init());
        this.setGenotype(DILUTION, Genetics.Dilution.init() + "-" + Genetics.Dilution.init());
        this.setGenotype(DILUTE_MOD, Genetics.DiluteMod.init() + "-" + Genetics.DiluteMod.init());
        this.setGenotype(AGOUTI, Genetics.Agouti.init() + "-" + Genetics.Agouti.init());
        this.setGenotype(TABBY, Genetics.Tabby.init() + "-" + Genetics.Tabby.init());
        this.setGenotype(SPOTTED, Genetics.Spotted.init() + "-" + Genetics.Spotted.init());
        this.setGenotype(TICKED, Genetics.Ticked.init() + "-" + Genetics.Ticked.init());
        this.setGenotype(COLORPOINT, Genetics.Colorpoint.init() + "-" + Genetics.Colorpoint.init());
        this.setGenotype(WHITE, Genetics.White.init() + "-" + Genetics.White.init());
        this.setGenotype(BOBTAIL, Genetics.Bobtail.init() + "-" + Genetics.Bobtail.init());
        this.selectWhiteMarkings();
        this.setGenotype(EYE_COLOR, this.selectEyeColor());
    }

    private String selectEyeColor() {
        String color = Genetics.EyeColor.init(this.field_70146_Z.nextInt(4));
        if (this.getGenotype(WHITE).contains(Genetics.White.DOMINANT.getAllele())) {
            color = Genetics.EyeColor.init(this.field_70146_Z.nextInt(5));
        }
        if (this.getPhenotype(COLORPOINT).equalsIgnoreCase(Genetics.Colorpoint.COLORPOINT.toString())) {
            color = Genetics.EyeColor.init(4);
        }
        return color;
    }

    void selectWhiteMarkings() {
        int base;
        int body = 0;
        int face = 0;
        int tail = 0;
        for (int j = 0; j <= 3; ++j) {
            this.whitePawTexturesArray[j] = "";
            this.setWhitePawTextures(j, "");
        }
        switch (this.getGenotype(WHITE)) {
            case "Wd-Wd": 
            case "Wd-w": 
            case "Wd-Ws": 
            case "w-Wd": 
            case "Ws-Wd": {
                base = 6;
                body = 1;
                face = 0;
                tail = 0;
                break;
            }
            case "w-w": {
                base = 0;
                body = 0;
                face = 0;
                tail = 0;
                break;
            }
            case "Ws-Ws": {
                base = this.field_70146_Z.nextInt(2) + 4;
                if (base == 5) {
                    body = this.field_70146_Z.nextInt(4) + 1;
                    face = this.field_70146_Z.nextInt(6) + 1;
                    if (body > 1) {
                        tail = this.field_70146_Z.nextInt(3) + 1;
                    }
                } else if (base == 4) {
                    body = 1;
                    face = this.field_70146_Z.nextInt(5) + 1;
                }
                if (this.field_70146_Z.nextInt(10) != 0) break;
                base = 6;
                body = 1;
                face = 0;
                tail = 0;
                break;
            }
            case "Ws-w": 
            case "w-Ws": {
                base = this.field_70146_Z.nextInt(3) + 1;
                body = 1;
                if (base == 2 || base == 3) {
                    this.selectWhitePaws(base);
                }
                if (base != 3) break;
                face = this.field_70146_Z.nextInt(5) + 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Error selecting white markings; " + this.getGenotype(WHITE));
            }
        }
        this.whiteTexturesArray[0] = body == 0 ? "" : "white_" + base + "_body" + body;
        this.setWhiteTextures(0, this.whiteTexturesArray[0]);
        this.whiteTexturesArray[1] = face == 0 ? "" : "white_" + (base == 3 || base == 4 ? 34 : base) + "_face" + face;
        this.setWhiteTextures(1, this.whiteTexturesArray[1]);
        this.whiteTexturesArray[2] = tail == 0 ? "" : "white_" + base + "_tail" + tail;
        this.setWhiteTextures(2, this.whiteTexturesArray[2]);
    }

    private void selectWhitePaws(int base) {
        boolean all;
        boolean bl = all = this.field_70146_Z.nextInt(4) <= 2;
        if (all || this.field_70146_Z.nextInt(4) <= 2) {
            this.whitePawTexturesArray[0] = "white_" + base + "_paw1";
            this.setWhitePawTextures(0, this.whitePawTexturesArray[0]);
        }
        if (all || this.field_70146_Z.nextInt(4) <= 2) {
            this.whitePawTexturesArray[1] = "white_" + base + "_paw2";
            this.setWhitePawTextures(1, this.whitePawTexturesArray[1]);
        }
        if (all || this.field_70146_Z.nextInt(4) <= 2) {
            this.whitePawTexturesArray[2] = "white_" + base + "_paw3";
            this.setWhitePawTextures(2, this.whitePawTexturesArray[2]);
        }
        if (all || this.field_70146_Z.nextInt(4) <= 2) {
            this.whitePawTexturesArray[3] = "white_" + base + "_paw4";
            this.setWhitePawTextures(3, this.whitePawTexturesArray[3]);
        }
    }

    private String getWhiteTextures(int i) {
        switch (i) {
            case 0: {
                return (String)this.field_70180_af.func_187225_a(WHITE_0);
            }
            case 1: {
                return (String)this.field_70180_af.func_187225_a(WHITE_1);
            }
            case 2: {
                return (String)this.field_70180_af.func_187225_a(WHITE_2);
            }
        }
        return "";
    }

    private void setWhiteTextures(int i, String value) {
        switch (i) {
            case 0: {
                this.field_70180_af.func_187227_b(WHITE_0, (Object)value);
                break;
            }
            case 1: {
                this.field_70180_af.func_187227_b(WHITE_1, (Object)value);
                break;
            }
            case 2: {
                this.field_70180_af.func_187227_b(WHITE_2, (Object)value);
            }
        }
    }

    private String getWhitePawTextures(int i) {
        switch (i) {
            case 0: {
                return (String)this.field_70180_af.func_187225_a(WHITE_PAWS_0);
            }
            case 1: {
                return (String)this.field_70180_af.func_187225_a(WHITE_PAWS_1);
            }
            case 2: {
                return (String)this.field_70180_af.func_187225_a(WHITE_PAWS_2);
            }
            case 3: {
                return (String)this.field_70180_af.func_187225_a(WHITE_PAWS_3);
            }
        }
        return "";
    }

    private void setWhitePawTextures(int i, String value) {
        switch (i) {
            case 0: {
                this.field_70180_af.func_187227_b(WHITE_PAWS_0, (Object)value);
                break;
            }
            case 1: {
                this.field_70180_af.func_187227_b(WHITE_PAWS_1, (Object)value);
                break;
            }
            case 2: {
                this.field_70180_af.func_187227_b(WHITE_PAWS_2, (Object)value);
                break;
            }
            case 3: {
                this.field_70180_af.func_187227_b(WHITE_PAWS_3, (Object)value);
            }
        }
    }

    protected String getGenotype(DataParameter<String> parameter) {
        return (String)this.field_70180_af.func_187225_a(parameter);
    }

    void setGenotype(DataParameter<String> parameter, String value) {
        this.field_70180_af.func_187227_b(parameter, (Object)value);
    }

    public Genetics.Sex getSex() {
        return ((String)this.field_70180_af.func_187225_a(PHAEOMELANIN)).contains(Genetics.Phaeomelanin.MALE.getAllele()) ? Genetics.Sex.MALE : Genetics.Sex.FEMALE;
    }

    public boolean isBobtail() {
        return Genetics.Bobtail.isBobtail((String)this.field_70180_af.func_187225_a(BOBTAIL));
    }

    public boolean isLongFur() {
        return Genetics.FurLength.getPhenotype((String)this.field_70180_af.func_187225_a(FUR_LENGTH)).equalsIgnoreCase(Genetics.FurLength.LONG.toString());
    }

    public boolean hasHomePos() {
        return ((Optional)this.field_70180_af.func_187225_a(HOME_POSITION)).isPresent();
    }

    public BlockPos getHomePos() {
        return (BlockPos)((Optional)this.field_70180_af.func_187225_a(HOME_POSITION)).or((Object)this.func_180425_c());
    }

    public void setHomePos(BlockPos position) {
        this.field_70180_af.func_187227_b(HOME_POSITION, (Object)Optional.of((Object)position));
    }

    public void resetHomePos() {
        this.field_70180_af.func_187227_b(HOME_POSITION, (Object)Optional.absent());
    }

    public ITextComponent getOwnerName() {
        if (this.func_70902_q() != null) {
            return this.func_70902_q().func_145748_c_();
        }
        if (!((String)this.field_70180_af.func_187225_a(OWNER_NAME)).isEmpty()) {
            return new TextComponentString((String)this.field_70180_af.func_187225_a(OWNER_NAME));
        }
        if (this.func_184753_b() != null) {
            return new TextComponentTranslation("entity.simplycats.cat.unknown_owner", new Object[0]);
        }
        return new TextComponentTranslation("entity.simplycats.cat.untamed", new Object[0]);
    }

    public void setOwnerName(String name) {
        this.field_70180_af.func_187227_b(OWNER_NAME, (Object)name);
    }

    public void func_70014_b(NBTTagCompound compound) {
        int i;
        super.func_70014_b(compound);
        compound.func_74778_a("EyeColor", this.getGenotype(EYE_COLOR));
        compound.func_74778_a("FurLength", this.getGenotype(FUR_LENGTH));
        compound.func_74778_a("Eumelanin", this.getGenotype(EUMELANIN));
        compound.func_74778_a("Phaeomelanin", this.getGenotype(PHAEOMELANIN));
        compound.func_74778_a("Dilution", this.getGenotype(DILUTION));
        compound.func_74778_a("DiluteMod", this.getGenotype(DILUTE_MOD));
        compound.func_74778_a("Agouti", this.getGenotype(AGOUTI));
        compound.func_74778_a("Tabby", this.getGenotype(TABBY));
        compound.func_74778_a("Spotted", this.getGenotype(SPOTTED));
        compound.func_74778_a("Ticked", this.getGenotype(TICKED));
        compound.func_74778_a("Colorpoint", this.getGenotype(COLORPOINT));
        compound.func_74778_a("White", this.getGenotype(WHITE));
        compound.func_74778_a("Bobtail", this.getGenotype(BOBTAIL));
        for (i = 0; i <= 2; ++i) {
            compound.func_74778_a("White_" + i, this.getWhiteTextures(i));
        }
        for (i = 0; i <= 3; ++i) {
            compound.func_74778_a("WhitePaws_" + i, this.getWhitePawTextures(i));
        }
        if (this.hasHomePos()) {
            compound.func_74768_a("HomePosX", this.getHomePos().func_177958_n());
            compound.func_74768_a("HomePosY", this.getHomePos().func_177956_o());
            compound.func_74768_a("HomePosZ", this.getHomePos().func_177952_p());
        }
        compound.func_74778_a("OwnerName", (String)this.field_70180_af.func_187225_a(OWNER_NAME));
    }

    public void func_70037_a(NBTTagCompound compound) {
        int i;
        super.func_70037_a(compound);
        this.setGenotype(EYE_COLOR, compound.func_74779_i("EyeColor"));
        this.setGenotype(FUR_LENGTH, compound.func_74779_i("FurLength"));
        this.setGenotype(EUMELANIN, compound.func_74779_i("Eumelanin"));
        this.setGenotype(PHAEOMELANIN, compound.func_74779_i("Phaeomelanin"));
        this.setGenotype(DILUTION, compound.func_74779_i("Dilution"));
        this.setGenotype(DILUTE_MOD, compound.func_74779_i("DiluteMod"));
        this.setGenotype(AGOUTI, compound.func_74779_i("Agouti"));
        this.setGenotype(TABBY, compound.func_74779_i("Tabby"));
        this.setGenotype(SPOTTED, compound.func_74779_i("Spotted"));
        this.setGenotype(TICKED, compound.func_74779_i("Ticked"));
        this.setGenotype(COLORPOINT, compound.func_74779_i("Colorpoint"));
        this.setGenotype(WHITE, compound.func_74779_i("White"));
        this.setGenotype(BOBTAIL, compound.func_74779_i("Bobtail"));
        for (i = 0; i <= 2; ++i) {
            this.setWhiteTextures(i, compound.func_74779_i("White_" + i));
        }
        for (i = 0; i <= 3; ++i) {
            this.setWhitePawTextures(i, compound.func_74779_i("WhitePaws_" + i));
        }
        if (compound.func_74764_b("HomePosX")) {
            this.setHomePos(new BlockPos(compound.func_74762_e("HomePosX"), compound.func_74762_e("HomePosY"), compound.func_74762_e("HomePosZ")));
        }
        this.setOwnerName(compound.func_74779_i("OwnerName"));
    }

    private String getPhenotype(DataParameter<String> dataParameter) {
        if (dataParameter == FUR_LENGTH) {
            return Genetics.FurLength.getPhenotype(this.getGenotype(dataParameter));
        }
        if (dataParameter == EUMELANIN) {
            return Genetics.Eumelanin.getPhenotype(this.getGenotype(dataParameter));
        }
        if (dataParameter == PHAEOMELANIN) {
            return Genetics.Phaeomelanin.getPhenotype(this.getGenotype(dataParameter));
        }
        if (dataParameter == DILUTION) {
            return Genetics.Dilution.getPhenotype(this.getGenotype(dataParameter));
        }
        if (dataParameter == DILUTE_MOD) {
            return Genetics.DiluteMod.getPhenotype(this.getGenotype(dataParameter));
        }
        if (dataParameter == AGOUTI) {
            return Genetics.Agouti.getPhenotype(this.getGenotype(dataParameter));
        }
        if (dataParameter == TABBY) {
            return Genetics.Tabby.getPhenotype(this.getGenotype(dataParameter));
        }
        if (dataParameter == SPOTTED) {
            return Genetics.Spotted.getPhenotype(this.getGenotype(dataParameter));
        }
        if (dataParameter == TICKED) {
            return Genetics.Ticked.getPhenotype(this.getGenotype(dataParameter));
        }
        if (dataParameter == COLORPOINT) {
            return Genetics.Colorpoint.getPhenotype(this.getGenotype(dataParameter));
        }
        if (dataParameter == WHITE) {
            return Genetics.White.getPhenotype(this.getGenotype(dataParameter));
        }
        return this.getGenotype(EYE_COLOR);
    }

    private void resetTexturePrefix() {
        this.texturePrefix = null;
    }

    @SideOnly(value=Side.CLIENT)
    private void setCatTexturePaths() {
        String solid = this.getPhenotype(EUMELANIN);
        if (this.getPhenotype(PHAEOMELANIN).equalsIgnoreCase(Genetics.Phaeomelanin.RED.toString().toLowerCase())) {
            solid = this.getPhenotype(PHAEOMELANIN);
        }
        if (this.getPhenotype(DILUTION).equalsIgnoreCase(Genetics.Dilution.DILUTE.toString().toLowerCase())) {
            solid = solid + "_" + this.getPhenotype(DILUTION);
            if (this.getPhenotype(DILUTE_MOD).equalsIgnoreCase(Genetics.DiluteMod.CARAMELIZED.toString().toLowerCase())) {
                solid = solid + "_" + this.getPhenotype(DILUTE_MOD);
            }
        }
        String tabby = this.getPhenotype(TABBY) + "_" + solid;
        if (this.getGenotype(SPOTTED).contains(Genetics.Spotted.SPOTTED.getAllele())) {
            tabby = this.getPhenotype(SPOTTED) + "_" + tabby;
        }
        if (this.getPhenotype(TICKED).equalsIgnoreCase(Genetics.Ticked.TICKED.toString().toLowerCase())) {
            tabby = this.getPhenotype(TICKED) + (this.getGenotype(TICKED).contains(Genetics.Ticked.NORMAL.getAllele()) ? "_residual" : "") + "_" + solid;
        }
        String tortie = "";
        if (this.getPhenotype(PHAEOMELANIN).equalsIgnoreCase(Genetics.Phaeomelanin.TORTOISESHELL.toString().toLowerCase())) {
            tortie = this.getPhenotype(PHAEOMELANIN) + "_" + tabby.replace("_" + solid, "");
            if (this.getPhenotype(DILUTION).equalsIgnoreCase(Genetics.Dilution.DILUTE.toString().toLowerCase())) {
                tortie = tortie + "_" + this.getPhenotype(DILUTION);
                if (this.getPhenotype(DILUTE_MOD).equalsIgnoreCase(Genetics.DiluteMod.CARAMELIZED.toString().toLowerCase())) {
                    tortie = tortie + "_" + this.getPhenotype(DILUTE_MOD);
                }
            }
        }
        if (!this.getPhenotype(PHAEOMELANIN).equalsIgnoreCase(Genetics.Phaeomelanin.RED.toString()) && this.getPhenotype(AGOUTI).equalsIgnoreCase(Genetics.Agouti.SOLID.toString().toLowerCase())) {
            tabby = "";
        }
        String colorpoint = "";
        if (!this.getPhenotype(COLORPOINT).equalsIgnoreCase(Genetics.Colorpoint.NOT_POINTED.toString().toLowerCase())) {
            colorpoint = this.getPhenotype(COLORPOINT);
            if (!tabby.equals("") && !this.getPhenotype(PHAEOMELANIN).equalsIgnoreCase(Genetics.Phaeomelanin.RED.toString())) {
                colorpoint = colorpoint + "_tabby";
            } else if (solid.equalsIgnoreCase(Genetics.Eumelanin.BLACK.toString())) {
                colorpoint = colorpoint + "_" + solid;
            } else if (this.getPhenotype(PHAEOMELANIN).equalsIgnoreCase(Genetics.Phaeomelanin.RED.toString())) {
                colorpoint = colorpoint + "_red";
            }
            if (!tortie.equals("")) {
                tortie = tortie + "_point";
            }
        }
        this.catTexturesArray[0] = "simplycats:textures/entity/cat/solid/" + solid + ".png";
        this.catTexturesArray[1] = tabby.equals("") ? null : "simplycats:textures/entity/cat/tabby/" + tabby + ".png";
        this.catTexturesArray[2] = tortie.equals("") ? null : "simplycats:textures/entity/cat/tortie/" + tortie + ".png";
        this.catTexturesArray[3] = colorpoint.equals("") ? null : "simplycats:textures/entity/cat/colorpoint/" + colorpoint + ".png";
        this.catTexturesArray[4] = this.getWhiteTextures(0).equals("") ? null : "simplycats:textures/entity/cat/white/" + this.getWhiteTextures(0) + ".png";
        this.catTexturesArray[5] = this.getWhiteTextures(1).equals("") ? null : "simplycats:textures/entity/cat/white/" + this.getWhiteTextures(1) + ".png";
        this.catTexturesArray[6] = this.getWhiteTextures(2).equals("") ? null : "simplycats:textures/entity/cat/white/" + this.getWhiteTextures(2) + ".png";
        this.catTexturesArray[7] = this.getWhitePawTextures(0).equals("") ? null : "simplycats:textures/entity/cat/white/" + this.getWhitePawTextures(0) + ".png";
        this.catTexturesArray[8] = this.getWhitePawTextures(1).equals("") ? null : "simplycats:textures/entity/cat/white/" + this.getWhitePawTextures(1) + ".png";
        this.catTexturesArray[9] = this.getWhitePawTextures(2).equals("") ? null : "simplycats:textures/entity/cat/white/" + this.getWhitePawTextures(2) + ".png";
        this.catTexturesArray[10] = this.getWhitePawTextures(3).equals("") ? null : "simplycats:textures/entity/cat/white/" + this.getWhitePawTextures(3) + ".png";
        this.catTexturesArray[11] = "simplycats:textures/entity/cat/eyes/" + this.getPhenotype(EYE_COLOR) + ".png";
        this.texturePrefix = "cat/" + solid + tabby + tortie + colorpoint + this.getWhiteTextures(0) + this.getWhiteTextures(1) + this.getWhiteTextures(2) + this.getWhitePawTextures(0) + this.getWhitePawTextures(1) + this.getWhitePawTextures(2) + this.getWhitePawTextures(3) + this.getPhenotype(EYE_COLOR);
    }

    @SideOnly(value=Side.CLIENT)
    public String getCatTexture() {
        if (this.texturePrefix == null) {
            this.setCatTexturePaths();
        }
        return this.texturePrefix;
    }

    @SideOnly(value=Side.CLIENT)
    public String[] getTexturePaths() {
        if (this.texturePrefix == null) {
            this.setCatTexturePaths();
        }
        return this.catTexturesArray;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.PURR && this.PURR_TIMER == 0) {
            this.PURR = false;
            this.PURR_TIMER = 0;
        }
        if (this.field_70173_aa % 40 == 0 && !this.field_70170_p.field_72995_K && this.func_70902_q() != null) {
            this.setOwnerName(this.func_70902_q().func_145748_c_().func_150254_d());
        }
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_187223_a()) {
            this.field_70180_af.func_187230_e();
            this.resetTexturePrefix();
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_110143_aJ() <= 0.0f && this.func_70909_n() && this.func_70902_q() == null) {
            this.field_70725_aQ = 0;
            this.func_70606_j(1.0f);
        }
        if (this.PURR && this.PURR_TIMER > 0) {
            --this.PURR_TIMER;
        }
    }

    public boolean canBeTamed(EntityPlayer player) {
        return (SCConfig.TAMED_LIMIT == 0 || player.getEntityData().func_74762_e("CatCount") < SCConfig.TAMED_LIMIT) && !this.func_70909_n();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.PURR && this.field_70146_Z.nextInt(10) == 0) {
            this.PURR = true;
            this.PURR_TIMER = (this.field_70146_Z.nextInt(61) + 30) * 20;
        }
        return false;
    }

    public void setTamed(boolean tamed, EntityPlayer owner) {
        int catCount = owner.getEntityData().func_74762_e("CatCount");
        if (tamed) {
            owner.getEntityData().func_74768_a("CatCount", catCount + 1);
            if (!this.field_70170_p.field_72995_K) {
                SCNetworking.CHANNEL.sendTo((IMessage)new SCNetworking(catCount + 1), (EntityPlayerMP)owner);
            }
            this.setOwnerName(owner.getDisplayNameString());
        } else {
            owner.getEntityData().func_74768_a("CatCount", catCount - 1);
            if (!this.field_70170_p.field_72995_K) {
                SCNetworking.CHANNEL.sendTo((IMessage)new SCNetworking(catCount - 1), (EntityPlayerMP)owner);
            }
            this.setOwnerName("");
        }
        this.func_70903_f(tamed);
    }

    public void func_70645_a(DamageSource cause) {
        if (this.func_70909_n() && this.func_70902_q() != null) {
            int count = this.func_70902_q().getEntityData().func_74762_e("CatCount");
            this.func_70902_q().getEntityData().func_74768_a("CatCount", count - 1);
            if (!this.field_70170_p.field_72995_K) {
                SCNetworking.CHANNEL.sendTo((IMessage)new SCNetworking(count - 1), (EntityPlayerMP)this.func_70902_q());
            }
        }
        super.func_70645_a(cause);
    }

    private String inheritGene(String motherAlleles, String fatherAlleles) {
        String[] maternal = motherAlleles.split("-");
        String[] paternal = fatherAlleles.split("-");
        return maternal[this.field_70146_Z.nextInt(2)] + "-" + paternal[this.field_70146_Z.nextInt(2)];
    }

    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable parFather) {
        EntityPlayer owner;
        int eyesMax;
        int eyesMin;
        EntityDataManager father = parFather.func_184212_Q();
        EntityDataManager mother = this.func_184212_Q();
        EntityCat child = new EntityCat(this.field_70170_p);
        ImmutableList parameters = ImmutableList.of(FUR_LENGTH, EUMELANIN, PHAEOMELANIN, DILUTION, DILUTE_MOD, AGOUTI, TABBY, SPOTTED, TICKED, COLORPOINT, WHITE, BOBTAIL, (Object[])new DataParameter[0]);
        for (DataParameter geneParameter : parameters) {
            String inherited = this.inheritGene((String)mother.func_187225_a(geneParameter), (String)father.func_187225_a(geneParameter));
            child.setGenotype((DataParameter<String>)geneParameter, inherited);
        }
        child.selectWhiteMarkings();
        int matEye = Genetics.EyeColor.valueOf(((String)mother.func_187225_a(EYE_COLOR)).toUpperCase()).ordinal();
        int patEye = Genetics.EyeColor.valueOf(((String)father.func_187225_a(EYE_COLOR)).toUpperCase()).ordinal();
        if (matEye > patEye) {
            eyesMin = patEye - 1;
            eyesMax = matEye;
        } else {
            eyesMin = matEye - 1;
            eyesMax = patEye;
        }
        eyesMin = eyesMin < 0 ? 0 : eyesMin;
        String white = child.getGenotype(WHITE);
        eyesMax = white.contains(Genetics.White.DOMINANT.getAllele()) ? 4 : (eyesMax >= 4 ? (eyesMin < 3 ? eyesMin + 1 : 3) : eyesMax);
        int eyes = this.field_70146_Z.nextInt(eyesMax - eyesMin + 1) + eyesMin;
        String eye = Genetics.EyeColor.init(matEye == 4 && patEye == 4 ? (eyesMax == 4 ? 4 : this.field_70146_Z.nextInt(4)) : eyes);
        String point = child.getGenotype(COLORPOINT);
        if (point.contentEquals(Genetics.Colorpoint.COLORPOINT.getAllele() + "-" + Genetics.Colorpoint.COLORPOINT.getAllele())) {
            eye = Genetics.EyeColor.init(4);
        }
        child.setGenotype(EYE_COLOR, eye);
        if (this.func_70909_n() && this.func_184753_b() != null && (owner = this.field_70170_p.func_152378_a(this.func_184753_b())) != null && child.canBeTamed(owner)) {
            child.setTamed(this.func_70909_n(), owner);
            child.func_184754_b(this.func_184753_b());
            child.func_193101_c(owner);
            if (this.hasHomePos()) {
                child.setHomePos(this.getHomePos());
            }
        }
        return child;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean isAngry() {
        return ((Byte)this.field_70180_af.func_187225_a(field_184755_bv) & 2) != 0;
    }

    public void setAngry(boolean angry) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(field_184755_bv);
        if (angry) {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 | 2)));
        } else {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 & 0xFFFFFFFD)));
        }
    }

    protected SoundEvent func_184639_G() {
        if (this.isAngry()) {
            if (this.field_70146_Z.nextInt(10) == 0) {
                return SoundEvents.field_189106_R;
            }
            return null;
        }
        if (this.func_70880_s() || this.PURR) {
            return SoundEvents.field_187645_R;
        }
        if (this.field_70146_Z.nextInt(10) == 0) {
            if (this.field_70146_Z.nextInt(10) == 0) {
                return SoundEvents.field_187648_S;
            }
            return SoundEvents.field_187636_O;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187642_Q;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187639_P;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public void func_96094_a(String name) {
        String key;
        if (this.func_184753_b() != null && (key = Ref.getCustomCats().get(this.func_184753_b())) != null && key.equalsIgnoreCase(name)) {
            EntityCat cat = (EntityCat)this;
            switch (name.toLowerCase()) {
                case "penny": {
                    cat.setGenotype(FUR_LENGTH, "L-l");
                    cat.setGenotype(EUMELANIN, "B-B");
                    cat.setGenotype(PHAEOMELANIN, "XO-Xo");
                    cat.setGenotype(DILUTION, "D-d");
                    cat.setGenotype(DILUTE_MOD, "dm-dm");
                    cat.setGenotype(AGOUTI, "A-a");
                    cat.setGenotype(TABBY, "mc-mc");
                    cat.setGenotype(SPOTTED, "sp-sp");
                    cat.setGenotype(TICKED, "ta-ta");
                    cat.setGenotype(COLORPOINT, "C-cs");
                    cat.setGenotype(WHITE, "Ws-w");
                    cat.setGenotype(BOBTAIL, "Jb-Jb");
                    cat.selectWhiteMarkings();
                    cat.setGenotype(EYE_COLOR, "green");
                    cat.setFixed((byte)1);
                }
                case "spinny": {
                    cat.setGenotype(FUR_LENGTH, "L-l");
                    cat.setGenotype(EUMELANIN, "B-B");
                    cat.setGenotype(PHAEOMELANIN, "Xo-Xo");
                    cat.setGenotype(DILUTION, "D-d");
                    cat.setGenotype(DILUTE_MOD, "dm-dm");
                    cat.setGenotype(AGOUTI, "a-a");
                    cat.setGenotype(TABBY, "mc-mc");
                    cat.setGenotype(SPOTTED, "sp-sp");
                    cat.setGenotype(TICKED, "ta-ta");
                    cat.setGenotype(COLORPOINT, "C-cs");
                    cat.setGenotype(WHITE, "w-w");
                    cat.setGenotype(BOBTAIL, "Jb-Jb");
                    cat.selectWhiteMarkings();
                    cat.setGenotype(EYE_COLOR, "gold");
                }
            }
        }
        super.func_96094_a(name);
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        return this.func_70909_n() ? new TextComponentTranslation("entity.Cat.name", new Object[0]).func_150254_d() : super.func_70005_c_();
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }
}

