/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.worldgen.villages;

import com.github.mnesikos.simplycats.configuration.SCConfig;
import com.github.mnesikos.simplycats.entity.EntityCat;
import com.github.mnesikos.simplycats.worldgen.villages.CatProfessions;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class ComponentPetShelter
extends StructureVillagePieces.Village {
    private int AVG_GROUND_LEVEL = -1;
    private int CATS_SPAWNED;
    private int DOGS_SPAWNED;

    public ComponentPetShelter() {
    }

    public ComponentPetShelter(StructureVillagePieces.Start parStart, int parType, Random parRand, StructureBoundingBox parStructBB, EnumFacing facing) {
        super(parStart, parType);
        this.func_186164_a(facing);
        this.field_74887_e = parStructBB;
    }

    protected void func_143012_a(NBTTagCompound tagCompound) {
        super.func_143012_a(tagCompound);
        tagCompound.func_74768_a("CatsSpawned", this.CATS_SPAWNED);
        tagCompound.func_74768_a("DogsSpawned", this.DOGS_SPAWNED);
    }

    protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
        super.func_143011_b(tagCompound, p_143011_2_);
        this.CATS_SPAWNED = tagCompound.func_74762_e("CatsSpawned");
        this.DOGS_SPAWNED = tagCompound.func_74762_e("DogsSpawned");
    }

    public static ComponentPetShelter buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing facing, int p5) {
        StructureBoundingBox box = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)-1, (int)17, (int)6, (int)14, (EnumFacing)facing);
        return ComponentPetShelter.func_74895_a((StructureBoundingBox)box) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)box) == null ? new ComponentPetShelter(villagePiece, p5, random, box, facing) : null;
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox structureBoundingBox) {
        int x;
        int z;
        if (this.AVG_GROUND_LEVEL < 0) {
            this.AVG_GROUND_LEVEL = this.func_74889_b(world, structureBoundingBox);
            if (this.AVG_GROUND_LEVEL < 0) {
                return true;
            }
            this.field_74887_e.func_78886_a(0, this.AVG_GROUND_LEVEL - this.field_74887_e.field_78894_e + 4, 0);
        }
        IBlockState cobble = this.func_175847_a(Blocks.field_150347_e.func_176223_P());
        IBlockState log = this.func_175847_a(Blocks.field_150364_r.func_176223_P());
        IBlockState planks = this.func_175847_a(Blocks.field_150344_f.func_176223_P());
        IBlockState stoneStairs = this.func_175847_a(Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
        IBlockState stairs1 = this.func_175847_a(Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
        IBlockState stairs2 = this.func_175847_a(Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH));
        IBlockState stairs3 = this.func_175847_a(Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
        IBlockState stairs0 = this.func_175847_a(Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
        IBlockState fence = this.func_175847_a(Blocks.field_180407_aO.func_176223_P());
        IBlockState gate = this.func_175847_a(Blocks.field_180390_bo.func_176223_P());
        IBlockState dirt = this.func_175847_a(Blocks.field_150346_d.func_176223_P());
        this.func_175804_a(world, structureBoundingBox, 2, 1, -1, 8, 1, 11, cobble, cobble, false);
        this.func_175804_a(world, structureBoundingBox, 9, 1, 3, 16, 1, 11, cobble, cobble, false);
        this.func_175804_a(world, structureBoundingBox, 2, 0, -1, 8, 0, 2, cobble, cobble, false);
        this.func_175804_a(world, structureBoundingBox, 2, 0, 3, 16, 0, 11, cobble, cobble, false);
        this.func_175804_a(world, structureBoundingBox, 2, -1, -1, 16, -1, 11, cobble, cobble, false);
        this.func_175808_b(world, cobble, 2, -2, -1, structureBoundingBox);
        this.func_175808_b(world, cobble, 8, -2, -1, structureBoundingBox);
        this.func_175808_b(world, cobble, 16, -2, -1, structureBoundingBox);
        this.func_175808_b(world, cobble, 16, -2, 3, structureBoundingBox);
        this.func_175808_b(world, cobble, 16, -2, 11, structureBoundingBox);
        this.func_175808_b(world, cobble, 8, -2, 11, structureBoundingBox);
        this.func_175808_b(world, cobble, 2, -2, 11, structureBoundingBox);
        this.func_175804_a(world, structureBoundingBox, 2, 2, -1, 2, 4, -1, cobble, cobble, false);
        this.func_175804_a(world, structureBoundingBox, 2, 2, 11, 2, 4, 11, cobble, cobble, false);
        this.func_175804_a(world, structureBoundingBox, 8, 2, 3, 8, 4, 3, cobble, cobble, false);
        this.func_175804_a(world, structureBoundingBox, 8, 2, -1, 8, 4, -1, cobble, cobble, false);
        this.func_175804_a(world, structureBoundingBox, 8, 2, 11, 8, 4, 11, cobble, cobble, false);
        this.func_175804_a(world, structureBoundingBox, 16, 2, 3, 16, 3, 3, cobble, cobble, false);
        this.func_175804_a(world, structureBoundingBox, 16, 2, 11, 16, 4, 11, cobble, cobble, false);
        this.func_175804_a(world, structureBoundingBox, 3, 1, 0, 7, 1, 10, planks, planks, false);
        this.func_175804_a(world, structureBoundingBox, 8, 1, 4, 15, 1, 10, planks, planks, false);
        this.func_175804_a(world, structureBoundingBox, 9, 1, -1, 16, 1, 2, this.func_175847_a(Blocks.field_150349_c.func_176223_P()), this.func_175847_a(Blocks.field_150349_c.func_176223_P()), false);
        this.func_175804_a(world, structureBoundingBox, 9, 0, -1, 16, 0, 2, dirt, dirt, false);
        this.func_175804_a(world, structureBoundingBox, 9, 2, -1, 16, 2, 2, fence, Blocks.field_150350_a.func_176223_P(), false);
        this.func_74878_a(world, structureBoundingBox, 9, 2, 0, 15, 2, 2);
        this.func_74878_a(world, structureBoundingBox, 9, 3, -1, 16, 7, 2);
        this.func_189927_a(world, structureBoundingBox, rand, 5, 2, -1, EnumFacing.SOUTH);
        this.func_175811_a(world, stoneStairs, 5, 1, -2, structureBoundingBox);
        this.func_175804_a(world, structureBoundingBox, 3, 2, -1, 4, 2, -1, cobble, cobble, false);
        this.func_175804_a(world, structureBoundingBox, 6, 2, -1, 7, 2, -1, cobble, cobble, false);
        this.func_175804_a(world, structureBoundingBox, 3, 3, -1, 4, 4, -1, planks, planks, false);
        this.func_175804_a(world, structureBoundingBox, 6, 3, -1, 7, 4, -1, planks, planks, false);
        this.func_175804_a(world, structureBoundingBox, 4, 6, -1, 6, 6, -1, planks, planks, false);
        this.func_175811_a(world, planks, 5, 4, -1, structureBoundingBox);
        this.func_175811_a(world, planks, 3, 5, -1, structureBoundingBox);
        this.func_175811_a(world, planks, 7, 5, -1, structureBoundingBox);
        this.func_175811_a(world, log, 4, 5, -1, structureBoundingBox);
        this.func_175811_a(world, log, 6, 5, -1, structureBoundingBox);
        this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), 5, 5, -1, structureBoundingBox);
        this.func_175811_a(world, gate.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH), 12, 2, 3, structureBoundingBox);
        this.func_175804_a(world, structureBoundingBox, 9, 2, 3, 11, 2, 3, cobble, cobble, false);
        this.func_175804_a(world, structureBoundingBox, 13, 2, 3, 15, 2, 3, cobble, cobble, false);
        this.func_175804_a(world, structureBoundingBox, 9, 3, 3, 10, 3, 3, planks, planks, false);
        this.func_175804_a(world, structureBoundingBox, 14, 3, 3, 15, 3, 3, planks, planks, false);
        this.func_175811_a(world, log, 11, 3, 3, structureBoundingBox);
        this.func_175811_a(world, log, 13, 3, 3, structureBoundingBox);
        this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), 12, 3, 3, structureBoundingBox);
        this.func_175804_a(world, structureBoundingBox, 2, 2, 0, 2, 2, 10, cobble, cobble, false);
        this.func_175804_a(world, structureBoundingBox, 2, 3, 0, 2, 4, 0, planks, planks, false);
        this.func_175804_a(world, structureBoundingBox, 2, 3, 10, 2, 4, 10, planks, planks, false);
        this.func_175804_a(world, structureBoundingBox, 2, 4, 1, 2, 4, 3, planks, planks, false);
        this.func_175804_a(world, structureBoundingBox, 2, 4, 7, 2, 4, 9, planks, planks, false);
        this.func_175804_a(world, structureBoundingBox, 2, 3, 1, 2, 3, 3, log, log, false);
        this.func_175804_a(world, structureBoundingBox, 2, 3, 7, 2, 3, 9, log, log, false);
        this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), 2, 3, 2, structureBoundingBox);
        this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), 2, 3, 8, structureBoundingBox);
        for (z = 4; z <= 6; ++z) {
            this.func_175811_a(world, stairs1, 2, 3, z, structureBoundingBox);
            this.func_175811_a(world, stairs1, 2, 4, z, structureBoundingBox);
        }
        this.func_175804_a(world, structureBoundingBox, 8, 2, 0, 8, 2, 2, cobble, cobble, false);
        this.func_175804_a(world, structureBoundingBox, 16, 2, 4, 16, 2, 10, cobble, cobble, false);
        this.func_175804_a(world, structureBoundingBox, 8, 4, 0, 8, 4, 2, planks, planks, false);
        this.func_175804_a(world, structureBoundingBox, 16, 4, 4, 16, 4, 10, planks, planks, false);
        this.func_175804_a(world, structureBoundingBox, 16, 5, 5, 16, 5, 9, planks, planks, false);
        this.func_175804_a(world, structureBoundingBox, 16, 6, 6, 16, 6, 8, planks, planks, false);
        this.func_175811_a(world, planks, 16, 3, 7, structureBoundingBox);
        this.func_175804_a(world, structureBoundingBox, 16, 3, 4, 16, 3, 6, log, log, false);
        this.func_175804_a(world, structureBoundingBox, 16, 3, 8, 16, 3, 10, log, log, false);
        this.func_175804_a(world, structureBoundingBox, 8, 3, 0, 8, 3, 2, Blocks.field_150359_w.func_176223_P(), log, false);
        this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), 16, 3, 5, structureBoundingBox);
        this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), 16, 3, 9, structureBoundingBox);
        this.func_175804_a(world, structureBoundingBox, 3, 2, 11, 7, 2, 11, cobble, cobble, false);
        this.func_175804_a(world, structureBoundingBox, 9, 2, 11, 15, 2, 11, cobble, cobble, false);
        this.func_175804_a(world, structureBoundingBox, 3, 3, 11, 3, 5, 11, planks, planks, false);
        this.func_175804_a(world, structureBoundingBox, 7, 3, 11, 7, 5, 11, planks, planks, false);
        this.func_175804_a(world, structureBoundingBox, 4, 6, 11, 6, 6, 11, planks, planks, false);
        this.func_175804_a(world, structureBoundingBox, 9, 3, 11, 10, 3, 11, planks, planks, false);
        this.func_175804_a(world, structureBoundingBox, 14, 3, 11, 15, 3, 11, planks, planks, false);
        for (x = 4; x <= 6; ++x) {
            this.func_175811_a(world, stairs3, x, 3, 11, structureBoundingBox);
            this.func_175811_a(world, stairs3, x, 4, 11, structureBoundingBox);
        }
        this.func_175811_a(world, planks, 5, 4, 11, structureBoundingBox);
        this.func_175811_a(world, log, 4, 5, 11, structureBoundingBox);
        this.func_175811_a(world, log, 6, 5, 11, structureBoundingBox);
        this.func_175811_a(world, log, 11, 3, 11, structureBoundingBox);
        this.func_175811_a(world, log, 13, 3, 11, structureBoundingBox);
        this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), 5, 5, 11, structureBoundingBox);
        this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), 12, 3, 11, structureBoundingBox);
        this.func_74878_a(world, structureBoundingBox, 3, 2, 0, 7, 7, 10);
        this.func_175804_a(world, structureBoundingBox, 4, 2, 9, 6, 2, 9, Blocks.field_150334_T.func_176223_P(), Blocks.field_150334_T.func_176223_P(), false);
        this.func_189926_a(world, EnumFacing.SOUTH, 5, 4, 10, structureBoundingBox);
        this.func_189926_a(world, EnumFacing.NORTH, 5, 4, 0, structureBoundingBox);
        this.func_189926_a(world, EnumFacing.EAST, 3, 3, 3, structureBoundingBox);
        this.func_189926_a(world, EnumFacing.EAST, 3, 3, 7, structureBoundingBox);
        this.func_175804_a(world, structureBoundingBox, 8, 2, 8, 8, 2, 10, cobble, cobble, false);
        this.func_175804_a(world, structureBoundingBox, 8, 2, 4, 8, 2, 6, cobble, cobble, false);
        this.func_175804_a(world, structureBoundingBox, 8, 3, 9, 8, 4, 10, planks, planks, false);
        this.func_175804_a(world, structureBoundingBox, 8, 3, 4, 8, 4, 5, planks, planks, false);
        this.func_175804_a(world, structureBoundingBox, 8, 3, 6, 8, 4, 8, Blocks.field_150359_w.func_176223_P(), Blocks.field_150359_w.func_176223_P(), false);
        this.func_189915_a(world, structureBoundingBox, rand, 8, 2, 7, EnumFacing.EAST, this.func_189925_i());
        this.func_74878_a(world, structureBoundingBox, 9, 2, 4, 15, 7, 10);
        this.func_175804_a(world, structureBoundingBox, 11, 2, 7, 15, 2, 7, fence, fence, false);
        this.func_175804_a(world, structureBoundingBox, 11, 2, 4, 11, 2, 10, fence, fence, false);
        this.func_175804_a(world, structureBoundingBox, 7, 6, 6, 8, 6, 8, planks, planks, false);
        this.func_175804_a(world, structureBoundingBox, 8, 5, 5, 8, 5, 9, planks, planks, false);
        this.func_189926_a(world, EnumFacing.EAST, 9, 5, 7, structureBoundingBox);
        this.func_189926_a(world, EnumFacing.WEST, 15, 5, 7, structureBoundingBox);
        this.func_175811_a(world, gate.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST), 11, 2, 5, structureBoundingBox);
        this.func_175811_a(world, gate.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST), 11, 2, 9, structureBoundingBox);
        for (x = 14; x <= 15; ++x) {
            int z2;
            for (z2 = 4; z2 <= 5; ++z2) {
                this.func_175811_a(world, Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockCarpet.field_176330_a, (Comparable)EnumDyeColor.LIGHT_BLUE), x, 2, z2, structureBoundingBox);
            }
            for (z2 = 9; z2 <= 10; ++z2) {
                this.func_175811_a(world, Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockCarpet.field_176330_a, (Comparable)EnumDyeColor.LIGHT_BLUE), x, 2, z2, structureBoundingBox);
            }
        }
        this.func_175804_a(world, structureBoundingBox, 5, 7, -1, 5, 7, 11, planks, planks, false);
        for (z = -1; z <= 11; ++z) {
            this.func_175811_a(world, stairs0, 1, 4, z, structureBoundingBox);
            this.func_175811_a(world, stairs0, 2, 5, z, structureBoundingBox);
            this.func_175811_a(world, stairs0, 3, 6, z, structureBoundingBox);
            this.func_175811_a(world, stairs0, 4, 7, z, structureBoundingBox);
        }
        this.func_175804_a(world, structureBoundingBox, 3, 5, 0, 3, 5, 10, planks, planks, false);
        this.func_175804_a(world, structureBoundingBox, 4, 6, 0, 4, 6, 10, planks, planks, false);
        this.func_175804_a(world, structureBoundingBox, 6, 6, 0, 6, 6, 10, planks, planks, false);
        this.func_175804_a(world, structureBoundingBox, 7, 5, 0, 7, 5, 10, planks, planks, false);
        for (z = -1; z <= 3; ++z) {
            this.func_175811_a(world, stairs1, 9, 4, z, structureBoundingBox);
        }
        for (z = -1; z <= 4; ++z) {
            this.func_175811_a(world, stairs1, 8, 5, z, structureBoundingBox);
        }
        for (z = -1; z <= 5; ++z) {
            this.func_175811_a(world, stairs1, 7, 6, z, structureBoundingBox);
        }
        for (z = -1; z <= 6; ++z) {
            this.func_175811_a(world, stairs1, 6, 7, z, structureBoundingBox);
        }
        for (z = 8; z <= 11; ++z) {
            this.func_175811_a(world, stairs1, 6, 7, z, structureBoundingBox);
        }
        for (z = 9; z <= 11; ++z) {
            this.func_175811_a(world, stairs1, 7, 6, z, structureBoundingBox);
        }
        for (z = 10; z <= 11; ++z) {
            this.func_175811_a(world, stairs1, 8, 5, z, structureBoundingBox);
        }
        this.func_175804_a(world, structureBoundingBox, 6, 7, 7, 16, 7, 7, planks, planks, false);
        for (x = 7; x <= 16; ++x) {
            this.func_175811_a(world, stairs3, x, 7, 6, structureBoundingBox);
        }
        for (x = 8; x <= 16; ++x) {
            this.func_175811_a(world, stairs3, x, 6, 5, structureBoundingBox);
        }
        for (x = 9; x <= 16; ++x) {
            this.func_175811_a(world, stairs3, x, 5, 4, structureBoundingBox);
        }
        for (x = 10; x <= 16; ++x) {
            this.func_175811_a(world, stairs3, x, 4, 3, structureBoundingBox);
        }
        for (x = 9; x <= 16; ++x) {
            this.func_175811_a(world, stairs2, x, 4, 11, structureBoundingBox);
        }
        for (x = 9; x <= 16; ++x) {
            this.func_175811_a(world, stairs2, x, 5, 10, structureBoundingBox);
        }
        for (x = 8; x <= 16; ++x) {
            this.func_175811_a(world, stairs2, x, 6, 9, structureBoundingBox);
        }
        for (x = 7; x <= 16; ++x) {
            this.func_175811_a(world, stairs2, x, 7, 8, structureBoundingBox);
        }
        this.func_74893_a(world, structureBoundingBox, 5, 2, 10, 1);
        this.spawnCats(world, structureBoundingBox, 14, 2, 9);
        this.spawnDogs(world, structureBoundingBox, 14, 2, 5);
        return true;
    }

    protected VillagerRegistry.VillagerProfession chooseForgeProfession(int count, VillagerRegistry.VillagerProfession prof) {
        return super.chooseForgeProfession(1, CatProfessions.SHELTER_STAFF);
    }

    private void spawnCats(World world, StructureBoundingBox structureBoundingBoxIn, int x, int y, int z) {
        int count = world.field_73012_v.nextInt(3) + 1;
        if (this.CATS_SPAWNED < count) {
            int offZ;
            int offY;
            int offX;
            for (int i = this.CATS_SPAWNED; i < count && structureBoundingBoxIn.func_175898_b((Vec3i)new BlockPos(offX = this.func_74865_a(x - i, z), offY = this.func_74862_a(y), offZ = this.func_74873_b(x - i, z))); ++i) {
                ++this.CATS_SPAWNED;
                if (world.field_73012_v.nextInt(4) == 0) {
                    EntityCat kitten = new EntityCat(world);
                    kitten.func_70873_a(-SCConfig.KITTEN_MATURE_TIMER);
                    kitten.setMatureTimer(SCConfig.KITTEN_MATURE_TIMER);
                    kitten.func_70012_b((double)offX + 0.5, offY, (double)offZ + 0.5, 0.0f, 0.0f);
                    kitten.setFixed((byte)1);
                    kitten.func_180482_a(world.func_175649_E(new BlockPos((Entity)kitten)), null);
                    kitten.func_110163_bv();
                    world.func_72838_d((Entity)kitten);
                    continue;
                }
                EntityCat cat = new EntityCat(world);
                cat.func_70012_b((double)offX + 0.5, offY, (double)offZ + 0.5, 0.0f, 0.0f);
                cat.setFixed((byte)1);
                cat.func_180482_a(world.func_175649_E(new BlockPos((Entity)cat)), null);
                cat.func_110163_bv();
                world.func_72838_d((Entity)cat);
            }
        }
    }

    private void spawnDogs(World world, StructureBoundingBox structureBoundingBoxIn, int x, int y, int z) {
        int count = world.field_73012_v.nextInt(2) + 1;
        if (this.DOGS_SPAWNED < count) {
            int offZ;
            int offY;
            int offX;
            for (int i = this.DOGS_SPAWNED; i < count && structureBoundingBoxIn.func_175898_b((Vec3i)new BlockPos(offX = this.func_74865_a(x - i, z), offY = this.func_74862_a(y), offZ = this.func_74873_b(x - i, z))); ++i) {
                ++this.DOGS_SPAWNED;
                if (world.field_73012_v.nextInt(4) == 0) {
                    EntityWolf puppy = new EntityWolf(world);
                    puppy.func_70873_a(-24000);
                    puppy.func_70012_b((double)offX + 0.5, (double)offY, (double)offZ + 0.5, 0.0f, 0.0f);
                    puppy.func_180482_a(world.func_175649_E(new BlockPos((Entity)puppy)), null);
                    puppy.func_110163_bv();
                    world.func_72838_d((Entity)puppy);
                    continue;
                }
                EntityWolf dog = new EntityWolf(world);
                dog.func_70012_b((double)offX + 0.5, (double)offY, (double)offZ + 0.5, 0.0f, 0.0f);
                dog.func_180482_a(world.func_175649_E(new BlockPos((Entity)dog)), null);
                dog.func_110163_bv();
                world.func_72838_d((Entity)dog);
            }
        }
    }

    protected IBlockState func_175847_a(IBlockState blockstateIn) {
        BiomeEvent.GetVillageBlockID event = new BiomeEvent.GetVillageBlockID(this.startPiece == null ? null : this.startPiece.biome, blockstateIn);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return event.getReplacement();
        }
        if (this.field_189928_h == 3) {
            if (blockstateIn.func_177230_c() == Blocks.field_180390_bo) {
                return Blocks.field_180391_bp.func_176223_P();
            }
        } else if (this.field_189928_h == 2 && blockstateIn.func_177230_c() == Blocks.field_180390_bo) {
            return Blocks.field_180387_bt.func_176223_P();
        }
        return super.func_175847_a(blockstateIn);
    }
}

