/*
 * Decompiled with CFR 0.152.
 */
package com.svennieke.statues;

import com.svennieke.statues.StatuesTab;
import com.svennieke.statues.config.StatuesConfigGen;
import com.svennieke.statues.entity.EntityStatueBat;
import com.svennieke.statues.handler.DropHandler;
import com.svennieke.statues.init.StatuesBlocks;
import com.svennieke.statues.init.StatuesCrafting;
import com.svennieke.statues.init.StatuesEntity;
import com.svennieke.statues.init.StatuesHoliday;
import com.svennieke.statues.init.StatuesItems;
import com.svennieke.statues.init.StatuesSounds;
import com.svennieke.statues.proxy.CommonProxy;
import java.time.LocalDateTime;
import java.time.Month;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="statues", name="Statues", version="0.8", acceptedMinecraftVersions="[1.10.2]", dependencies="after:baubles;after:VeinMiner;", guiFactory="com.svennieke.statues.config.GuiStatuesConfigFactory")
public class Statues {
    @Mod.Instance(value="statues")
    public static Statues instance;
    @SidedProxy(clientSide="com.svennieke.statues.proxy.ClientProxy", serverSide="com.svennieke.statues.proxy.ServerProxy")
    public static CommonProxy proxy;
    public static final Logger logger;
    public static boolean isBaublesEnabled;
    public static boolean isVeinminerInstalled;
    public static StatuesTab tabStatues;

    @Mod.EventHandler
    public void PreInit(FMLPreInitializationEvent event) {
        isVeinminerInstalled = Loader.isModLoaded((String)"VeinMiner");
        isBaublesEnabled = Loader.isModLoaded((String)"baubles");
        if (isBaublesEnabled) {
            logger.info("Loading With Baubles Compat");
        } else {
            logger.info("Loading Without Baubles Compat");
        }
        MinecraftForge.EVENT_BUS.register((Object)new StatuesConfigGen());
        StatuesSounds.registerSounds();
        StatuesEntity.register();
        StatuesBlocks.init();
        StatuesBlocks.register();
        StatuesItems.init();
        StatuesItems.register();
        StatuesCrafting.register();
        proxy.Preinit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        LocalDateTime now;
        if (StatuesConfigGen.general.Tier1Crafting) {
            for (Biome biome : Biome.field_185377_q) {
                biome.func_76747_a(EnumCreatureType.AMBIENT).add(new Biome.SpawnListEntry(EntityStatueBat.class, 4, 1, 2));
            }
            System.out.println("Registered Statues Bat Spawn");
        }
        if ((now = LocalDateTime.now()).getMonth() == Month.OCTOBER && now.getMonth() == Month.NOVEMBER) {
            StatuesHoliday.registerSpawning();
        }
        proxy.Init();
        MinecraftForge.EVENT_BUS.register((Object)new DropHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    static {
        logger = LogManager.getLogger((String)"statues");
        isBaublesEnabled = false;
        isVeinminerInstalled = false;
        tabStatues = new StatuesTab();
    }
}

