/*
 * Decompiled with CFR 0.152.
 */
package com.svennieke.statues.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.svennieke.statues.init.StatuesSounds;
import java.util.List;
import java.util.Random;
import net.minecraft.init.PotionTypes;
import net.minecraft.potion.PotionType;
import net.minecraft.util.SoundEvent;

public class RandomLists {
    public static final Random rand = new Random();
    public static List<PotionType> throwablePotions = ImmutableList.of((Object)PotionTypes.field_185252_x, (Object)PotionTypes.field_185246_r, (Object)PotionTypes.field_185254_z, (Object)PotionTypes.field_185226_I, (Object)PotionTypes.field_185223_F, (Object)PotionTypes.field_185250_v, (Object)PotionTypes.field_185220_C);
    public static List<SoundEvent> wasteland_sounds = ImmutableList.of((Object)StatuesSounds.wasteland_hello, (Object)StatuesSounds.wasteland_onwards);

    public static PotionType getRandomPotionType() {
        PotionType type = RandomLists.getRandomFromList(throwablePotions);
        return type;
    }

    public static SoundEvent GetRandomWasteland() {
        SoundEvent type = RandomLists.getRandomFromList(wasteland_sounds);
        return type;
    }

    public static <T> T getRandomFromList(List<T> list) {
        return RandomLists.getRandomFromList(list, rand);
    }

    public static <T> T getRandomFromList(List<T> list, Random rand) {
        int size = list.size();
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"Can't select from empty list");
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return list.get(0);
        }
        int randomIndex = rand.nextInt(list.size());
        return list.get(randomIndex);
    }
}

