/*
 * Decompiled with CFR 0.152.
 */
package com.svennieke.statues.tileentity;

import com.mojang.authlib.GameProfile;
import com.svennieke.statues.config.StatuesConfigGen;
import com.svennieke.statues.entity.fakeentity.FakeZombie;
import com.svennieke.statues.init.StatuesItems;
import com.svennieke.statues.init.StatuesSounds;
import com.svennieke.statues.items.ItemTea;
import com.svennieke.statues.util.RandomLists;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class StatueTileEntity
extends TileEntity
implements ITickable {
    private int Cooldown = 0;
    private boolean able;
    private int tier;
    private static FakePlayer fakeStatue = null;

    public int setTier(int theTier) {
        this.tier = theTier;
        return this.tier;
    }

    public int getTier() {
        return this.tier;
    }

    public void holidayCheck(Entity entity, World worldIn, BlockPos pos, boolean isChild) {
        int random;
        LocalDateTime now;
        if (!(this.tier != 3 && this.tier != 4 || (now = LocalDateTime.now()).getMonth() != Month.OCTOBER && now.getMonth() != Month.NOVEMBER || (random = this.field_145850_b.field_73012_v.nextInt(100)) >= 1)) {
            if (isChild) {
                FakeZombie zombie = (FakeZombie)entity;
                zombie.func_70631_g_();
                zombie.func_70634_a(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
                worldIn.func_72838_d((Entity)zombie);
            } else {
                entity.func_70634_a((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
                worldIn.func_72838_d(entity);
            }
        }
    }

    public void WastelandBehavior(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        if (this.isAble()) {
            ItemStack stack1 = new ItemStack((Item)StatuesItems.tea, 1);
            ItemStack stack2 = new ItemStack((Block)Blocks.field_150354_m, 1).func_151001_c("Wasteland Block");
            int random = this.field_145850_b.field_73012_v.nextInt(100);
            if (this.tier == 3 || this.tier == 4) {
                if (random < 100 && stack1 != null) {
                    if (stack1.func_77973_b() instanceof ItemTea && this.tier == 3) {
                        worldIn.func_184133_a(null, pos, StatuesSounds.wasteland_tea, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    }
                    playerIn.func_71019_a(stack1, true);
                }
                if (stack2 != null && random < 50) {
                    playerIn.func_71019_a(stack2, true);
                }
            }
            this.setAble(false);
        } else if (this.tier == 2 || this.tier == 3) {
            worldIn.func_184133_a(null, pos, RandomLists.GetRandomWasteland(), SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
    }

    public void PlaySound(SoundEvent Mobsound, BlockPos pos, World worldIn) {
        if (this.tier == 2 || this.tier == 3) {
            worldIn.func_184133_a(null, pos, Mobsound, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
    }

    public void SendInfoMessage(EntityPlayer entity, World worldIn, BlockPos pos) {
        EntityPlayer player = entity;
        int random = this.field_145850_b.field_73012_v.nextInt(100);
        if (!this.field_145850_b.field_72995_K) {
            int idx = new Random().nextInt(StatuesConfigGen.messages.info_messages.length);
            String randommessage = StatuesConfigGen.messages.info_messages[idx];
            player.func_145747_a((ITextComponent)new TextComponentTranslation(randommessage, new Object[0]));
        }
    }

    public void GiveEffect(BlockPos pos, World worldIn, EntityPlayer entity, Potion effect) {
        if (this.isAble()) {
            EntityPlayer player = entity;
            int random = this.field_145850_b.field_73012_v.nextInt(100);
            if (!(this.tier != 3 && this.tier != 4 || random >= 10 || this.field_145850_b.field_72995_K || player.func_70660_b(effect) != null)) {
                player.func_70690_d(new PotionEffect(effect, 400, 1, true, true));
            }
        }
    }

    public void ThrowPotion(BlockPos pos, World worldIn, EntityPlayer entity) {
        if (this.isAble()) {
            EntityPlayer player = entity;
            int random = this.field_145850_b.field_73012_v.nextInt(100);
            if (!(this.tier != 3 && this.tier != 4 || random >= 10 || this.field_145850_b.field_72995_K)) {
                double d0 = entity.field_70163_u + (double)entity.func_70047_e() - (double)1.1f;
                double d1 = entity.field_70165_t + entity.field_70159_w - (double)pos.func_177958_n();
                double d2 = d0 - (double)pos.func_177956_o();
                double d3 = entity.field_70161_v + entity.field_70179_y - (double)pos.func_177952_p();
                float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3));
                EntityPotion entitypotion = new EntityPotion(this.field_145850_b);
                entitypotion.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
                entitypotion.func_184541_a(PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)RandomLists.getRandomPotionType()));
                entitypotion.func_70186_c(d1, d2 + (double)(f * 0.2f), d3, 0.25f, 6.0f);
                this.field_145850_b.func_184148_a((EntityPlayer)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187924_gx, SoundCategory.NEUTRAL, 1.0f, 0.8f + this.field_145850_b.field_73012_v.nextFloat() * 0.4f);
                this.field_145850_b.func_72838_d((Entity)entitypotion);
            }
        }
    }

    public static FakePlayer getFakePlayer() {
        if (fakeStatue == null) {
            fakeStatue = FakePlayerFactory.get((WorldServer)DimensionManager.getWorld((int)0), (GameProfile)new GameProfile(new UUID(123L, 132L), "Shulker Statue"));
        }
        return fakeStatue;
    }

    public void ShootBullet(BlockPos pos, World worldIn, EntityPlayer entity, EnumFacing.Axis facing) {
        if (this.isAble()) {
            EntityPlayer player = entity;
            FakePlayer fakePlayer = StatueTileEntity.getFakePlayer();
            int random = this.field_145850_b.field_73012_v.nextInt(100);
            if (!(this.tier != 3 && this.tier != 4 || random >= 90 || this.field_145850_b.field_72995_K)) {
                EntityShulkerBullet bullet = new EntityShulkerBullet(this.field_145850_b, (EntityLivingBase)fakePlayer, (Entity)player, facing);
                bullet.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.1, (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
                this.field_145850_b.func_72838_d((Entity)bullet);
                this.field_145850_b.func_184148_a((EntityPlayer)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187789_eW, SoundCategory.NEUTRAL, 1.0f, 0.8f + this.field_145850_b.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }

    public void SpecialInteraction(boolean isCow, boolean isMooshroom, boolean isFlood, Block statue, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        EntityFireworkRocket firework = new EntityFireworkRocket(worldIn, (double)((float)pos.func_177958_n() + hitX), (double)((float)pos.func_177956_o() + hitY), (double)((float)pos.func_177952_p() + hitZ), stack);
        int random = this.field_145850_b.field_73012_v.nextInt(100);
        if (isCow && !worldIn.field_72995_K && stack.func_77973_b() == Items.field_151133_ar && !playerIn.field_71075_bZ.field_75098_d) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187564_an, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                playerIn.func_184611_a(hand, new ItemStack(Items.field_151117_aB));
            } else if (!playerIn.field_71071_by.func_70441_a(new ItemStack(Items.field_151117_aB))) {
                playerIn.func_71019_a(new ItemStack(Items.field_151117_aB), false);
            }
        }
        if (isMooshroom && !worldIn.field_72995_K && stack.func_77973_b() == Items.field_151054_z && !playerIn.field_71075_bZ.field_75098_d) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187564_an, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                playerIn.func_184611_a(hand, new ItemStack((Item)StatuesItems.soup));
            } else if (!playerIn.field_71071_by.func_70441_a(new ItemStack((Item)StatuesItems.soup))) {
                playerIn.func_71019_a(new ItemStack((Item)StatuesItems.soup), false);
            }
        }
        if (isFlood) {
            if (!worldIn.field_72995_K && stack.func_77973_b() == Items.field_151133_ar && !playerIn.field_71075_bZ.field_75098_d) {
                worldIn.func_184133_a(null, pos, SoundEvents.field_187630_M, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                stack.func_190918_g(1);
                ItemStack floodbucket = new ItemStack(Items.field_151131_as);
                if (stack.func_190926_b()) {
                    playerIn.func_184611_a(hand, floodbucket);
                    floodbucket.func_151001_c("The Flood");
                } else if (!playerIn.field_71071_by.func_70441_a(floodbucket)) {
                    playerIn.func_71019_a(floodbucket, false);
                    floodbucket.func_151001_c("The Flood");
                }
            }
            if (random < 50) {
                worldIn.func_72838_d((Entity)firework);
            }
        }
    }

    public void StatueBehavior(@Nullable ItemStack stack1, @Nullable ItemStack stack2, @Nullable ItemStack stack3, EntityLiving spawnableentity, boolean spawnEntity, boolean isCreeper, Block statue, EntityPlayer playerIn, World worldIn, BlockPos pos) {
        if (this.isAble()) {
            int random = this.field_145850_b.field_73012_v.nextInt(100);
            if (this.tier == 3 || this.tier == 4) {
                if (random < 100 && stack1 != null) {
                    playerIn.func_71019_a(stack1, true);
                }
                if (random < 10 && spawnEntity && !worldIn.field_72995_K) {
                    spawnableentity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
                    NBTTagCompound tag = new NBTTagCompound();
                    spawnableentity.func_70014_b(tag);
                    if (isCreeper) {
                        tag.func_74777_a("ExplosionRadius", (short)0);
                        tag.func_74777_a("Fuse", (short)0);
                    }
                    spawnableentity.func_70037_a(tag);
                    worldIn.func_72838_d((Entity)spawnableentity);
                    if (isCreeper) {
                        spawnableentity.func_70656_aK();
                    }
                }
                if (stack2 != null && random < 50) {
                    playerIn.func_71019_a(stack2, true);
                }
                if (stack3 != null && random < 10) {
                    playerIn.func_71019_a(stack3, true);
                }
            }
            this.setAble(false);
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tier = compound.func_74762_e("StatueTier");
        this.Cooldown = compound.func_74762_e("StatueCooldown");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("StatueCooldown", this.Cooldown);
        compound.func_74768_a("StatueTier", this.tier);
        return compound;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && !this.isAble()) {
            int cooldown;
            this.Cooldown = cooldown = this.Cooldown + 1;
            if (cooldown == StatuesConfigGen.general.InteractionTimer * 20) {
                this.Cooldown = 0;
                this.setAble(true);
            } else {
                this.setAble(false);
            }
        }
    }

    public boolean setAble(Boolean isable) {
        this.able = isable;
        return this.able;
    }

    public boolean isAble() {
        return this.able;
    }
}

