/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.Statues;

import com.shynieke.statues.Statues;
import com.shynieke.statues.blocks.IStatue;
import com.shynieke.statues.blocks.StatueBase.BlockShulker;
import com.shynieke.statues.entity.fakeentity.FakeShulker;
import com.shynieke.statues.tileentity.ShulkerStatueTileEntity;
import com.shynieke.statues.tileentity.StatueTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockShulker_Statue
extends BlockShulker
implements ITileEntityProvider,
IStatue {
    private int TIER;

    public BlockShulker_Statue(String unlocalised) {
        this.func_149663_c(unlocalised);
    }

    public Block setTier(int tier) {
        this.TIER = tier;
        this.func_149663_c(super.func_149739_a().replace("tile.", "") + (tier > 1 ? "t" + tier : ""));
        this.setRegistryName("block" + super.func_149739_a().replace("tile.", ""));
        return this;
    }

    @Override
    public int getTier() {
        return this.TIER;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        if (this.TIER == 2) {
            return new StatueTileEntity(this.TIER);
        }
        if (this.TIER >= 3) {
            return new ShulkerStatueTileEntity();
        }
        return null;
    }

    private StatueTileEntity getTE(World world, BlockPos pos) {
        return (StatueTileEntity)world.func_175625_s(pos);
    }

    private ShulkerStatueTileEntity getShulkerTE(World world, BlockPos pos) {
        return (ShulkerStatueTileEntity)world.func_175625_s(pos);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.TIER >= 2) {
            if (!worldIn.field_72995_K) {
                int statuetier;
                ITickable tile;
                if (this.TIER == 2) {
                    tile = this.getTE(worldIn, pos);
                    statuetier = tile.getTier();
                    if (statuetier != this.TIER) {
                        tile.setTier(this.TIER);
                    }
                    tile.PlaySound(SoundEvents.field_187773_eO, pos, worldIn);
                }
                if (this.TIER >= 3) {
                    tile = this.getShulkerTE(worldIn, pos);
                    statuetier = tile.getTier();
                    if (statuetier != this.TIER) {
                        tile.setTier(this.TIER);
                    }
                    tile.ShootBullet(pos, worldIn, playerIn, facing.func_176740_k());
                    tile.PlaySound(SoundEvents.field_187773_eO, pos, worldIn);
                    tile.holidayCheck((Entity)new FakeShulker(worldIn), worldIn, pos, false);
                    playerIn.openGui((Object)Statues.instance, 0, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            }
            return true;
        }
        return false;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (worldIn.func_175625_s(pos) instanceof ShulkerStatueTileEntity) {
            ShulkerStatueTileEntity tileentityshulkerbox = (ShulkerStatueTileEntity)worldIn.func_175625_s(pos);
            tileentityshulkerbox.setDestroyedByCreativePlayer(player.field_71075_bZ.field_75098_d);
            tileentityshulkerbox.func_184281_d(player);
        }
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof ShulkerStatueTileEntity) {
            ((ShulkerStatueTileEntity)tileentity).func_190575_a(stack.func_82833_r());
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof ShulkerStatueTileEntity) {
            ShulkerStatueTileEntity tileentityshulkerstatue = (ShulkerStatueTileEntity)tileentity;
            if (!tileentityshulkerstatue.isCleared() && tileentityshulkerstatue.shouldDrop()) {
                ItemStack itemstack = new ItemStack(Item.func_150898_a((Block)this));
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound.func_74782_a("BlockEntityTag", (NBTBase)((ShulkerStatueTileEntity)tileentity).saveToNbt(nbttagcompound1));
                itemstack.func_77982_d(nbttagcompound);
                if (tileentityshulkerstatue.func_145818_k_()) {
                    itemstack.func_151001_c(tileentityshulkerstatue.func_70005_c_());
                    tileentityshulkerstatue.func_190575_a("");
                }
                BlockShulker_Statue.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemstack);
            }
            worldIn.func_175666_e(pos, state.func_177230_c());
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        NBTTagCompound nbttagcompound;
        super.func_190948_a(stack, player, tooltip, advanced);
        if (this.TIER >= 3 && (nbttagcompound = stack.func_77978_p()) != null && nbttagcompound.func_150297_b("BlockEntityTag", 10)) {
            NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("BlockEntityTag");
            if (nbttagcompound1.func_150297_b("LootTable", 8)) {
                tooltip.add("???????");
            }
            if (nbttagcompound1.func_150297_b("Items", 9)) {
                NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
                ItemStackHelper.func_191283_b((NBTTagCompound)nbttagcompound1, (NonNullList)nonnulllist);
                int i = 0;
                int j = 0;
                for (ItemStack itemstack : nonnulllist) {
                    if (itemstack.func_190926_b()) continue;
                    ++j;
                    if (i > 4) continue;
                    ++i;
                    tooltip.add(String.format("%s x%d", itemstack.func_82833_r(), itemstack.func_190916_E()));
                }
                if (j - i > 0) {
                    tooltip.add(String.format(TextFormatting.ITALIC + I18n.func_135052_a((String)"statues:container.shulkerStatue.more", (Object[])new Object[0]), j - i));
                }
            }
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_94526_b((IInventory)((IInventory)worldIn.func_175625_s(pos)));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ShulkerStatueTileEntity tileentityshulkerbox;
        NBTTagCompound nbttagcompound;
        ItemStack itemstack = super.getPickBlock(state, target, world, pos, player);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ShulkerStatueTileEntity && !(nbttagcompound = (tileentityshulkerbox = (ShulkerStatueTileEntity)te).saveToNbt(new NBTTagCompound())).func_82582_d()) {
            itemstack.func_77983_a("BlockEntityTag", (NBTBase)nbttagcompound);
        }
        return itemstack;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (te instanceof IWorldNameable && ((IWorldNameable)te).func_145818_k_()) {
            player.func_71029_a(StatList.func_188055_a((Block)this));
            player.func_71020_j(0.005f);
            if (worldIn.field_72995_K) {
                return;
            }
            int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
            Item item = this.func_180660_a(state, worldIn.field_73012_v, i);
            if (item == Items.field_190931_a) {
                return;
            }
            ItemStack itemstack = new ItemStack(item, this.func_149745_a(worldIn.field_73012_v));
            itemstack.func_151001_c(((IWorldNameable)te).func_70005_c_());
            BlockShulker_Statue.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemstack);
        } else {
            super.func_180657_a(worldIn, player, pos, state, (TileEntity)null, stack);
        }
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (this.TIER <= 2) {
            super.func_180653_a(worldIn, pos, state, chance, fortune);
        }
    }
}

