/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="statues")
@Config.LangKey(value="statues.config.title")
public class StatuesConfigGen {
    @Config.Comment(value={"General settings"})
    public static General general = new General();
    @Config.Comment(value={"Player Statue Settings"})
    public static Player player = new Player();
    @Config.Comment(value={"Other settings"})
    public static OtherStuff othersettings = new OtherStuff();
    @Config.Comment(value={"Other settings"})
    public static TextMessages messages = new TextMessages();
    @Config.Comment(value={"Lucky Players"})
    public static LuckyPlayers luckyplayers = new LuckyPlayers();
    @Config.Comment(value={"Seasonal Events"})
    public static Events events = new Events();

    @Mod.EventBusSubscriber(modid="statues")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("statues")) {
                ConfigManager.sync((String)"statues", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class Events {
        @Config.RequiresMcRestart
        @Config.Comment(value={"When enabled makes the fake mobs spawn during the month of October as a halloween event (Default: true)"})
        public boolean halloweenSpawning = true;
        @Config.RequiresMcRestart
        @Config.Comment(value={"The weigth of the fake mobs is divided by this number. (Default: 4)"})
        @Config.RangeInt(min=1)
        public int fakeSpawningWeigth = 4;
    }

    public static class LuckyPlayers {
        @Config.Comment(value={"Adding usernames will make these users have less luck with getting statues"})
        public String[] lucky_players = new String[]{"iskall85"};
    }

    public static class TextMessages {
        @Config.Comment(value={"Adding lines / removing lines specifies what the informative statue can say"})
        public String[] info_messages = new String[]{"Statues is still in beta not all mobs have a statue yet", "Chickens are not royal, prove me wrong by placing the right statue on a royal looking block", "Undead stop burning in water, would a statue burn on a block that looks like water?", "Fun Fact: I was supposed to be a christmas special item, but plans got changed and now I am here", "Pigs love mud how will they react on a more sandy block", "Did you know chicken jockeys exist even in statues? go ahead try it out place a baby zombie statue on a chicken statue", "Huge thanks to Xisuma for helping create his statue", "Only decorative statues can be changed to special statues", "Gone Fishing", "A hat to protect you from the heat, get it in a hot biome near you", "1-3 tall they seem, prickly is a bit mean, Give them a hat and see their true means", "A statue of undying can be found in the pockets of the Woodland residents", "Right click a fake mob with a statue core to prevent them from despawning", "Right click a player statue with a comparator to emit redstone when that player is online", "Right click a player statue with a compass to bound the compass to the last known location of the player", "A player and a creeper with blue fire in the middle", "How to make blue fire, if fire itself does not work"};
    }

    public static class OtherStuff {
        @Config.RequiresMcRestart
        @Config.Comment(value={"Changing this changes the amount of time needed to harvest a statue, Higher = more time needed. Lower = faster harvested (Default: 0.6) [0.6 is the same as vanilla grass]"})
        public double StatueHardness = 0.6;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Changing this changes the stacksize of the mushroom soup (Default: 8)"})
        public int SoupStack = 8;
        @Config.Comment(value={"This either disables or enables the anti-afk system that's in place (Default: true)"})
        public boolean antiAfk = true;
    }

    public static class Player {
        @Config.Comment(value={"Players drop their players Player Statue"})
        public boolean PlayersDropStatue = true;
        @Config.Comment(value={"Changing this will change the chance a player has of dropping a Player Statue when killed by a player [1 in a x chance] (Default: 1)"})
        public int PlayerDropChance = 1;
        @Config.Comment(value={"Source of death that determines how the Player Statue drops (Default: PLAYER)"})
        public EnumDeathSource PlayerStatueKillSource = EnumDeathSource.PLAYER;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Player Statue Crafting (Default: true)"})
        public boolean PlayerCrafting = true;
        @Config.RequiresMcRestart
        @Config.Comment(value={"When true statues will add a player compass (Default: true)"})
        public boolean PlayerCompass = true;
    }

    public static class General {
        @Config.RequiresMcRestart
        @Config.Comment(value={"Disables all functional statue tiers (tiers that usually drop items) [Default: false]"})
        public boolean nonFunctional = false;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Tier 1 needs to be crafted with Statue Core (Default: true) Disabling this makes tier1 statues drop from mobs."})
        public boolean Tier1Crafting = true;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Setting this to true enables a recipe where the core is replaced by a diamond [ideal for singleplayer when tier 1 crafting is turned off] (Default: false)"})
        public boolean PlayerStatueAlternateRecipe = false;
        @Config.Comment(value={"Setting this to true allows for aquatic statues to be fished up (Default: false)"})
        public boolean AquaticFishing = false;
        @Config.Comment(value={"The drop chance of statues when statue drops is true (Default: 0.01) [This option only takes effect when Tier1Crafting is false]"})
        public double OldDropChance = 0.01;
        @Config.Comment(value={"The amount of time [in seconds] that you have to wait before being able to interact with the statues (tier 2 and higher)(Default: 60)"})
        public int InteractionTimer = 60;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Setting this to false disables the tier 3,4 and 5 recipes. (Default: true)"})
        public boolean CraftableInteraction = true;
        @Config.Comment(value={"Source of death that determines how the Statues drop [player statue has it's own config option] (Default: PLAYER)"})
        public EnumDeathSource StatueKillSource = EnumDeathSource.PLAYER;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Setting this to false disables the statue bat from spawning naturally. (Default: true)"})
        public boolean StatueBatSpawning = true;
    }

    public static enum EnumDeathSource {
        ALL,
        PLAYER,
        PLAYER_FAKEPLAYER;

    }
}

