/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.entity.fakeentity;

import com.shynieke.statues.entity.fakeentity.IFakeEntity;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearest;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class FakeSlime
extends EntitySlime
implements IFakeEntity {
    private static final DataParameter<Integer> SLIME_SIZE = EntityDataManager.func_187226_a(FakeSlime.class, (DataSerializer)DataSerializers.field_187192_b);
    private int lifetime;
    private boolean wasOnGround;

    public FakeSlime(World worldIn) {
        super(worldIn);
        this.field_70765_h = new SlimeMoveHelper(this);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SLIME_SIZE, (Object)1);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AISlimeFloat(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AISlimeAttack(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AISlimeFaceRandom(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AISlimeHop(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIFindEntityNearest((EntityLiving)this, EntityIronGolem.class));
    }

    public void func_184206_a(DataParameter<?> key) {
        if (SLIME_SIZE.equals(key)) {
            int i = this.func_70809_q();
            this.func_70105_a(0.51000005f * (float)i, 0.51000005f * (float)i);
            this.field_70177_z = this.field_70759_as;
            this.field_70761_aq = this.field_70759_as;
            if (this.func_70090_H() && this.field_70146_Z.nextInt(20) == 0) {
                this.func_71061_d_();
            }
        }
        super.func_184206_a(key);
    }

    protected void func_70799_a(int size, boolean resetHealth) {
        this.field_70180_af.func_187227_b(SLIME_SIZE, (Object)size);
        this.func_70105_a(0.51000005f * (float)size, 0.51000005f * (float)size);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(size * size));
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)(0.2f + 0.1f * (float)size));
        if (resetHealth) {
            this.func_70606_j(this.func_110138_aP());
        }
        this.field_70728_aV = size;
    }

    public int func_70809_q() {
        return (Integer)this.field_70180_af.func_187225_a(SLIME_SIZE);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    protected boolean func_146066_aG() {
        return false;
    }

    protected boolean func_70800_m() {
        return false;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        int i = compound.func_74762_e("Size");
        if (i < 0) {
            i = 0;
        }
        this.func_70799_a(i + 1, false);
        this.wasOnGround = compound.func_74767_n("wasOnGround");
        compound.func_74768_a("Lifetime", this.lifetime);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        compound.func_74768_a("Size", this.func_70809_q() - 1);
        compound.func_74757_a("wasOnGround", this.wasOnGround);
        this.lifetime = compound.func_74762_e("Lifetime");
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL && this.func_70809_q() > 0) {
            this.field_70128_L = true;
        }
        this.field_70811_b += (this.field_70813_a - this.field_70811_b) * 0.5f;
        this.field_70812_c = this.field_70811_b;
        super.func_70071_h_();
        if (this.field_70122_E && !this.wasOnGround) {
            int i = this.func_70809_q();
            if (this.spawnCustomParticles()) {
                i = 0;
            }
            for (int j = 0; j < i * 8; ++j) {
                float f = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * f1;
                float f3 = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * f1;
                World world = this.field_70170_p;
                EnumParticleTypes enumparticletypes = this.func_180487_n();
                double d0 = this.field_70165_t + (double)f2;
                double d1 = this.field_70161_v + (double)f3;
                world.func_175688_a(enumparticletypes, d0, this.func_174813_aQ().field_72338_b, d1, 0.0, 0.0, 0.0, new int[0]);
            }
            this.func_184185_a(this.func_184709_cY(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            this.field_70813_a = -0.5f;
        } else if (!this.field_70122_E && this.wasOnGround) {
            this.field_70813_a = 1.0f;
        }
        this.wasOnGround = this.field_70122_E;
        this.func_70808_l();
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            if (!this.func_104002_bU()) {
                ++this.lifetime;
            }
            if (this.lifetime >= 2400) {
                this.func_70106_y();
            }
        }
        super.func_70636_d();
    }

    protected FakeSlime createInstance() {
        return new FakeSlime(this.field_70170_p);
    }

    public void func_70106_y() {
        int i = this.func_70809_q();
        if (!this.field_70170_p.field_72995_K && i > 1 && this.func_110143_aJ() <= 0.0f) {
            int j = 2 + this.field_70146_Z.nextInt(3);
            for (int k = 0; k < j; ++k) {
                float f = ((float)(k % 2) - 0.5f) * (float)i / 4.0f;
                float f1 = ((float)(k / 2) - 0.5f) * (float)i / 4.0f;
                FakeSlime FakeSlime2 = this.createInstance();
                if (this.func_145818_k_()) {
                    FakeSlime2.func_96094_a(this.func_95999_t());
                }
                if (this.func_104002_bU()) {
                    FakeSlime2.func_110163_bv();
                }
                this.func_70799_a(i / 2, true);
                this.func_70012_b(this.field_70165_t + (double)f, this.field_70163_u + 0.5, this.field_70161_v + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)FakeSlime2);
            }
        }
        super.func_70106_y();
    }

    static class SlimeMoveHelper
    extends EntityMoveHelper {
        private float yRot;
        private int jumpDelay;
        private final FakeSlime slime;
        private boolean isAggressive;

        public SlimeMoveHelper(FakeSlime slimeIn) {
            super((EntityLiving)slimeIn);
            this.slime = slimeIn;
            this.yRot = 180.0f * slimeIn.field_70177_z / (float)Math.PI;
        }

        public void setDirection(float p_179920_1_, boolean p_179920_2_) {
            this.yRot = p_179920_1_;
            this.isAggressive = p_179920_2_;
        }

        public void setSpeed(double speedIn) {
            this.field_75645_e = speedIn;
            this.field_188491_h = EntityMoveHelper.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.yRot, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                if (this.field_75648_a.field_70122_E) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.func_70806_k();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.slime.func_70683_ar().func_75660_a();
                        if (this.slime.func_70807_r()) {
                            this.slime.func_184185_a(this.slime.func_184710_cZ(), this.slime.func_70599_aP(), ((this.slime.func_70681_au().nextFloat() - this.slime.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
                        }
                    } else {
                        this.slime.field_70702_br = 0.0f;
                        this.slime.field_191988_bg = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                }
            }
        }
    }

    static class AISlimeHop
    extends EntityAIBase {
        private final FakeSlime slime;

        public AISlimeHop(FakeSlime slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setSpeed(1.0);
        }
    }

    static class AISlimeFloat
    extends EntityAIBase {
        private final FakeSlime slime;

        public AISlimeFloat(FakeSlime slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(5);
            ((PathNavigateGround)slimeIn.func_70661_as()).func_179693_d(true);
        }

        public boolean func_75250_a() {
            return this.slime.func_70090_H() || this.slime.func_180799_ab();
        }

        public void func_75246_d() {
            if (this.slime.func_70681_au().nextFloat() < 0.8f) {
                this.slime.func_70683_ar().func_75660_a();
            }
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setSpeed(1.2);
        }
    }

    static class AISlimeFaceRandom
    extends EntityAIBase {
        private final FakeSlime slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public AISlimeFaceRandom(FakeSlime slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return this.slime.func_70638_az() == null && (this.slime.field_70122_E || this.slime.func_70090_H() || this.slime.func_180799_ab() || this.slime.func_70644_a(MobEffects.field_188424_y));
        }

        public void func_75246_d() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.slime.func_70681_au().nextInt(60);
                this.chosenDegrees = this.slime.func_70681_au().nextInt(360);
            }
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setDirection(this.chosenDegrees, false);
        }
    }

    static class AISlimeAttack
    extends EntityAIBase {
        private final FakeSlime slime;
        private int growTieredTimer;

        public AISlimeAttack(FakeSlime slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.slime.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            return !(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a;
        }

        public void func_75249_e() {
            this.growTieredTimer = 300;
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            EntityLivingBase entitylivingbase = this.slime.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            if (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a) {
                return false;
            }
            return --this.growTieredTimer > 0;
        }

        public void func_75246_d() {
            this.slime.func_70625_a((Entity)this.slime.func_70638_az(), 10.0f, 10.0f);
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setDirection(this.slime.field_70177_z, this.slime.func_70800_m());
        }
    }
}

