/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.entity.fakeentity.fakeprojectiles;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FakeShulkerBullet
extends EntityShulkerBullet {
    private EntityLivingBase owner;
    private Entity target;
    @Nullable
    private EnumFacing direction;
    private int steps;
    private double targetDeltaX;
    private double targetDeltaY;
    private double targetDeltaZ;
    @Nullable
    private UUID ownerUniqueId;
    private BlockPos ownerBlockPos;
    @Nullable
    private UUID targetUniqueId;
    private BlockPos targetBlockPos;

    public FakeShulkerBullet(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.3125f, 0.3125f);
        this.field_70145_X = true;
    }

    @SideOnly(value=Side.CLIENT)
    public FakeShulkerBullet(World worldIn, double x, double y, double z, double motionXIn, double motionYIn, double motionZIn) {
        this(worldIn);
        this.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
        this.field_70159_w = motionXIn;
        this.field_70181_x = motionYIn;
        this.field_70179_y = motionZIn;
    }

    public FakeShulkerBullet(World worldIn, EntityLivingBase ownerIn, Entity targetIn, EnumFacing.Axis p_i46772_4_) {
        this(worldIn);
        this.owner = ownerIn;
        BlockPos blockpos = new BlockPos((Entity)ownerIn);
        double d0 = (double)blockpos.func_177958_n() + 0.5;
        double d1 = (double)blockpos.func_177956_o() + 0.5;
        double d2 = (double)blockpos.func_177952_p() + 0.5;
        this.func_70012_b(d0, d1, d2, this.field_70177_z, this.field_70125_A);
        this.target = targetIn;
        this.direction = EnumFacing.UP;
        this.selectNextMoveDirection(p_i46772_4_);
    }

    private void setDirection(@Nullable EnumFacing directionIn) {
        this.direction = directionIn;
    }

    private void selectNextMoveDirection(@Nullable EnumFacing.Axis p_184569_1_) {
        BlockPos blockpos;
        double d0 = 0.5;
        if (this.target == null) {
            blockpos = new BlockPos((Entity)this).func_177977_b();
        } else {
            d0 = (double)this.target.field_70131_O * 0.5;
            blockpos = new BlockPos(this.target.field_70165_t, this.target.field_70163_u + d0, this.target.field_70161_v);
        }
        double d1 = (double)blockpos.func_177958_n() + 0.5;
        double d2 = (double)blockpos.func_177956_o() + d0;
        double d3 = (double)blockpos.func_177952_p() + 0.5;
        EnumFacing enumfacing = null;
        if (blockpos.func_177957_d(this.field_70165_t, this.field_70163_u, this.field_70161_v) >= 4.0) {
            BlockPos blockpos1 = new BlockPos((Entity)this);
            ArrayList list = Lists.newArrayList();
            if (p_184569_1_ != EnumFacing.Axis.X) {
                if (blockpos1.func_177958_n() < blockpos.func_177958_n() && this.field_70170_p.func_175623_d(blockpos1.func_177974_f())) {
                    list.add(EnumFacing.EAST);
                } else if (blockpos1.func_177958_n() > blockpos.func_177958_n() && this.field_70170_p.func_175623_d(blockpos1.func_177976_e())) {
                    list.add(EnumFacing.WEST);
                }
            }
            if (p_184569_1_ != EnumFacing.Axis.Y) {
                if (blockpos1.func_177956_o() < blockpos.func_177956_o() && this.field_70170_p.func_175623_d(blockpos1.func_177984_a())) {
                    list.add(EnumFacing.UP);
                } else if (blockpos1.func_177956_o() > blockpos.func_177956_o() && this.field_70170_p.func_175623_d(blockpos1.func_177977_b())) {
                    list.add(EnumFacing.DOWN);
                }
            }
            if (p_184569_1_ != EnumFacing.Axis.Z) {
                if (blockpos1.func_177952_p() < blockpos.func_177952_p() && this.field_70170_p.func_175623_d(blockpos1.func_177968_d())) {
                    list.add(EnumFacing.SOUTH);
                } else if (blockpos1.func_177952_p() > blockpos.func_177952_p() && this.field_70170_p.func_175623_d(blockpos1.func_177978_c())) {
                    list.add(EnumFacing.NORTH);
                }
            }
            enumfacing = EnumFacing.func_176741_a((Random)this.field_70146_Z);
            if (list.isEmpty()) {
                for (int i = 5; !this.field_70170_p.func_175623_d(blockpos1.func_177972_a(enumfacing)) && i > 0; --i) {
                    enumfacing = EnumFacing.func_176741_a((Random)this.field_70146_Z);
                }
            } else {
                enumfacing = (EnumFacing)list.get(this.field_70146_Z.nextInt(list.size()));
            }
            d1 = this.field_70165_t + (double)enumfacing.func_82601_c();
            d2 = this.field_70163_u + (double)enumfacing.func_96559_d();
            d3 = this.field_70161_v + (double)enumfacing.func_82599_e();
        }
        this.setDirection(enumfacing);
        double d6 = d1 - this.field_70165_t;
        double d7 = d2 - this.field_70163_u;
        double d4 = d3 - this.field_70161_v;
        double d5 = MathHelper.func_76133_a((double)(d6 * d6 + d7 * d7 + d4 * d4));
        if (d5 == 0.0) {
            this.targetDeltaX = 0.0;
            this.targetDeltaY = 0.0;
            this.targetDeltaZ = 0.0;
        } else {
            this.targetDeltaX = d6 / d5 * 0.15;
            this.targetDeltaY = d7 / d5 * 0.15;
            this.targetDeltaZ = d4 / d5 * 0.15;
        }
        this.field_70160_al = true;
        this.steps = 10 + this.field_70146_Z.nextInt(5) * 10;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        } else {
            super.func_70071_h_();
            if (!this.field_70170_p.field_72995_K) {
                RayTraceResult raytraceresult;
                if (this.target == null && this.targetUniqueId != null) {
                    for (EntityLivingBase entitylivingbase : this.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.targetBlockPos.func_177982_a(-2, -2, -2), this.targetBlockPos.func_177982_a(2, 2, 2)))) {
                        if (!entitylivingbase.func_110124_au().equals(this.targetUniqueId)) continue;
                        this.target = entitylivingbase;
                        break;
                    }
                    this.targetUniqueId = null;
                }
                if (this.owner == null && this.ownerUniqueId != null) {
                    for (EntityLivingBase entitylivingbase1 : this.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.ownerBlockPos.func_177982_a(-2, -2, -2), this.ownerBlockPos.func_177982_a(2, 2, 2)))) {
                        if (!entitylivingbase1.func_110124_au().equals(this.ownerUniqueId)) continue;
                        this.owner = entitylivingbase1;
                        break;
                    }
                    this.ownerUniqueId = null;
                }
                if (this.target == null || !this.target.func_70089_S() || this.target instanceof EntityPlayer && ((EntityPlayer)this.target).func_175149_v()) {
                    if (!this.func_189652_ae()) {
                        this.field_70181_x -= 0.04;
                    }
                } else {
                    this.targetDeltaX = MathHelper.func_151237_a((double)(this.targetDeltaX * 1.025), (double)-1.0, (double)1.0);
                    this.targetDeltaY = MathHelper.func_151237_a((double)(this.targetDeltaY * 1.025), (double)-1.0, (double)1.0);
                    this.targetDeltaZ = MathHelper.func_151237_a((double)(this.targetDeltaZ * 1.025), (double)-1.0, (double)1.0);
                    this.field_70159_w += (this.targetDeltaX - this.field_70159_w) * 0.2;
                    this.field_70181_x += (this.targetDeltaY - this.field_70181_x) * 0.2;
                    this.field_70179_y += (this.targetDeltaZ - this.field_70179_y) * 0.2;
                }
                if ((raytraceresult = ProjectileHelper.func_188802_a((Entity)this, (boolean)true, (boolean)false, (Entity)this.owner)) != null) {
                    this.func_184567_a(raytraceresult);
                }
            }
            this.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            ProjectileHelper.func_188803_a((Entity)this, (float)0.5f);
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.END_ROD, this.field_70165_t - this.field_70159_w, this.field_70163_u - this.field_70181_x + 0.15, this.field_70161_v - this.field_70179_y, 0.0, 0.0, 0.0, new int[0]);
            } else if (this.target != null && !this.target.field_70128_L) {
                if (this.steps > 0) {
                    --this.steps;
                    if (this.steps == 0) {
                        this.selectNextMoveDirection(this.direction == null ? null : this.direction.func_176740_k());
                    }
                }
                if (this.direction != null) {
                    BlockPos blockpos = new BlockPos((Entity)this);
                    EnumFacing.Axis enumfacing$axis = this.direction.func_176740_k();
                    if (this.field_70170_p.func_175677_d(blockpos.func_177972_a(this.direction), false)) {
                        this.selectNextMoveDirection(enumfacing$axis);
                    } else {
                        BlockPos blockpos1 = new BlockPos(this.target);
                        if (enumfacing$axis == EnumFacing.Axis.X && blockpos.func_177958_n() == blockpos1.func_177958_n() || enumfacing$axis == EnumFacing.Axis.Z && blockpos.func_177952_p() == blockpos1.func_177952_p() || enumfacing$axis == EnumFacing.Axis.Y && blockpos.func_177956_o() == blockpos1.func_177956_o()) {
                            this.selectNextMoveDirection(enumfacing$axis);
                        }
                    }
                }
            }
        }
    }

    public boolean func_70027_ad() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 16384.0;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    protected void func_184567_a(RayTraceResult result) {
        if (result.field_72308_g == null) {
            ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2, 0.2, 0.2, 0.2, 0.0, new int[0]);
            this.func_184185_a(SoundEvents.field_187775_eP, 1.0f, 1.0f);
        } else {
            boolean flag = result.field_72308_g.func_70097_a(DamageSource.func_188403_a((Entity)this, (EntityLivingBase)this.owner).func_76349_b(), 0.0f);
            if (flag) {
                this.func_174815_a(this.owner, result.field_72308_g);
                if (result.field_72308_g instanceof EntityLivingBase) {
                    ((EntityLivingBase)result.field_72308_g).func_70690_d(new PotionEffect(MobEffects.field_188424_y, 200));
                }
            }
        }
        this.func_70106_y();
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_184185_a(SoundEvents.field_187777_eQ, 1.0f, 1.0f);
            ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.CRIT, this.field_70165_t, this.field_70163_u, this.field_70161_v, 15, 0.2, 0.2, 0.2, 0.0, new int[0]);
            this.func_70106_y();
        }
        return true;
    }
}

