/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.items;

import com.shynieke.statues.Statues;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPlayerCompass
extends Item {
    public ItemPlayerCompass(String unlocalised) {
        this.func_77655_b("statues:" + unlocalised);
        this.setRegistryName("item" + unlocalised);
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_77637_a(Statues.tabStatues);
        this.func_185043_a(new ResourceLocation("angle"), new IItemPropertyGetter(){
            @SideOnly(value=Side.CLIENT)
            double rotation;
            @SideOnly(value=Side.CLIENT)
            double rota;
            @SideOnly(value=Side.CLIENT)
            long lastUpdateTick;

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                EntityLivingBase entity;
                if (entityIn == null && !stack.func_82839_y()) {
                    return 0.0f;
                }
                boolean flag = entityIn != null;
                Object object = entity = flag ? entityIn : stack.func_82836_z();
                if (worldIn == null) {
                    worldIn = entity.field_70170_p;
                }
                double d1 = flag ? (double)entity.field_70177_z : this.getFrameRotation((EntityItemFrame)entity);
                d1 = MathHelper.func_191273_b((double)(d1 / 360.0), (double)1.0);
                double d2 = this.getLastLocationToAngle(worldIn, (Entity)entity, stack) / (Math.PI * 2);
                double d0 = 0.5 - (d1 - 0.25 - d2);
                if (flag) {
                    d0 = this.wobble(worldIn, d0);
                }
                return MathHelper.func_188207_b((float)((float)d0), (float)1.0f);
            }

            @SideOnly(value=Side.CLIENT)
            private double wobble(World worldIn, double p_185093_2_) {
                if (worldIn.func_82737_E() != this.lastUpdateTick) {
                    this.lastUpdateTick = worldIn.func_82737_E();
                    double d0 = p_185093_2_ - this.rotation;
                    d0 = MathHelper.func_191273_b((double)(d0 + 0.5), (double)1.0) - 0.5;
                    this.rota += d0 * 0.1;
                    this.rota *= 0.8;
                    this.rotation = MathHelper.func_191273_b((double)(this.rotation + this.rota), (double)1.0);
                }
                return this.rotation;
            }

            @SideOnly(value=Side.CLIENT)
            private double getFrameRotation(EntityItemFrame itemFrameIn) {
                return MathHelper.func_188209_b((int)(180 + itemFrameIn.field_174860_b.func_176736_b() * 90));
            }

            @SideOnly(value=Side.CLIENT)
            private double getLastLocationToAngle(World worldIn, Entity entityIn, ItemStack stack) {
                if (stack.func_77942_o()) {
                    Long location;
                    BlockPos lastLocation = worldIn.func_175694_M();
                    NBTTagCompound tag = stack.func_77978_p();
                    if (tag.func_74764_b("lastPlayerLocation") && (location = Long.valueOf(tag.func_74763_f("lastPlayerLocation"))) != 0L) {
                        lastLocation = BlockPos.func_177969_a((long)location);
                    }
                    return Math.atan2((double)lastLocation.func_177952_p() - entityIn.field_70161_v, (double)lastLocation.func_177958_n() - entityIn.field_70165_t);
                }
                return Math.atan2((double)entityIn.func_180425_c().func_177952_p() - entityIn.field_70161_v, (double)entityIn.func_180425_c().func_177958_n() - entityIn.field_70165_t);
            }
        });
    }

    public void func_77624_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        NBTTagCompound tag;
        if (stack.func_77942_o() && !(tag = stack.func_77978_p()).func_74779_i("playerTracking").isEmpty()) {
            tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"statues:last.known.location", (Object[])new Object[]{tag.func_74779_i("playerTracking")}));
        }
    }

    public boolean hasThreeCommas(String theString) {
        int count = 0;
        for (int i = 0; i < theString.length(); ++i) {
            if (!theString.substring(i).startsWith(",")) continue;
            ++count;
        }
        return count == 3;
    }
}

