/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues;

import com.google.common.collect.ImmutableList;
import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.init.StatuesSounds;
import com.shynieke.statues.recipes.StatueLootList;
import com.shynieke.statues.tiles.StatueTile;
import com.shynieke.statues.util.ListHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class CampfireStatueBlock
extends AbstractStatueBase {
    private static final VoxelShape SOUTH_EAST_SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)7.0, (double)16.0);
    private static final VoxelShape NORTH_WEST_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)7.0, (double)11.0);
    public static List<SoundEvent> campfire_sounds = ImmutableList.of((Object)StatuesSounds.campfire_bye_random, (Object)StatuesSounds.campfire_cold_random, (Object)StatuesSounds.campfire_greetings_random, (Object)StatuesSounds.campfire_hello_random, (Object)StatuesSounds.campfire_snacks_random);

    public CampfireStatueBlock(Block.Properties builder) {
        super(builder.func_200947_a(SoundType.field_185851_d).func_200951_a(12));
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((IProperty)field_185512_D);
        return direction.func_176740_k() == Direction.Axis.X ? NORTH_WEST_SHAPE : SOUTH_EAST_SHAPE;
    }

    @Override
    public void executeStatueBehavior(StatueTile tile, BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand handIn, BlockRayTraceResult result) {
        tile.playSound(CampfireStatueBlock.getRandomCampfire(), pos, (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.2f + 1.5f);
        tile.giveItem(StatueLootList.getLootInfo(this.getLootName()).getLoot(), playerIn);
        tile.summonMob((LivingEntity)this.getGeneral(worldIn));
    }

    public CreeperEntity getGeneral(World worldIn) {
        CreeperEntity general = new CreeperEntity(EntityType.field_200797_k, worldIn);
        general.func_200203_b((ITextComponent)new StringTextComponent("General Spazz"));
        CompoundNBT tag = new CompoundNBT();
        tag.func_74774_a("ExplosionRadius", (byte)0);
        general.func_213281_b(tag);
        return general;
    }

    public static SoundEvent getRandomCampfire() {
        SoundEvent sound = ListHelper.getRandomFromList(campfire_sounds);
        return sound;
    }

    @Override
    public String getLootName() {
        return "etho";
    }

    @Override
    public boolean isHiddenStatue() {
        return true;
    }
}

