/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues;

import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.recipes.StatueLootList;
import com.shynieke.statues.tiles.StatueTile;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ChickenJockeyStatueBlock
extends AbstractStatueBase {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0);

    public ChickenJockeyStatueBlock(Block.Properties builder) {
        super(builder.func_200947_a(SoundType.field_185851_d));
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public void executeStatueBehavior(StatueTile tile, BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand handIn, BlockRayTraceResult result) {
        tile.playSound(SoundEvents.field_187899_gZ, pos, (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.2f + 1.5f);
        tile.giveItem(StatueLootList.getLootInfo(this.getLootName()).getLoot(), playerIn);
        tile.summonMob((LivingEntity)new ChickenEntity(EntityType.field_200795_i, worldIn));
        tile.summonMob((LivingEntity)new ZombieEntity(EntityType.field_200725_aD, worldIn));
    }

    @Override
    public String getLootName() {
        return "chicken_jockey";
    }

    @Override
    public boolean isHiddenStatue() {
        return true;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }
}

