/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues;

import com.shynieke.statues.blocks.AbstractBaseBlock;
import com.shynieke.statues.config.StatuesConfig;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;

public class InfoStatueBlock
extends AbstractBaseBlock {
    private static final VoxelShape BOTTOM_SHAPE = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.5, (double)13.0);
    private static final VoxelShape TOP_SHAPE = Block.func_208617_a((double)5.5, (double)4.5, (double)5.5, (double)10.5, (double)7.0, (double)10.5);
    private static final VoxelShape SHAPE = VoxelShapes.func_197872_a((VoxelShape)BOTTOM_SHAPE, (VoxelShape)TOP_SHAPE);

    public InfoStatueBlock(Block.Properties builder) {
        super(builder.func_200947_a(SoundType.field_185851_d));
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand handIn, BlockRayTraceResult result) {
        this.sendInfoMessage(playerIn, worldIn, pos);
        return true;
    }

    public void sendInfoMessage(PlayerEntity player, World worldIn, BlockPos pos) {
        if (!worldIn.field_72995_K) {
            int random = worldIn.field_73012_v.nextInt(100);
            List messages = (List)StatuesConfig.COMMON.info_messages.get();
            List luckyPlayers = (List)StatuesConfig.COMMON.lucky_players.get();
            int idx = new Random().nextInt(messages.size());
            String randomMessage = (String)messages.get(idx);
            if (ModList.get().isLoaded("veinminer") && random < 20) {
                randomMessage = "Did you know we have veinminer";
            }
            if (!luckyPlayers.isEmpty() && random < 20) {
                for (int i = 0; i < luckyPlayers.size(); ++i) {
                    if (((String)luckyPlayers.get(i)).isEmpty()) continue;
                    String luckyUser = ((String)luckyPlayers.get(i)).trim();
                    if (!player.func_145748_c_().func_150254_d().equalsIgnoreCase(luckyUser)) continue;
                    randomMessage = "Luck is not on your side today";
                }
            } else {
                randomMessage = (String)messages.get(idx);
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent(randomMessage, new Object[0]));
            worldIn.func_184133_a(null, pos, SoundEvents.field_187576_at, SoundCategory.NEUTRAL, 0.5f, 1.0f);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }
}

