/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues;

import com.mojang.authlib.GameProfile;
import com.shynieke.statues.blocks.AbstractBaseBlock;
import com.shynieke.statues.config.StatuesConfig;
import com.shynieke.statues.init.StatueBlocks;
import com.shynieke.statues.init.StatueItems;
import com.shynieke.statues.tiles.PlayerTile;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.INameable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

public class PlayerStatueBlock
extends AbstractBaseBlock {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final BooleanProperty ONLINE = BooleanProperty.func_177716_a((String)"online");
    private String playerName;

    public PlayerStatueBlock(Block.Properties builder) {
        super(builder.func_200947_a(SoundType.field_185851_d));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)ONLINE, (Comparable)Boolean.valueOf(false)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PlayerTile();
    }

    private PlayerTile getTE(World world, BlockPos pos) {
        return (PlayerTile)world.func_175625_s(pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, TileEntity te, ItemStack stack) {
        if (te instanceof PlayerTile && ((INameable)te).func_145818_k_()) {
            PlayerTile tile = (PlayerTile)te;
            player.func_71020_j(0.005f);
            if (worldIn.field_72995_K) {
                return;
            }
            Item item = this.func_199767_j();
            if (item == Items.field_190931_a) {
                return;
            }
            ItemStack itemstack = new ItemStack((IItemProvider)item);
            itemstack.func_200302_a(tile.func_200200_C_());
            if (tile.getPlayerProfile() != null) {
                itemstack.func_77982_d(new CompoundNBT());
                CompoundNBT nbttagcompound = new CompoundNBT();
                NBTUtil.func_180708_a((CompoundNBT)nbttagcompound, (GameProfile)tile.getPlayerProfile());
                itemstack.func_77978_p().func_218657_a("PlayerProfile", (INBT)nbttagcompound);
                itemstack.func_200302_a(tile.func_200200_C_());
            }
            PlayerStatueBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemstack);
            if (tile.getComparatorApplied().booleanValue()) {
                PlayerStatueBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)Blocks.field_196762_fd.func_199767_j()));
            }
        } else {
            super.func_180657_a(worldIn, player, pos, state, (TileEntity)null, stack);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean p_196243_5_) {
        if (state.hasTileEntity() && newState.func_177230_c() != StatueBlocks.player_statue) {
            worldIn.func_175713_t(pos);
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof PlayerTile) {
            PlayerTile playerTile = (PlayerTile)tileentity;
            ItemStack stack = new ItemStack((IItemProvider)state.func_177230_c());
            if (playerTile != null && playerTile.getPlayerProfile() != null) {
                stack.func_77982_d(new CompoundNBT());
                CompoundNBT nbttagcompound = new CompoundNBT();
                NBTUtil.func_180708_a((CompoundNBT)nbttagcompound, (GameProfile)playerTile.getPlayerProfile());
                stack.func_77978_p().func_218657_a("PlayerProfile", (INBT)nbttagcompound);
            }
            return stack.func_200302_a(playerTile.func_200200_C_());
        }
        return new ItemStack((IItemProvider)state.func_177230_c());
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, (BlockState)state.func_206870_a((IProperty)ONLINE, (Comparable)Boolean.valueOf(false)), placer, stack);
        String stackname = stack.func_200301_q().getString();
        String tilename = this.getTE(worldIn, pos).func_200200_C_().getString();
        if (tilename != stackname) {
            this.playerName = stackname;
            if ((this.playerName.contains(" ") || this.playerName.isEmpty()) && placer instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)placer;
                this.getTE(worldIn, pos).setName(player.func_200200_C_().getString());
                this.getTE(worldIn, pos).setPlayerProfile(new GameProfile((UUID)null, player.func_200200_C_().getString()));
            } else {
                GameProfile gameprofile = null;
                GameProfile newProfile = null;
                if (!this.playerName.isEmpty() && !this.playerName.contains(" ")) {
                    newProfile = new GameProfile((UUID)null, this.playerName);
                }
                if (stack.func_77942_o()) {
                    CompoundNBT tag = stack.func_77978_p();
                    String playerName = null;
                    if (tag.func_74764_b("PlayerProfile")) {
                        newProfile = NBTUtil.func_152459_a((CompoundNBT)tag.func_74775_l("PlayerProfile"));
                    } else if (tag.func_150297_b("PlayerProfile", 8) && !StringUtils.isBlank((CharSequence)this.playerName)) {
                        gameprofile = new GameProfile((UUID)null, this.playerName);
                    }
                    if (tag.func_74764_b("PlayerName")) {
                        playerName = tag.func_74779_i("PlayerName");
                    }
                    if (!newProfile.getName().equals(this.playerName)) {
                        newProfile = new GameProfile((UUID)null, this.playerName);
                        this.getTE(worldIn, pos).setName(this.playerName);
                        if (newProfile != null) {
                            this.getTE(worldIn, pos).setPlayerProfile(newProfile);
                        }
                    } else if (gameprofile != null && playerName != null) {
                        if (gameprofile.getName() != this.playerName) {
                            this.getTE(worldIn, pos).setName(this.playerName);
                            this.getTE(worldIn, pos).setPlayerProfile(gameprofile);
                        } else {
                            this.getTE(worldIn, pos).setName(this.playerName);
                            this.getTE(worldIn, pos).setPlayerProfile(newProfile);
                        }
                    } else {
                        this.getTE(worldIn, pos).setName(this.playerName);
                        this.getTE(worldIn, pos).setPlayerProfile(newProfile);
                    }
                } else {
                    this.getTE(worldIn, pos).setPlayerProfile(newProfile);
                }
            }
            this.getTE(worldIn, pos).func_70296_d();
        }
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader reader, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (Screen.hasShiftDown() && stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            tooltip.add(new StringTextComponent("Username: " + stack.func_200301_q().func_150254_d()).func_211708_a(TextFormatting.GOLD));
            if (tag.func_74764_b("PlayerProfile")) {
                GameProfile gameprofile = null;
                if (tag.func_74764_b("PlayerProfile")) {
                    gameprofile = NBTUtil.func_152459_a((CompoundNBT)((CompoundNBT)tag.func_74781_a("PlayerProfile")));
                } else if (tag.func_74764_b("PlayerProfile") && !StringUtils.isBlank((CharSequence)tag.func_74779_i("PlayerProfile"))) {
                    gameprofile = new GameProfile((UUID)null, tag.func_74779_i("PlayerProfile"));
                }
                if (gameprofile != null) {
                    tooltip.add(new StringTextComponent("UUID: " + gameprofile.getId().toString()).func_211708_a(TextFormatting.GOLD));
                }
            }
        }
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (((Boolean)blockState.func_177229_b((IProperty)ONLINE)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public boolean canConnectRedstone(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.func_177229_b((IProperty)ONLINE);
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return false;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_185512_D, WATERLOGGED, ONLINE});
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult result) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (!worldIn.field_72995_K) {
            String playerName = this.getTE(worldIn, pos).getPlayerProfile().getName();
            if (!playerIn.func_70093_af() && stack.func_77973_b() == Items.field_151111_aL && ((Boolean)StatuesConfig.COMMON.playerCompass.get()).booleanValue()) {
                if (this.getTE(worldIn, pos).getPlayerProfile() != null && worldIn.func_217371_b(this.getTE(worldIn, pos).getPlayerProfile().getId()) != null) {
                    ItemStack playerCompass = new ItemStack((IItemProvider)StatueItems.player_compass);
                    CompoundNBT locationTag = new CompoundNBT();
                    PlayerEntity player = worldIn.func_217371_b(this.getTE(worldIn, pos).getPlayerProfile().getId());
                    if (player.field_71093_bK == playerIn.field_71093_bK) {
                        BlockPos playerPos = player.func_180425_c();
                        locationTag.func_74772_a("lastPlayerLocation", playerPos.func_218275_a());
                        locationTag.func_74778_a("playerTracking", this.getTE(worldIn, pos).getPlayerProfile().getName());
                        playerCompass.func_77982_d(locationTag);
                        stack.func_190918_g(1);
                        if (stack.func_190926_b()) {
                            playerIn.func_184611_a(hand, playerCompass);
                        } else if (!playerIn.field_71071_by.func_70441_a(playerCompass)) {
                            playerIn.func_71019_a(playerCompass, false);
                        }
                    } else {
                        playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("statues:player.compass.dimension.failure", new Object[]{TextFormatting.GOLD + playerName}));
                        stack.func_190918_g(1);
                        if (stack.func_190926_b()) {
                            playerIn.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151111_aL));
                        } else if (!playerIn.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Items.field_151111_aL))) {
                            playerIn.func_71019_a(new ItemStack((IItemProvider)Items.field_151111_aL), false);
                        }
                    }
                    return true;
                }
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("statues:player.compass.offline", new Object[]{TextFormatting.GOLD + playerName}));
                stack.func_190918_g(1);
                if (stack.func_190926_b()) {
                    playerIn.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151111_aL));
                } else if (!playerIn.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Items.field_151111_aL))) {
                    playerIn.func_71019_a(new ItemStack((IItemProvider)Items.field_151111_aL), false);
                }
                return true;
            }
            if (!playerIn.func_70093_af() && stack.func_77973_b() == StatueItems.player_compass && ((Boolean)StatuesConfig.COMMON.playerCompass.get()).booleanValue()) {
                if (this.getTE(worldIn, pos).getPlayerProfile() != null && worldIn.func_217371_b(this.getTE(worldIn, pos).getPlayerProfile().getId()) != null && this.getTE(worldIn, pos).getPlayerProfile().getName() != null) {
                    CompoundNBT locationTag = new CompoundNBT();
                    PlayerEntity player = worldIn.func_217371_b(this.getTE(worldIn, pos).getPlayerProfile().getId());
                    if (player.field_71093_bK == playerIn.field_71093_bK) {
                        BlockPos playerPos = player.func_180425_c();
                        locationTag.func_74772_a("lastPlayerLocation", playerPos.func_218275_a());
                        locationTag.func_74778_a("playerTracking", this.getTE(worldIn, pos).getPlayerProfile().getName());
                        stack.func_77982_d(locationTag);
                    } else {
                        playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("statues:player.compass.dimension.failure", new Object[]{TextFormatting.GOLD + playerName}));
                        stack.func_190918_g(1);
                        if (stack.func_190926_b()) {
                            playerIn.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151111_aL));
                        } else if (!playerIn.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Items.field_151111_aL))) {
                            playerIn.func_71019_a(new ItemStack((IItemProvider)Items.field_151111_aL), false);
                        }
                    }
                    return true;
                }
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("statues:player.compass.offline", new Object[]{TextFormatting.GOLD + playerName}));
                stack.func_190918_g(1);
                if (stack.func_190926_b()) {
                    playerIn.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151111_aL));
                } else if (!playerIn.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Items.field_151111_aL))) {
                    playerIn.func_71019_a(new ItemStack((IItemProvider)Items.field_151111_aL), false);
                }
                return true;
            }
            if (!playerIn.func_70093_af() && stack.func_77973_b() == Blocks.field_196762_fd.func_199767_j()) {
                if (!this.getTE(worldIn, pos).getComparatorApplied().booleanValue()) {
                    stack.func_190918_g(1);
                    this.getTE(worldIn, pos).setComparatorApplied(true);
                    return true;
                }
            } else {
                if (playerIn.func_70093_af() && stack.func_190926_b() && this.getTE(worldIn, pos).getComparatorApplied().booleanValue()) {
                    this.getTE(worldIn, pos).setComparatorApplied(false);
                    playerIn.func_184611_a(hand, new ItemStack((IItemProvider)Blocks.field_196762_fd.func_199767_j()));
                    return true;
                }
                if (playerIn.func_70093_af() && stack.func_77973_b() == StatueItems.player_compass) {
                    stack.func_190918_g(1);
                    if (stack.func_190926_b()) {
                        playerIn.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151111_aL));
                    } else if (!playerIn.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Items.field_151111_aL))) {
                        playerIn.func_71019_a(new ItemStack((IItemProvider)Items.field_151111_aL), false);
                    }
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)((BlockState)state.func_206870_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)field_185512_D)))).func_206870_a((IProperty)ONLINE, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)field_185512_D))).func_206870_a((IProperty)ONLINE, (Comparable)Boolean.valueOf(false));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }
}

