/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.compat.ct;

import com.blamejared.crafttweaker.api.actions.IUndoableAction;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.compat.ct.loot.CTStatueLoot;
import com.shynieke.statues.items.StatueBlockItem;
import com.shynieke.statues.recipes.StatueLootList;

public class ActionChangeLoot
implements IUndoableAction {
    public final String statueName;
    public final CTStatueLoot loot;
    public final CTStatueLoot oldLoot;
    public IItemStack statueStack;

    public ActionChangeLoot(String statueName, CTStatueLoot loot) {
        this.statueName = statueName;
        this.oldLoot = new CTStatueLoot(StatueLootList.getLootInfo(statueName).getLoot());
        this.loot = loot;
    }

    public ActionChangeLoot(IItemStack statue, CTStatueLoot loot) {
        if (statue.getInternal().func_77973_b() instanceof StatueBlockItem) {
            StatueBlockItem blockItem = (StatueBlockItem)statue.getInternal().func_77973_b();
            AbstractStatueBase statueBlock = (AbstractStatueBase)blockItem.func_179223_d();
            this.statueName = statueBlock.getLootName();
        } else {
            this.statueStack = statue;
            this.statueName = "";
        }
        this.oldLoot = new CTStatueLoot(StatueLootList.getLootInfo(this.statueName).getLoot());
        this.loot = loot;
    }

    public void undo() {
        StatueLootList.changeLoot(this.statueName, this.oldLoot.getInternal());
    }

    public String describeUndo() {
        if (this.statueName.isEmpty()) {
            return String.format("Could not undo loot changes since the stack %s specified is not recognized as a statue, \nif you think this is a bug please report this to the author.", this.statueStack.toString());
        }
        return String.format("Undid loot changes to statue: " + this.statueName, new Object[0]);
    }

    public void apply() {
        StatueLootList.changeLoot(this.statueName, this.loot.getInternal());
    }

    public String describe() {
        if (this.statueName.isEmpty()) {
            return String.format("Could not change loot since the stack %s specified is not recognized as a statue, \nif you think this is a bug please report this to the author.", this.statueStack.toString());
        }
        return String.format("Applied loot changes to statue: " + this.statueName, new Object[0]);
    }
}

