/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.tiles.render;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.platform.GlStateManager;
import com.shynieke.statues.blocks.statues.PlayerStatueBlock;
import com.shynieke.statues.tiles.PlayerTile;
import com.shynieke.statues.util.SkinUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
public class PlayerTileRenderer
extends TileEntityRenderer<PlayerTile> {
    public static PlayerTileRenderer instance;
    public static final PlayerModel model;
    public static final PlayerModel slimModel;
    private static final Map<String, GameProfile> GAMEPROFILE_CACHE;

    public void func_147497_a(TileEntityRendererDispatcher rendererDispatcherIn) {
        this.field_147501_a = rendererDispatcherIn;
        instance = this;
    }

    public void render(PlayerTile te, double x, double y, double z, float partialTicks, int destroyStage) {
        Direction direction = Direction.UP;
        this.renderPlayer(te, x, y, z, te.getPlayerProfile(), destroyStage, direction);
    }

    public void renderPlayerItem(ItemStack stack) {
        if (stack != null) {
            GameProfile gameprofile = null;
            if (GAMEPROFILE_CACHE.containsKey(stack.func_200301_q().getString())) {
                gameprofile = GAMEPROFILE_CACHE.get(stack.func_200301_q().getString());
            }
            if (stack.func_77942_o() && gameprofile == null) {
                CompoundNBT nbttagcompound = stack.func_77978_p();
                if (nbttagcompound.func_150297_b("PlayerProfile", 10)) {
                    gameprofile = NBTUtil.func_152459_a((CompoundNBT)nbttagcompound.func_74775_l("PlayerProfile"));
                } else if (nbttagcompound.func_150297_b("PlayerProfile", 8) && !StringUtils.isBlank((CharSequence)nbttagcompound.func_74779_i("PlayerProfile"))) {
                    GameProfile gameprofile1 = new GameProfile(null, nbttagcompound.func_74779_i("PlayerProfile"));
                    gameprofile = SkullTileEntity.func_174884_b((GameProfile)gameprofile1);
                    nbttagcompound.func_82580_o("PlayerProfile");
                    nbttagcompound.func_218657_a("PlayerProfile", (INBT)NBTUtil.func_180708_a((CompoundNBT)new CompoundNBT(), (GameProfile)gameprofile));
                    GAMEPROFILE_CACHE.put(gameprofile.getName(), gameprofile);
                }
            }
            if (!(gameprofile != null || StringUtils.isBlank((CharSequence)stack.func_200301_q().getString()) || stack.func_200301_q().getString().equals("Player Statue") || stack.func_200301_q().getString().equals(" "))) {
                GameProfile gameprofile1 = new GameProfile(null, stack.func_200301_q().getString());
                gameprofile = SkullTileEntity.func_174884_b((GameProfile)gameprofile1);
                GAMEPROFILE_CACHE.put(gameprofile.getName(), gameprofile);
            }
            ResourceLocation skinlocation = DefaultPlayerSkin.func_177335_a();
            PlayerModel theModel = model;
            boolean slimModel = false;
            if (gameprofile != null) {
                Minecraft minecraft = Minecraft.func_71410_x();
                Map map = minecraft.func_152342_ad().func_152788_a(gameprofile);
                if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    skinlocation = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                } else {
                    UUID uuid = PlayerEntity.func_146094_a((GameProfile)gameprofile);
                    skinlocation = DefaultPlayerSkin.func_177334_a((UUID)uuid);
                }
                slimModel = gameprofile.getId() != null ? SkinUtil.isSlimSkin(gameprofile.getId()) : false;
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(skinlocation);
            GlStateManager.pushMatrix();
            GlStateManager.disableCull();
            GlStateManager.translatef((float)0.5f, (float)1.5f, (float)0.5f);
            GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)-1.0f);
            GlStateManager.translatef((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.scalef((float)0.9995f, (float)0.9995f, (float)0.9995f);
            GlStateManager.translatef((float)0.0f, (float)-1.0f, (float)0.0f);
            GlStateManager.translatef((float)0.0f, (float)0.75f, (float)0.0f);
            GlStateManager.rotatef((float)-180.0f, (float)0.0f, (float)180.0f, (float)0.0f);
            GlStateManager.enableRescaleNormal();
            GlStateManager.enableAlphaTest();
            GlStateManager.setProfile((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
            if (slimModel) {
                theModel = PlayerTileRenderer.slimModel;
            }
            theModel.field_78115_e.func_78785_a(0.03125f);
            theModel.field_78116_c.func_78785_a(0.03125f);
            theModel.field_178724_i.func_78785_a(0.03125f);
            theModel.field_178723_h.func_78785_a(0.03125f);
            theModel.field_178722_k.func_78785_a(0.03125f);
            theModel.field_178721_j.func_78785_a(0.03125f);
            theModel.field_178730_v.func_78785_a(0.03125f);
            theModel.field_178720_f.func_78785_a(0.03125f);
            theModel.field_178734_a.func_78785_a(0.03125f);
            theModel.field_178732_b.field_82907_q = -0.3125f;
            theModel.field_178732_b.func_78785_a(0.03125f);
            theModel.field_178733_c.func_78785_a(0.03125f);
            theModel.field_178731_d.func_78785_a(0.03125f);
            GlStateManager.popMatrix();
        }
    }

    private void renderPlayer(PlayerTile te, double x, double y, double z, @Nullable GameProfile profile, int destroyStage, Direction enumfacing) {
        PlayerModel theModel = model;
        boolean slimModel = false;
        if (te == null) {
            profile = null;
            enumfacing = Direction.UP;
        } else {
            BlockState state;
            profile = te.getPlayerProfile();
            enumfacing = te.func_145831_w().func_180495_p(te.func_174877_v()) != null ? ((state = te.func_145831_w().func_180495_p(te.func_174877_v())).func_177230_c() instanceof HorizontalBlock ? (Direction)state.func_177229_b((IProperty)PlayerStatueBlock.field_185512_D) : Direction.UP) : Direction.UP;
        }
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.matrixMode((int)5890);
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)4.0f, (float)4.0f, (float)1.0f);
            GlStateManager.translatef((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.matrixMode((int)5888);
        } else {
            this.func_147499_a(this.bindPlayerSkin(profile));
        }
        GlStateManager.pushMatrix();
        GlStateManager.disableCull();
        GlStateManager.translatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.translatef((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.scalef((float)0.9995f, (float)0.9995f, (float)0.9995f);
        GlStateManager.translatef((float)0.0f, (float)-1.0f, (float)0.0f);
        switch (enumfacing) {
            default: {
                GlStateManager.translatef((float)0.0f, (float)0.75f, (float)0.0f);
                GlStateManager.rotatef((float)-180.0f, (float)0.0f, (float)180.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.translatef((float)0.0f, (float)0.75f, (float)0.0f);
                GlStateManager.rotatef((float)0.0f, (float)0.0f, (float)90.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.translatef((float)0.0f, (float)0.75f, (float)0.0f);
                GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)-90.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.translatef((float)0.0f, (float)0.75f, (float)0.0f);
                GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)90.0f, (float)0.0f);
            }
        }
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableAlphaTest();
        GlStateManager.setProfile((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
        if (slimModel) {
            theModel = PlayerTileRenderer.slimModel;
        }
        theModel.field_78115_e.func_78785_a(0.03125f);
        theModel.field_78116_c.func_78785_a(0.03125f);
        theModel.field_178724_i.func_78785_a(0.03125f);
        theModel.field_178723_h.func_78785_a(0.03125f);
        theModel.field_178722_k.func_78785_a(0.03125f);
        theModel.field_178721_j.func_78785_a(0.03125f);
        theModel.field_178730_v.func_78785_a(0.03125f);
        theModel.field_178720_f.func_78785_a(0.03125f);
        theModel.field_178734_a.func_78785_a(0.03125f);
        theModel.field_178732_b.field_82907_q = -0.3125f;
        theModel.field_178732_b.func_78785_a(0.03125f);
        theModel.field_178733_c.func_78785_a(0.03125f);
        theModel.field_178731_d.func_78785_a(0.03125f);
        GlStateManager.popMatrix();
        if (destroyStage >= 0) {
            GlStateManager.matrixMode((int)5890);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5888);
        }
    }

    private ResourceLocation bindPlayerSkin(@Nullable GameProfile profile) {
        ResourceLocation resourcelocation = DefaultPlayerSkin.func_177335_a();
        if (profile != null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            Map map = minecraft.func_152342_ad().func_152788_a(profile);
            resourcelocation = map.containsKey(MinecraftProfileTexture.Type.SKIN) ? minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN) : DefaultPlayerSkin.func_177334_a((UUID)PlayerEntity.func_146094_a((GameProfile)profile));
        }
        return resourcelocation;
    }

    static {
        model = new PlayerModel(0.03125f, false);
        slimModel = new PlayerModel(0.03125f, true);
        GAMEPROFILE_CACHE = new HashMap<String, GameProfile>();
    }
}

