/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib;

import com.mojang.blaze3d.platform.GlStateManager;
import epicsquid.mysticallib.particle.ParticleRegistry;
import epicsquid.mysticallib.setup.ClientProxy;
import epicsquid.mysticallib.util.FluidTextureUtil;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mysticallib", value={Dist.CLIENT})
public class LibEvents {
    public static int ticks = 0;

    @SubscribeEvent
    public static void onTextureStitchPre(TextureStitchEvent.Pre event) {
        FluidTextureUtil.initTextures(event.getMap());
    }

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        for (Map.Entry<String, ResourceLocation> e : ParticleRegistry.particleTextures.entrySet()) {
            event.addSprite(e.getValue());
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++ticks;
            ClientProxy.particleRenderer.updateParticles();
        }
    }

    @SubscribeEvent
    public static void onRenderAfterWorld(RenderWorldLastEvent event) {
        GlStateManager.pushMatrix();
        ClientProxy.particleRenderer.renderParticles(event.getPartialTicks());
        GlStateManager.popMatrix();
    }
}

