/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.client.data;

import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.LogBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ModelFile;

public abstract class DeferredBlockStateProvider
extends BlockStateProvider {
    private final String name;

    public DeferredBlockStateProvider(String name, DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
        super(gen, modid, exFileHelper);
        this.name = name;
    }

    @Nonnull
    public String func_200397_b() {
        return this.name;
    }

    protected String name(Supplier<? extends Block> block) {
        return block.get().getRegistryName().func_110623_a();
    }

    protected ResourceLocation blockModel(Supplier<? extends Block> block) {
        return this.blockTexture(block);
    }

    protected ResourceLocation blockTexture(Supplier<? extends Block> block) {
        ResourceLocation base = block.get().getRegistryName();
        return new ResourceLocation(base.func_110624_b(), this.folder + "/" + base.func_110623_a());
    }

    protected ResourceLocation modLocation(String texture) {
        return new ResourceLocation(this.modid, texture);
    }

    protected ResourceLocation blockLocation(String texture) {
        return this.modLocation("block/" + texture);
    }

    protected void simpleBlock(Supplier<? extends Block> block) {
        super.simpleBlock(block.get());
    }

    protected void simpleBlock(Supplier<? extends Block> block, Function<ModelFile, ConfiguredModel[]> expander) {
        super.simpleBlock(block.get(), expander);
    }

    protected void simpleBlock(Supplier<? extends Block> block, ModelFile model) {
        super.simpleBlock(block.get(), model);
    }

    protected void simpleBlock(Supplier<? extends Block> block, ConfiguredModel ... models) {
        super.simpleBlock(block.get(), models);
    }

    protected void simpleModel(Supplier<? extends Block> block) {
        this.simpleBlock(block, (ModelFile)this.getExistingFile(this.blockModel(block)));
    }

    protected void horizontalBlock(Supplier<? extends Block> block, ModelFile model) {
        this.horizontalBlock(block.get(), model);
    }

    protected void horizontalModel(Supplier<? extends Block> block) {
        this.horizontalBlock(block, (ModelFile)this.getExistingFile(this.blockModel(block)));
    }

    protected final Function<BlockState, String> booleanStateDescriptor(BooleanProperty prop) {
        return state -> (Boolean)state.func_177229_b((IProperty)prop) != false ? "on" : "off";
    }

    protected final Function<Object[], ResourceLocation> booleanStateLoc(String base) {
        return args -> new ResourceLocation(this.modid, String.format(base, args));
    }

    @SafeVarargs
    protected final void horizontalBooleanStateBlock(Supplier<? extends Block> block, Function<Object[], ResourceLocation> rlSupplier, Function<BlockState, String> ... descriptors) {
        this.horizontalBlock(block.get(), state -> this.getExistingFile((ResourceLocation)rlSupplier.apply(Stream.of(descriptors).map(o -> (String)o.apply(state)).toArray(String[]::new))));
    }

    protected void stairsBlock(Supplier<? extends StairsBlock> block, String name) {
        this.stairsBlock(block, name, name);
    }

    protected void stairsBlock(Supplier<? extends StairsBlock> block, String side, String topBottom) {
        this.stairsBlock(block, side, topBottom, topBottom);
    }

    protected void stairsBlock(Supplier<? extends StairsBlock> block, String side, String top, String bottom) {
        this.stairsBlock(block.get(), this.blockLocation(side), this.blockLocation(top), this.blockLocation(bottom));
    }

    protected void slabBlock(Supplier<? extends SlabBlock> block, Supplier<? extends Block> doubleBlock) {
        this.slabBlock(block, doubleBlock, this.name(doubleBlock));
    }

    protected void slabBlock(Supplier<? extends SlabBlock> block, Supplier<? extends Block> doubleBlock, String texture) {
        this.slabBlock(block, doubleBlock, texture, texture);
    }

    protected void slabBlock(Supplier<? extends SlabBlock> block, Supplier<? extends Block> doubleBlock, String side, String end) {
        this.slabBlock(block.get(), doubleBlock.get().getRegistryName(), this.blockLocation(side), this.blockLocation(end), this.blockLocation(end));
    }

    protected void fenceBlock(Supplier<? extends FenceBlock> block, String texture) {
        this.fenceBlock(block.get(), this.blockLocation(texture));
        this.fenceInventory(this.name(block) + "_inventory", this.blockLocation(texture));
    }

    protected void fenceGateBlock(Supplier<? extends FenceGateBlock> block, String texture) {
        this.fenceGateBlock(block.get(), this.blockLocation(texture));
    }

    protected void wallBlock(Supplier<? extends WallBlock> block, String texture) {
        this.wallBlock(block.get(), this.blockLocation(texture));
        this.wallInventory(this.name(block) + "_inventory", this.blockLocation(texture));
    }

    protected void doorBlock(Supplier<? extends DoorBlock> block) {
        this.doorBlock(block.get(), this.blockLocation(this.name(block) + "_bottom"), this.blockLocation(this.name(block) + "_top"));
    }

    protected void trapDoorBlock(Supplier<? extends TrapDoorBlock> block) {
        this.trapdoorBlock(block.get(), this.blockTexture(block), true);
    }

    protected void logBlock(Supplier<? extends LogBlock> block) {
        this.logBlock(block.get());
    }
}

