/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.model;

import epicsquid.mysticallib.model.CustomModelBase;
import epicsquid.mysticallib.model.block.BakedModelBlock;
import java.lang.reflect.Constructor;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class CustomModelBlock
extends CustomModelBase {
    private Constructor<? extends BakedModelBlock> ctor;

    public CustomModelBlock(@Nonnull Class<? extends BakedModelBlock> block, @Nonnull ResourceLocation particle, @Nonnull ResourceLocation all) {
        this(block, particle, all, all, all, all, all, all);
    }

    public CustomModelBlock(@Nonnull Class<? extends BakedModelBlock> block, @Nonnull ResourceLocation particle, @Nonnull ResourceLocation west, @Nonnull ResourceLocation east, @Nonnull ResourceLocation down, @Nonnull ResourceLocation up, @Nonnull ResourceLocation north, @Nonnull ResourceLocation south) {
        try {
            this.ctor = block.getConstructor(IModelState.class, VertexFormat.class, Function.class, CustomModelBase.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        this.addTexture("particle", particle);
        this.addTexture("north", north);
        this.addTexture("south", south);
        this.addTexture("east", east);
        this.addTexture("west", west);
        this.addTexture("up", up);
        this.addTexture("down", down);
    }

    public CustomModelBlock(@Nonnull Class<? extends BakedModelBlock> block, @Nonnull ResourceLocation particle, Pair<String, ResourceLocation> ... textures) {
        try {
            this.ctor = block.getConstructor(IModelState.class, VertexFormat.class, Function.class, CustomModelBase.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        this.addTexture("particle", particle);
        for (Pair<String, ResourceLocation> p : textures) {
            this.addTexture((String)p.getLeft(), (ResourceLocation)p.getRight());
        }
    }

    @Override
    @Nullable
    public IBakedModel bake(ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format) {
        return super.bake(bakery, spriteGetter, sprite, format);
    }

    @Override
    @Nonnull
    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }
}

