/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.model.block;

import epicsquid.mysticallib.model.CustomModelBase;
import epicsquid.mysticallib.model.ModelUtil;
import epicsquid.mysticallib.model.block.BakedModelBlock;
import epicsquid.mysticallib.model.parts.Cube;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;

public class BakedModelDoor
extends BakedModelBlock {
    private Cube cube_east;
    private Cube cube_west;
    private Cube cube_south;
    private Cube cube_north;

    public BakedModelDoor(@Nonnull IModelState state, @Nonnull VertexFormat format, @Nonnull Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, @Nonnull CustomModelBase model) {
        super(format, bakedTextureGetter, model);
        TextureAtlasSprite[] texes = new TextureAtlasSprite[]{this.texwest, this.texeast, this.texdown, this.texup, this.texnorth, this.texsouth};
        this.cube_west = ModelUtil.makeCube(format, 0.8125, 0.0, 0.0, 0.1875, 1.0, 1.0, null, texes, 0).setNoCull(Direction.WEST);
        this.cube_east = ModelUtil.makeCube(format, 0.0, 0.0, 0.0, 0.1875, 1.0, 1.0, null, texes, 0).setNoCull(Direction.EAST);
        this.cube_north = ModelUtil.makeCube(format, 0.0, 0.0, 0.8125, 1.0, 1.0, 0.1875, null, texes, 0).setNoCull(Direction.NORTH);
        this.cube_south = ModelUtil.makeCube(format, 0.0, 0.0, 0.0, 1.0, 1.0, 0.1875, null, texes, 0).setNoCull(Direction.SOUTH);
    }

    @Override
    @Nonnull
    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        this.getFaceQuads(quads, side, state);
        return quads;
    }

    private void getFaceQuads(@Nonnull List<BakedQuad> quads, @Nullable Direction side, @Nullable BlockState state) {
        if (state == null) {
            this.cube_east.addToList(quads, side);
        } else {
            DoorHingeSide hinge = (DoorHingeSide)state.func_177229_b((IProperty)DoorBlock.field_176521_M);
            boolean open = (Boolean)state.func_177229_b((IProperty)DoorBlock.field_176519_b);
            switch ((Direction)state.func_177229_b((IProperty)DoorBlock.field_176520_a)) {
                case EAST: {
                    if (open) {
                        if (hinge == DoorHingeSide.LEFT) {
                            this.cube_south.addToList(quads, side);
                            break;
                        }
                        this.cube_north.addToList(quads, side);
                        break;
                    }
                    this.cube_east.addToList(quads, side);
                    break;
                }
                case SOUTH: {
                    if (open) {
                        if (hinge == DoorHingeSide.LEFT) {
                            this.cube_west.addToList(quads, side);
                            break;
                        }
                        this.cube_east.addToList(quads, side);
                        break;
                    }
                    this.cube_south.addToList(quads, side);
                    break;
                }
                case WEST: {
                    if (open) {
                        if (hinge == DoorHingeSide.LEFT) {
                            this.cube_north.addToList(quads, side);
                            break;
                        }
                        this.cube_south.addToList(quads, side);
                        break;
                    }
                    this.cube_west.addToList(quads, side);
                    break;
                }
                case NORTH: {
                    if (open) {
                        if (hinge == DoorHingeSide.LEFT) {
                            this.cube_east.addToList(quads, side);
                            break;
                        }
                        this.cube_west.addToList(quads, side);
                        break;
                    }
                    this.cube_north.addToList(quads, side);
                }
            }
        }
    }
}

