/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.model.block;

import epicsquid.mysticallib.model.CustomModelBase;
import epicsquid.mysticallib.model.ModelUtil;
import epicsquid.mysticallib.model.block.BakedModelBlock;
import epicsquid.mysticallib.model.parts.Cube;
import epicsquid.mysticallib.struct.Vec4f;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceBlock;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;

public class BakedModelFence
extends BakedModelBlock {
    private Cube post_right;
    private Cube post_left;
    private Cube west;
    private Cube west_top;
    private Cube north;
    private Cube north_top;
    private Cube south;
    private Cube south_top;
    private Cube east;
    private Cube east_top;
    private Cube post;

    public BakedModelFence(@Nonnull IModelState state, @Nonnull VertexFormat format, @Nonnull Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, @Nonnull CustomModelBase model) {
        super(format, bakedTextureGetter, model);
        TextureAtlasSprite[] texes = new TextureAtlasSprite[]{this.texwest, this.texeast, this.texdown, this.texup, this.texnorth, this.texsouth};
        this.post_right = this.makePostCube(format, 0.0, 0.0, 0.375, 0.25, 1.0, 0.25, null, texes, 0);
        this.post_left = this.makePostCube(format, 0.75, 0.0, 0.375, 0.25, 1.0, 0.25, null, texes, 0);
        this.north = ModelUtil.makeCube(format, 0.4375, 0.375, 0.0, 0.125, 0.1875, 0.375, null, texes, 0);
        this.south = ModelUtil.makeCube(format, 0.4375, 0.375, 0.625, 0.125, 0.1875, 0.375, null, texes, 0);
        this.west = ModelUtil.makeCube(format, 0.0, 0.375, 0.4375, 0.375, 0.1875, 0.125, null, texes, 0);
        this.east = ModelUtil.makeCube(format, 0.625, 0.375, 0.4375, 0.375, 0.1875, 0.125, null, texes, 0);
        this.north_top = ModelUtil.makeCube(format, 0.4375, 0.75, 0.0, 0.125, 0.1875, 0.375, null, texes, 0);
        this.south_top = ModelUtil.makeCube(format, 0.4375, 0.75, 0.625, 0.125, 0.1875, 0.375, null, texes, 0);
        this.west_top = ModelUtil.makeCube(format, 0.0, 0.75, 0.4375, 0.375, 0.1875, 0.125, null, texes, 0);
        this.east_top = ModelUtil.makeCube(format, 0.625, 0.75, 0.4375, 0.375, 0.1875, 0.125, null, texes, 0);
        this.post = this.makePostCube(format, 0.375, 0.0, 0.375, 0.25, 1.0, 0.25, null, texes, 0);
    }

    @Override
    @Nonnull
    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        this.getFaceQuads(quads, side, state);
        return quads;
    }

    private void getFaceQuads(@Nonnull List<BakedQuad> quads, @Nullable Direction side, @Nullable BlockState state) {
        if (state == null) {
            this.post_left.addToList(quads, side);
            this.post_right.addToList(quads, side);
            this.west.addToList(quads, side);
            this.west_top.addToList(quads, side);
        } else {
            boolean cnorth = (Boolean)state.func_177229_b((IProperty)FenceBlock.field_196409_a);
            boolean csouth = (Boolean)state.func_177229_b((IProperty)FenceBlock.field_196413_c);
            boolean cwest = (Boolean)state.func_177229_b((IProperty)FenceBlock.field_196414_y);
            boolean ceast = (Boolean)state.func_177229_b((IProperty)FenceBlock.field_196411_b);
            this.post.addToList(quads, side);
            if (cnorth) {
                this.north.addToList(quads, side);
                this.north_top.addToList(quads, side);
            }
            if (csouth) {
                this.south.addToList(quads, side);
                this.south_top.addToList(quads, side);
            }
            if (cwest) {
                this.west.addToList(quads, side);
                this.west_top.addToList(quads, side);
            }
            if (ceast) {
                this.east.addToList(quads, side);
                this.east_top.addToList(quads, side);
            }
        }
    }

    private Cube makePostCube(VertexFormat format, double x, double y, double z, double w, double h, double l, Vec4f[] uv, TextureAtlasSprite[] sprites, int tintIndex) {
        uv = new Vec4f[]{new Vec4f((float)z * 16.0f, (float)(-y) * 16.0f + (16.0f - (float)h * 16.0f), (float)l * 16.0f, (float)h * 16.0f), new Vec4f(16.0f - (float)l * 16.0f - (float)z * 16.0f, (float)(-y) * 16.0f + (16.0f - (float)h * 16.0f), (float)l * 16.0f, (float)h * 16.0f), new Vec4f(5.0f, 5.0f, 6.0f, 6.0f), new Vec4f(5.0f, 5.0f, 6.0f, 6.0f), new Vec4f(16.0f - (float)w * 16.0f - (float)x * 16.0f, (float)(-y) * 16.0f + (16.0f - (float)h * 16.0f), (float)w * 16.0f, (float)h * 16.0f), new Vec4f((float)x * 16.0f, (float)(-y) * 16.0f + (16.0f - (float)h * 16.0f), (float)w * 16.0f, (float)h * 16.0f)};
        return ModelUtil.makeCube(format, x, y, z, w, h, l, uv, sprites, tintIndex);
    }
}

