/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.model.block;

import epicsquid.mysticallib.model.CustomModelBase;
import epicsquid.mysticallib.model.ModelUtil;
import epicsquid.mysticallib.model.block.BakedModelBlock;
import epicsquid.mysticallib.model.parts.Cube;
import epicsquid.mysticallib.struct.Vec4f;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.StairsBlock;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;

public class BakedModelStairs
extends BakedModelBlock {
    private Cube cube_down;
    private Cube cube_up;
    private Cube q_down_nx;
    private Cube q_down_px;
    private Cube q_down_nz;
    private Cube q_down_pz;
    private Cube q_up_nx;
    private Cube q_up_px;
    private Cube q_up_nz;
    private Cube q_up_pz;
    private Cube e_down_nxnz;
    private Cube e_down_pxnz;
    private Cube e_down_pxpz;
    private Cube e_down_nxpz;
    private Cube e_up_nxnz;
    private Cube e_up_pxnz;
    private Cube e_up_pxpz;
    private Cube e_up_nxpz;
    public static Vec4f FULL_FACE_UV = new Vec4f(0.0f, 0.0f, 16.0f, 16.0f);
    public static Vec4f BOTTOM_SIDE_UV = new Vec4f(0.0f, 8.0f, 16.0f, 8.0f);
    public static Vec4f TOP_SIDE_UV = new Vec4f(0.0f, 0.0f, 16.0f, 8.0f);
    public static Vec4f[] bottomUV = new Vec4f[]{BOTTOM_SIDE_UV, BOTTOM_SIDE_UV, FULL_FACE_UV, FULL_FACE_UV, BOTTOM_SIDE_UV, BOTTOM_SIDE_UV};
    public static Vec4f[] topUV = new Vec4f[]{TOP_SIDE_UV, TOP_SIDE_UV, FULL_FACE_UV, FULL_FACE_UV, TOP_SIDE_UV, TOP_SIDE_UV};

    public BakedModelStairs(@Nonnull IModelState state, @Nonnull VertexFormat format, @Nonnull Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, @Nonnull CustomModelBase model) {
        super(format, bakedTextureGetter, model);
        TextureAtlasSprite[] texes = new TextureAtlasSprite[]{this.texwest, this.texeast, this.texdown, this.texup, this.texnorth, this.texsouth};
        this.cube_down = ModelUtil.makeCube(format, 0.0, 0.0, 0.0, 1.0, 0.5, 1.0, null, texes, 0).setNoCull(Direction.UP);
        this.cube_up = ModelUtil.makeCube(format, 0.0, 0.5, 0.0, 1.0, 0.5, 1.0, null, texes, 0).setNoCull(Direction.DOWN);
        this.q_up_nx = ModelUtil.makeCube(format, 0.0, 0.5, 0.0, 0.5, 0.5, 1.0, null, texes, 0).setNoCull(Direction.EAST);
        this.q_up_px = ModelUtil.makeCube(format, 0.5, 0.5, 0.0, 0.5, 0.5, 1.0, null, texes, 0).setNoCull(Direction.WEST);
        this.q_up_nz = ModelUtil.makeCube(format, 0.0, 0.5, 0.0, 1.0, 0.5, 0.5, null, texes, 0).setNoCull(Direction.SOUTH);
        this.q_up_pz = ModelUtil.makeCube(format, 0.0, 0.5, 0.5, 1.0, 0.5, 0.5, null, texes, 0).setNoCull(Direction.NORTH);
        this.q_down_nx = ModelUtil.makeCube(format, 0.0, 0.0, 0.0, 0.5, 0.5, 1.0, null, texes, 0).setNoCull(Direction.EAST);
        this.q_down_px = ModelUtil.makeCube(format, 0.5, 0.0, 0.0, 0.5, 0.5, 1.0, null, texes, 0).setNoCull(Direction.WEST);
        this.q_down_nz = ModelUtil.makeCube(format, 0.0, 0.0, 0.0, 1.0, 0.5, 0.5, null, texes, 0).setNoCull(Direction.SOUTH);
        this.q_down_pz = ModelUtil.makeCube(format, 0.0, 0.0, 0.5, 1.0, 0.5, 0.5, null, texes, 0).setNoCull(Direction.NORTH);
        this.e_up_nxnz = ModelUtil.makeCube(format, 0.0, 0.5, 0.0, 0.5, 0.5, 0.5, null, texes, 0).setNoCull(Direction.EAST).setNoCull(Direction.SOUTH);
        this.e_up_pxnz = ModelUtil.makeCube(format, 0.5, 0.5, 0.0, 0.5, 0.5, 0.5, null, texes, 0).setNoCull(Direction.WEST).setNoCull(Direction.SOUTH);
        this.e_up_pxpz = ModelUtil.makeCube(format, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, null, texes, 0).setNoCull(Direction.WEST).setNoCull(Direction.NORTH);
        this.e_up_nxpz = ModelUtil.makeCube(format, 0.0, 0.5, 0.5, 0.5, 0.5, 0.5, null, texes, 0).setNoCull(Direction.EAST).setNoCull(Direction.NORTH);
        this.e_down_nxnz = ModelUtil.makeCube(format, 0.0, 0.0, 0.0, 0.5, 0.5, 0.5, null, texes, 0).setNoCull(Direction.EAST).setNoCull(Direction.SOUTH);
        this.e_down_pxnz = ModelUtil.makeCube(format, 0.5, 0.0, 0.0, 0.5, 0.5, 0.5, null, texes, 0).setNoCull(Direction.WEST).setNoCull(Direction.SOUTH);
        this.e_down_pxpz = ModelUtil.makeCube(format, 0.5, 0.0, 0.5, 0.5, 0.5, 0.5, null, texes, 0).setNoCull(Direction.WEST).setNoCull(Direction.NORTH);
        this.e_down_nxpz = ModelUtil.makeCube(format, 0.0, 0.0, 0.5, 0.5, 0.5, 0.5, null, texes, 0).setNoCull(Direction.EAST).setNoCull(Direction.NORTH);
    }

    @Override
    @Nonnull
    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        this.getFaceQuads(quads, side, state);
        return quads;
    }

    private void getFaceQuads(@Nonnull List<BakedQuad> quads, @Nullable Direction side, @Nullable BlockState state) {
        if (state == null) {
            this.cube_down.addToList(quads, side);
            this.q_up_pz.addToList(quads, side);
        } else {
            Half half = (Half)state.func_177229_b((IProperty)StairsBlock.field_176308_b);
            StairsShape shape = (StairsShape)state.func_177229_b((IProperty)StairsBlock.field_176310_M);
            Direction face = (Direction)state.func_177229_b((IProperty)StairsBlock.field_176309_a);
            if (half == Half.BOTTOM) {
                this.cube_down.addToList(quads, side);
                if (shape == StairsShape.STRAIGHT) {
                    switch (face) {
                        case DOWN: {
                            break;
                        }
                        case EAST: {
                            this.q_up_px.addToList(quads, side);
                            break;
                        }
                        case NORTH: {
                            this.q_up_nz.addToList(quads, side);
                            break;
                        }
                        case SOUTH: {
                            this.q_up_pz.addToList(quads, side);
                            break;
                        }
                        case UP: {
                            break;
                        }
                        case WEST: {
                            this.q_up_nx.addToList(quads, side);
                            break;
                        }
                    }
                }
                if (shape == StairsShape.OUTER_LEFT) {
                    switch (face) {
                        case DOWN: {
                            break;
                        }
                        case EAST: {
                            this.e_up_pxnz.addToList(quads, side);
                            break;
                        }
                        case NORTH: {
                            this.e_up_nxnz.addToList(quads, side);
                            break;
                        }
                        case SOUTH: {
                            this.e_up_pxpz.addToList(quads, side);
                            break;
                        }
                        case UP: {
                            break;
                        }
                        case WEST: {
                            this.e_up_nxpz.addToList(quads, side);
                            break;
                        }
                    }
                }
                if (shape == StairsShape.OUTER_RIGHT) {
                    switch (face) {
                        case DOWN: {
                            break;
                        }
                        case EAST: {
                            this.e_up_pxpz.addToList(quads, side);
                            break;
                        }
                        case NORTH: {
                            this.e_up_pxnz.addToList(quads, side);
                            break;
                        }
                        case SOUTH: {
                            this.e_up_nxpz.addToList(quads, side);
                            break;
                        }
                        case UP: {
                            break;
                        }
                        case WEST: {
                            this.e_up_nxnz.addToList(quads, side);
                            break;
                        }
                    }
                }
                if (shape == StairsShape.INNER_LEFT) {
                    switch (face) {
                        case DOWN: {
                            break;
                        }
                        case EAST: {
                            this.q_up_px.addToList(quads, side);
                            this.e_up_nxnz.addToList(quads, side);
                            break;
                        }
                        case NORTH: {
                            this.q_up_nz.addToList(quads, side);
                            this.e_up_nxpz.addToList(quads, side);
                            break;
                        }
                        case SOUTH: {
                            this.q_up_pz.addToList(quads, side);
                            this.e_up_pxnz.addToList(quads, side);
                            break;
                        }
                        case UP: {
                            break;
                        }
                        case WEST: {
                            this.q_up_nx.addToList(quads, side);
                            this.e_up_pxpz.addToList(quads, side);
                            break;
                        }
                    }
                }
                if (shape == StairsShape.INNER_RIGHT) {
                    switch (face) {
                        case DOWN: {
                            break;
                        }
                        case EAST: {
                            this.q_up_px.addToList(quads, side);
                            this.e_up_nxpz.addToList(quads, side);
                            break;
                        }
                        case NORTH: {
                            this.q_up_nz.addToList(quads, side);
                            this.e_up_pxpz.addToList(quads, side);
                            break;
                        }
                        case SOUTH: {
                            this.q_up_pz.addToList(quads, side);
                            this.e_up_nxnz.addToList(quads, side);
                            break;
                        }
                        case UP: {
                            break;
                        }
                        case WEST: {
                            this.q_up_nx.addToList(quads, side);
                            this.e_up_pxnz.addToList(quads, side);
                            break;
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else if (half == Half.TOP) {
                this.cube_up.addToList(quads, side);
                if (shape == StairsShape.STRAIGHT) {
                    switch (face) {
                        case DOWN: {
                            break;
                        }
                        case EAST: {
                            this.q_down_px.addToList(quads, side);
                            break;
                        }
                        case NORTH: {
                            this.q_down_nz.addToList(quads, side);
                            break;
                        }
                        case SOUTH: {
                            this.q_down_pz.addToList(quads, side);
                            break;
                        }
                        case UP: {
                            break;
                        }
                        case WEST: {
                            this.q_down_nx.addToList(quads, side);
                            break;
                        }
                    }
                }
                if (shape == StairsShape.OUTER_LEFT) {
                    switch (face) {
                        case DOWN: {
                            break;
                        }
                        case EAST: {
                            this.e_down_pxnz.addToList(quads, side);
                            break;
                        }
                        case NORTH: {
                            this.e_down_nxnz.addToList(quads, side);
                            break;
                        }
                        case SOUTH: {
                            this.e_down_pxpz.addToList(quads, side);
                            break;
                        }
                        case UP: {
                            break;
                        }
                        case WEST: {
                            this.e_down_nxpz.addToList(quads, side);
                            break;
                        }
                    }
                }
                if (shape == StairsShape.OUTER_RIGHT) {
                    switch (face) {
                        case DOWN: {
                            break;
                        }
                        case EAST: {
                            this.e_down_pxpz.addToList(quads, side);
                            break;
                        }
                        case NORTH: {
                            this.e_down_pxnz.addToList(quads, side);
                            break;
                        }
                        case SOUTH: {
                            this.e_down_nxpz.addToList(quads, side);
                            break;
                        }
                        case UP: {
                            break;
                        }
                        case WEST: {
                            this.e_down_nxnz.addToList(quads, side);
                            break;
                        }
                    }
                }
                if (shape == StairsShape.INNER_LEFT) {
                    switch (face) {
                        case DOWN: {
                            break;
                        }
                        case EAST: {
                            this.q_down_px.addToList(quads, side);
                            this.e_down_nxnz.addToList(quads, side);
                            break;
                        }
                        case NORTH: {
                            this.q_down_nz.addToList(quads, side);
                            this.e_down_nxpz.addToList(quads, side);
                            break;
                        }
                        case SOUTH: {
                            this.q_down_pz.addToList(quads, side);
                            this.e_down_pxnz.addToList(quads, side);
                            break;
                        }
                        case UP: {
                            break;
                        }
                        case WEST: {
                            this.q_down_nx.addToList(quads, side);
                            this.e_down_pxpz.addToList(quads, side);
                            break;
                        }
                    }
                }
                if (shape == StairsShape.INNER_RIGHT) {
                    switch (face) {
                        case DOWN: {
                            break;
                        }
                        case EAST: {
                            this.q_down_px.addToList(quads, side);
                            this.e_down_nxpz.addToList(quads, side);
                            break;
                        }
                        case NORTH: {
                            this.q_down_nz.addToList(quads, side);
                            this.e_down_pxpz.addToList(quads, side);
                            break;
                        }
                        case SOUTH: {
                            this.q_down_pz.addToList(quads, side);
                            this.e_down_nxnz.addToList(quads, side);
                            break;
                        }
                        case UP: {
                            break;
                        }
                        case WEST: {
                            this.q_down_nx.addToList(quads, side);
                            this.e_down_pxnz.addToList(quads, side);
                            break;
                        }
                    }
                }
            }
        }
    }
}

