/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.model.block;

import epicsquid.mysticallib.model.CustomModelBase;
import epicsquid.mysticallib.model.ModelUtil;
import epicsquid.mysticallib.model.block.BakedModelBlock;
import epicsquid.mysticallib.model.parts.Cube;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.WallBlock;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;

public class BakedModelWall
extends BakedModelBlock {
    private Cube post;
    private Cube north;
    private Cube south;
    private Cube west;
    private Cube east;

    public BakedModelWall(@Nonnull IModelState state, @Nonnull VertexFormat format, @Nonnull Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, @Nonnull CustomModelBase model) {
        super(format, bakedTextureGetter, model);
        TextureAtlasSprite[] texes = new TextureAtlasSprite[]{this.texwest, this.texeast, this.texdown, this.texup, this.texnorth, this.texsouth};
        this.post = ModelUtil.makeCube(format, 0.25, 0.0, 0.25, 0.5, 1.0, 0.5, null, texes, -1);
        this.north = ModelUtil.makeCube(format, 0.3125, 0.0, 0.0, 0.375, 0.875, 0.5, null, texes, -1);
        this.south = ModelUtil.makeCube(format, 0.3125, 0.0, 0.5, 0.375, 0.875, 0.5, null, texes, -1);
        this.west = ModelUtil.makeCube(format, 0.0, 0.0, 0.3125, 0.5, 0.875, 0.375, null, texes, -1);
        this.east = ModelUtil.makeCube(format, 0.5, 0.0, 0.3125, 0.5, 0.875, 0.375, null, texes, -1);
    }

    @Override
    @Nonnull
    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        this.getFaceQuads(quads, side, state);
        return quads;
    }

    private void getFaceQuads(@Nonnull List<BakedQuad> quads, @Nullable Direction side, @Nullable BlockState state) {
        if (state == null) {
            this.post.addToList(quads, side);
            this.west.addToList(quads, side);
            this.east.addToList(quads, side);
        } else {
            boolean up = (Boolean)state.func_177229_b((IProperty)WallBlock.field_176256_a);
            boolean cnorth = (Boolean)state.func_177229_b((IProperty)WallBlock.field_196409_a);
            boolean csouth = (Boolean)state.func_177229_b((IProperty)WallBlock.field_196413_c);
            boolean cwest = (Boolean)state.func_177229_b((IProperty)WallBlock.field_196414_y);
            boolean ceast = (Boolean)state.func_177229_b((IProperty)WallBlock.field_196411_b);
            if (up) {
                this.post.addToList(quads, side);
            }
            if (cnorth) {
                this.north.addToList(quads, side);
            }
            if (csouth) {
                this.south.addToList(quads, side);
            }
            if (cwest) {
                this.west.addToList(quads, side);
            }
            if (ceast) {
                this.east.addToList(quads, side);
            }
        }
    }
}

