/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.model.item;

import com.google.common.collect.ImmutableList;
import epicsquid.mysticallib.model.CustomModelItem;
import epicsquid.mysticallib.model.DefaultTransformations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class BakedModelItem
implements IBakedModel {
    protected Function<ResourceLocation, TextureAtlasSprite> getter;
    protected VertexFormat format;
    protected ImmutableList.Builder<BakedQuad> quads = ImmutableList.builder();
    protected List<TextureAtlasSprite> layers = new ArrayList<TextureAtlasSprite>();
    protected CustomModelItem model;
    @Nonnull
    protected List<BakedQuad> layerQuads = new ArrayList<BakedQuad>();
    protected TextureAtlasSprite particle = null;

    public BakedModelItem(@Nonnull VertexFormat format, @Nonnull Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, @Nonnull CustomModelItem model) {
        this.getter = bakedTextureGetter;
        this.format = format;
        int i = 0;
        this.model = model;
        while (model.textures.containsKey("layer" + i)) {
            this.layers.add(this.getter.apply((ResourceLocation)model.textures.get("layer" + i)));
            this.layerQuads.addAll((Collection<BakedQuad>)ItemLayerModel.getQuadsForSprite((int)i, (TextureAtlasSprite)this.layers.get(i), (VertexFormat)format, Optional.empty()));
            ++i;
        }
        if (model.textures.containsKey("particle")) {
            this.particle = this.getter.apply((ResourceLocation)model.textures.get("particle"));
        }
    }

    @Nonnull
    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        return this.layerQuads;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.particle;
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    @Nonnull
    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(@Nonnull ItemCameraTransforms.TransformType type) {
        if (this.model.handheld) {
            if (DefaultTransformations.handheldTransforms.containsKey(type)) {
                DefaultTransformations.handheldTransforms.get(type);
                Matrix4f matrix = TRSRTransformation.getMatrix((Direction)Direction.func_82600_a((int)0));
                return Pair.of((Object)this, (Object)matrix);
            }
        } else if (DefaultTransformations.itemTransforms.containsKey(type)) {
            DefaultTransformations.itemTransforms.get(type);
            Matrix4f matrix = TRSRTransformation.getMatrix((Direction)Direction.func_82600_a((int)0));
            return Pair.of((Object)this, (Object)matrix);
        }
        return ForgeHooksClient.handlePerspective((IBakedModel)this, (ItemCameraTransforms.TransformType)type);
    }
}

