/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.model.parts;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.util.Direction;

public class Cube {
    public Map<Direction, BakedQuad> quads = new EnumMap<Direction, BakedQuad>(Direction.class);
    public List<BakedQuad> unculledQuads = new ArrayList<BakedQuad>();

    public Cube(@Nonnull BakedQuad west, @Nonnull BakedQuad east, @Nonnull BakedQuad down, @Nonnull BakedQuad up, @Nonnull BakedQuad north, @Nonnull BakedQuad south) {
        this.quads.put(Direction.WEST, west);
        this.quads.put(Direction.EAST, east);
        this.quads.put(Direction.DOWN, down);
        this.quads.put(Direction.UP, up);
        this.quads.put(Direction.NORTH, north);
        this.quads.put(Direction.SOUTH, south);
    }

    public void addToList(@Nonnull List<BakedQuad> list, @Nullable Direction face) {
        if (face != null && this.quads.containsKey(face)) {
            list.add(this.quads.get(face));
        } else if (face == null) {
            list.addAll(this.unculledQuads);
        }
    }

    public Cube setNoCull() {
        this.unculledQuads.addAll(this.quads.values());
        this.quads.clear();
        return this;
    }

    public Cube setNoCull(@Nonnull Direction face) {
        BakedQuad quad = this.quads.get(face);
        this.unculledQuads.add(quad);
        this.quads.remove(face);
        return this;
    }
}

