/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import epicsquid.mysticallib.MysticalLib;
import epicsquid.mysticallib.particle.IParticle;
import epicsquid.mysticallib.particle.ParticleRegistry;
import epicsquid.mysticallib.setup.ClientProxy;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ParticleRenderer {
    private CopyOnWriteArrayList<Particle> particles = new CopyOnWriteArrayList();

    public synchronized void updateParticles() {
        ArrayList<Particle> toRemove = new ArrayList<Particle>();
        for (Particle particle : this.particles) {
            boolean doRemove = true;
            if (particle != null && particle instanceof IParticle && ((IParticle)particle).alive()) {
                particle.func_189213_a();
                doRemove = false;
            }
            if (!doRemove) continue;
            toRemove.add(particle);
        }
        if (!toRemove.isEmpty()) {
            this.particles.removeAll(toRemove);
        }
    }

    public synchronized void renderParticles(float partialTicks) {
        ActiveRenderInfo renderInfo = MysticalLib.proxy.getClientActiveRenderInfo();
        PlayerEntity player = MysticalLib.proxy.getClientPlayer();
        if (player != null) {
            int i = 0;
            float f = MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180))) * (float)(1 - i * 2);
            float f1 = MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))) * (float)(1 - i * 2);
            float f2 = -f1 * MathHelper.func_76126_a((float)(player.field_70125_A * ((float)Math.PI / 180))) * (float)(1 - i * 2);
            float f3 = f * MathHelper.func_76126_a((float)(player.field_70125_A * ((float)Math.PI / 180))) * (float)(1 - i * 2);
            float f4 = MathHelper.func_76134_b((float)(player.field_70125_A * ((float)Math.PI / 180)));
            Particle.field_70556_an = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
            Particle.field_70554_ao = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
            Particle.field_70555_ap = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
            GlStateManager.enableAlphaTest();
            GlStateManager.enableBlend();
            GlStateManager.alphaFunc((int)516, (float)0.003921569f);
            GlStateManager.disableCull();
            GlStateManager.depthMask((boolean)false);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder buffer = tess.func_178180_c();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
            for (Particle particle : this.particles) {
                if (!(particle instanceof IParticle) || ((IParticle)particle).isAdditive()) continue;
                particle.func_180434_a(buffer, renderInfo, partialTicks, f, f4, f1, f2, f3);
            }
            tess.func_78381_a();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
            for (Particle particle : this.particles) {
                if (particle == null || !((IParticle)particle).isAdditive()) continue;
                particle.func_180434_a(buffer, renderInfo, partialTicks, f, f4, f1, f2, f3);
            }
            tess.func_78381_a();
            GlStateManager.disableDepthTest();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
            for (Particle particle : this.particles) {
                if (!(particle instanceof IParticle) || ((IParticle)particle).isAdditive() || !((IParticle)particle).renderThroughBlocks()) continue;
                particle.func_180434_a(buffer, renderInfo, partialTicks, f, f4, f1, f2, f3);
            }
            tess.func_78381_a();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
            for (Particle particle : this.particles) {
                if (particle == null || !((IParticle)particle).isAdditive() || !((IParticle)particle).renderThroughBlocks()) continue;
                particle.func_180434_a(buffer, renderInfo, partialTicks, f, f4, f1, f2, f3);
            }
            tess.func_78381_a();
            GlStateManager.enableDepthTest();
            GlStateManager.enableCull();
            GlStateManager.depthMask((boolean)true);
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.disableBlend();
            GlStateManager.alphaFunc((int)516, (float)0.1f);
            GlStateManager.enableAlphaTest();
        }
    }

    public void spawnParticle(World world, String particle, double x, double y, double z, double vx, double vy, double vz, double ... data) {
        if (MysticalLib.proxy instanceof ClientProxy) {
            try {
                this.particles.add((Particle)ParticleRegistry.getParticles().get(particle).newInstance(world, x, y, z, vx, vy, vz, data));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }
}

