/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.registry;

import epicsquid.mysticallib.block.BaseDoorBlock;
import epicsquid.mysticallib.block.BaseOreBlock;
import epicsquid.mysticallib.block.BasePressurePlateBlock;
import epicsquid.mysticallib.block.BaseStoneButtonBlock;
import epicsquid.mysticallib.block.BaseTrapDoorBlock;
import epicsquid.mysticallib.block.BaseWeightedPressurePlateBlock;
import epicsquid.mysticallib.block.BaseWoodButtonBlock;
import epicsquid.mysticallib.item.KnifeItem;
import epicsquid.mysticallib.item.SpearItem;
import epicsquid.mysticallib.material.MaterialType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.LogBlock;
import net.minecraft.block.OreBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.StoneButtonBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.WeightedPressurePlateBlock;
import net.minecraft.block.WoodButtonBlock;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.schedule.Schedule;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockNamedItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.stats.StatType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProviderType;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DataSerializerEntry;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class ModRegistry {
    private final DeferredRegister<Block> blockRegistry;
    private final DeferredRegister<Item> itemRegistry;
    private final DeferredRegister<Fluid> fluidRegistry;
    private final DeferredRegister<Biome> biomeRegistry;
    private final DeferredRegister<SoundEvent> soundRegistry;
    private final DeferredRegister<Enchantment> enchantmentRegistry;
    private final DeferredRegister<Potion> potionRegistry;
    private final DeferredRegister<Effect> effectRegistry;
    private final DeferredRegister<EntityType<?>> entityRegistry;
    private final DeferredRegister<TileEntityType<?>> tileEntityRegistry;
    private final DeferredRegister<ContainerType<?>> containerRegistry;
    private final DeferredRegister<IRecipeSerializer<?>> recipeRegistry;
    private final DeferredRegister<StatType<?>> statRegistry;
    private final DeferredRegister<ParticleType<?>> particleRegistry;
    private final DeferredRegister<PaintingType> paintingRegistry;
    private final DeferredRegister<VillagerProfession> professionRegistry;
    private final DeferredRegister<PointOfInterestType> poiRegistry;
    private final DeferredRegister<MemoryModuleType<?>> memoryRegistry;
    private final DeferredRegister<SensorType<?>> sensorRegistry;
    private final DeferredRegister<Schedule> scheduleRegistry;
    private final DeferredRegister<Activity> activityRegistry;
    private final DeferredRegister<WorldCarver<?>> carverRegistry;
    private final DeferredRegister<SurfaceBuilder<?>> surfaceRegistry;
    private final DeferredRegister<Feature<?>> featureRegistry;
    private final DeferredRegister<Placement<?>> placementRegistry;
    private final DeferredRegister<BiomeProviderType<?, ?>> biomeProviderRegistry;
    private final DeferredRegister<ChunkGeneratorType<?, ?>> chunkGeneratorRegistry;
    private final DeferredRegister<ChunkStatus> chunkStatusRegistry;
    private final DeferredRegister<ModDimension> dimensionRegistry;
    private final DeferredRegister<DataSerializerEntry> dataSerializerRegistry;
    private final String modId;
    private final Set<DeferredRegister<?>> activeRegistries = new HashSet();

    public ModRegistry(String modId) {
        this.modId = modId;
        this.blockRegistry = new DeferredRegister(ForgeRegistries.BLOCKS, modId);
        this.itemRegistry = new DeferredRegister(ForgeRegistries.ITEMS, modId);
        this.fluidRegistry = new DeferredRegister(ForgeRegistries.FLUIDS, modId);
        this.biomeRegistry = new DeferredRegister(ForgeRegistries.BIOMES, modId);
        this.soundRegistry = new DeferredRegister(ForgeRegistries.SOUND_EVENTS, modId);
        this.enchantmentRegistry = new DeferredRegister(ForgeRegistries.ENCHANTMENTS, modId);
        this.potionRegistry = new DeferredRegister(ForgeRegistries.POTION_TYPES, modId);
        this.effectRegistry = new DeferredRegister(ForgeRegistries.POTIONS, modId);
        this.entityRegistry = new DeferredRegister(ForgeRegistries.ENTITIES, modId);
        this.tileEntityRegistry = new DeferredRegister(ForgeRegistries.TILE_ENTITIES, modId);
        this.containerRegistry = new DeferredRegister(ForgeRegistries.CONTAINERS, modId);
        this.recipeRegistry = new DeferredRegister(ForgeRegistries.RECIPE_SERIALIZERS, modId);
        this.statRegistry = new DeferredRegister(ForgeRegistries.STAT_TYPES, modId);
        this.particleRegistry = new DeferredRegister(ForgeRegistries.PARTICLE_TYPES, modId);
        this.paintingRegistry = new DeferredRegister(ForgeRegistries.PAINTING_TYPES, modId);
        this.professionRegistry = new DeferredRegister(ForgeRegistries.PROFESSIONS, modId);
        this.poiRegistry = new DeferredRegister(ForgeRegistries.POI_TYPES, modId);
        this.memoryRegistry = new DeferredRegister(ForgeRegistries.MEMORY_MODULE_TYPES, modId);
        this.sensorRegistry = new DeferredRegister(ForgeRegistries.SENSOR_TYPES, modId);
        this.scheduleRegistry = new DeferredRegister(ForgeRegistries.SCHEDULES, modId);
        this.activityRegistry = new DeferredRegister(ForgeRegistries.ACTIVITIES, modId);
        this.carverRegistry = new DeferredRegister(ForgeRegistries.WORLD_CARVERS, modId);
        this.surfaceRegistry = new DeferredRegister(ForgeRegistries.SURFACE_BUILDERS, modId);
        this.featureRegistry = new DeferredRegister(ForgeRegistries.FEATURES, modId);
        this.placementRegistry = new DeferredRegister(ForgeRegistries.DECORATORS, modId);
        this.biomeProviderRegistry = new DeferredRegister(ForgeRegistries.BIOME_PROVIDER_TYPES, modId);
        this.chunkGeneratorRegistry = new DeferredRegister(ForgeRegistries.CHUNK_GENERATOR_TYPES, modId);
        this.chunkStatusRegistry = new DeferredRegister(ForgeRegistries.CHUNK_STATUS, modId);
        this.dimensionRegistry = new DeferredRegister(ForgeRegistries.MOD_DIMENSIONS, modId);
        this.dataSerializerRegistry = new DeferredRegister(ForgeRegistries.DATA_SERIALIZERS, modId);
    }

    public void registerEventBus(IEventBus bus) {
        this.activeRegistries.forEach(o -> o.register(bus));
    }

    public Collection<RegistryObject<Block>> getBlocks() {
        return this.blockRegistry.getEntries();
    }

    public Collection<RegistryObject<Item>> getItems() {
        return this.itemRegistry.getEntries();
    }

    public <T extends SoundEvent> RegistryObject<T> registerSoundEvent(String name, Supplier<T> supplier) {
        this.activeRegistries.add(this.soundRegistry);
        return this.soundRegistry.register(name, supplier);
    }

    public RegistryObject<SoundEvent> registerSoundEvent(String name) {
        return this.registerSoundEvent(name, this.sound(new ResourceLocation(this.modId, name)));
    }

    public <T extends IRecipeSerializer<?>> RegistryObject<T> registerRecipeSerializer(String name, Supplier<T> supplier) {
        this.activeRegistries.add(this.recipeRegistry);
        return this.recipeRegistry.register(name, supplier);
    }

    public <T extends Item> RegistryObject<T> registerItem(String name, Supplier<T> supplier) {
        this.activeRegistries.add(this.itemRegistry);
        return this.itemRegistry.register(name, supplier);
    }

    public <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> supplier, Supplier<Item.Properties> itemblockProperties) {
        this.activeRegistries.add(this.itemRegistry);
        RegistryObject<T> result = this.registerBlockWithoutItem(name, supplier);
        this.itemRegistry.register(name, this.blockItem(result, itemblockProperties));
        return result;
    }

    public <T extends Block> RegistryObject<T> registerBlockWithoutItem(String name, Supplier<T> supplier) {
        this.activeRegistries.add(this.blockRegistry);
        return this.blockRegistry.register(name, supplier);
    }

    public <T extends TileEntityType<?>> RegistryObject<T> registerTileEntity(String name, Supplier<T> supplier) {
        this.activeRegistries.add(this.tileEntityRegistry);
        return this.tileEntityRegistry.register(name, supplier);
    }

    public <T extends ContainerType<?>> RegistryObject<T> registerContainerType(String name, Supplier<T> supplier) {
        this.activeRegistries.add(this.containerRegistry);
        return this.containerRegistry.register(name, supplier);
    }

    public Supplier<SoundEvent> sound(ResourceLocation name) {
        return () -> new SoundEvent(name);
    }

    public <T extends TileEntity> Supplier<TileEntityType<T>> tile(Supplier<T> creator, Supplier<? extends Block> supplier) {
        return () -> TileEntityType.Builder.func_223042_a((Supplier)creator, (Block[])new Block[]{(Block)supplier.get()}).func_206865_a(null);
    }

    public <T extends TileEntity> Supplier<TileEntityType<T>> tile(Supplier<T> creator, Supplier<? extends Block> ... supplier) {
        return () -> TileEntityType.Builder.func_223042_a((Supplier)creator, (Block[])((Block[])Stream.of(supplier).map(Supplier::get).toArray(Block[]::new))).func_206865_a(null);
    }

    public <T extends Block> Supplier<T> block(Function<Block.Properties, T> creator, Supplier<Block.Properties> properties) {
        return () -> (Block)creator.apply((Block.Properties)properties.get());
    }

    public Supplier<StairsBlock> stair(RegistryObject<? extends Block> source) {
        return this.block(b -> new StairsBlock(source.lazyMap(Block::func_176223_P), b), this.fromBlock((Supplier<? extends Block>)source));
    }

    public Supplier<SlabBlock> slab(Supplier<? extends Block> source) {
        return this.block(SlabBlock::new, this.fromBlock(source));
    }

    public Supplier<FenceBlock> fence(Supplier<? extends Block> source) {
        return this.block(FenceBlock::new, this.fromBlock(source));
    }

    public Supplier<FenceGateBlock> fenceGate(Supplier<? extends Block> source) {
        return this.block(FenceGateBlock::new, this.fromBlock(source));
    }

    public Supplier<WallBlock> wall(Supplier<? extends Block> source) {
        return this.block(WallBlock::new, this.fromBlock(source));
    }

    public Supplier<LogBlock> log(MaterialColor topColor, Supplier<Block.Properties> props) {
        return this.block(b -> new LogBlock(topColor, b), props);
    }

    public Supplier<StoneButtonBlock> stoneButton(Supplier<? extends Block> source) {
        return this.block(BaseStoneButtonBlock::new, this.fromBlock(source));
    }

    public Supplier<WoodButtonBlock> woodButton(Supplier<? extends Block> source) {
        return this.block(BaseWoodButtonBlock::new, this.fromBlock(source));
    }

    public Supplier<WeightedPressurePlateBlock> weightedPressurePlate(Supplier<? extends Block> source, int maxWeight) {
        return this.block(b -> new BaseWeightedPressurePlateBlock(maxWeight, (Block.Properties)b), this.fromBlock(source));
    }

    public Supplier<PressurePlateBlock> pressurePlate(Supplier<? extends Block> source, PressurePlateBlock.Sensitivity sensitivity) {
        return this.block(b -> new BasePressurePlateBlock(sensitivity, (Block.Properties)b), this.fromBlock(source));
    }

    public Supplier<TrapDoorBlock> trapDoor(Supplier<? extends Block> source) {
        return this.block(BaseTrapDoorBlock::new, this.fromBlock(source));
    }

    public Supplier<DoorBlock> door(Supplier<? extends Block> source) {
        return this.block(BaseDoorBlock::new, this.fromBlock(source));
    }

    private ComposingSupplier<Block.Properties> fromBlock(Supplier<? extends Block> source) {
        return () -> {
            Objects.requireNonNull(source.get(), "Registered block is required");
            return Block.Properties.func_200950_a((Block)((Block)source.get()));
        };
    }

    public <T extends Block> Supplier<BlockItem> blockItem(RegistryObject<T> block, Supplier<Item.Properties> properties) {
        return () -> new BlockItem((Block)block.get(), (Item.Properties)properties.get());
    }

    public <T extends Block> Supplier<BlockNamedItem> blockNamedItem(Supplier<RegistryObject<T>> block, Supplier<Item.Properties> properties) {
        return () -> new BlockNamedItem((Block)((RegistryObject)block.get()).get(), (Item.Properties)properties.get());
    }

    public Supplier<BaseOreBlock> ore(OreBuilder<BaseOreBlock> creator, MaterialType material) {
        return () -> (BaseOreBlock)((Object)((Object)creator.apply(material.getOreBlockProperties().get(), material.getMinXP(), material.getMaxXP())));
    }

    public <T extends Item> Supplier<T> item(Function<Item.Properties, T> creator, Supplier<Item.Properties> properties) {
        return () -> (Item)creator.apply((Item.Properties)properties.get());
    }

    public Supplier<DyeItem> dyeItem(DyeColor dye, Supplier<Item.Properties> properties) {
        return () -> new DyeItem(dye, (Item.Properties)properties.get());
    }

    public <T extends Entity> Supplier<EntityType<T>> entity(String name, Supplier<EntityType.Builder<T>> builder) {
        return () -> ((EntityType.Builder)builder.get()).func_206830_a(name);
    }

    public <T extends Item> Supplier<T> tool(ToolBuilder<T> builder, MaterialType.Type Q, MaterialType material, Supplier<Item.Properties> properties) {
        return () -> builder.apply(material, material.getDamage(Q), material.getSpeed(Q), (Item.Properties)properties.get());
    }

    public Supplier<SwordItem> sword(ToolBuilder<SwordItem> builder, MaterialType material, Supplier<Item.Properties> properties) {
        return this.tool(builder, MaterialType.Type.SWORD, material, properties);
    }

    public Supplier<SpearItem> spear(ToolBuilder<SpearItem> builder, MaterialType material, Supplier<Item.Properties> properties) {
        return this.tool(builder, MaterialType.Type.SPEAR, material, properties);
    }

    public Supplier<PickaxeItem> pickaxe(ToolBuilder<PickaxeItem> builder, MaterialType material, Supplier<Item.Properties> properties) {
        return this.tool(builder, MaterialType.Type.PICKAXE, material, properties);
    }

    public Supplier<AxeItem> axe(ToolBuilder<AxeItem> builder, MaterialType material, Supplier<Item.Properties> properties) {
        return this.tool(builder, MaterialType.Type.AXE, material, properties);
    }

    public Supplier<ShovelItem> shovel(ToolBuilder<ShovelItem> builder, MaterialType material, Supplier<Item.Properties> properties) {
        return this.tool(builder, MaterialType.Type.SHOVEL, material, properties);
    }

    public Supplier<KnifeItem> knife(ToolBuilder<KnifeItem> builder, MaterialType material, Supplier<Item.Properties> properties) {
        return this.tool(builder, MaterialType.Type.KNIFE, material, properties);
    }

    public Supplier<HoeItem> hoe(HoeBuilder<HoeItem> builder, MaterialType material, Supplier<Item.Properties> properties) {
        return () -> (HoeItem)builder.apply(material, material.getSpeed(MaterialType.Type.HOE), (Item.Properties)properties.get());
    }

    public Supplier<ArmorItem> armor(ArmorBuilder<ArmorItem> builder, MaterialType material, EquipmentSlotType slot, Supplier<Item.Properties> properties) {
        return () -> (ArmorItem)builder.apply(material, slot, (Item.Properties)properties.get());
    }

    @FunctionalInterface
    public static interface OreBuilder<V extends OreBlock> {
        public V apply(Block.Properties var1, int var2, int var3);
    }

    @FunctionalInterface
    public static interface ArmorBuilder<V extends Item> {
        public V apply(IArmorMaterial var1, EquipmentSlotType var2, Item.Properties var3);
    }

    @FunctionalInterface
    public static interface HoeBuilder<V extends Item> {
        public V apply(IItemTier var1, float var2, Item.Properties var3);
    }

    @FunctionalInterface
    public static interface ToolBuilder<V extends Item> {
        public V apply(IItemTier var1, int var2, float var3, Item.Properties var4);
    }

    static interface ComposingSupplier<T>
    extends Supplier<T> {
        default public <R> ComposingSupplier<R> then(Function<T, R> func) {
            return () -> func.apply(this.get());
        }
    }
}

