/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.tile;

import epicsquid.mysticallib.tile.ITile;
import epicsquid.mysticallib.util.Util;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class TileBase
extends TileEntity
implements ITile {
    public TileBase(TileEntityType<?> type) {
        super(type);
    }

    @Override
    public boolean activate(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull Direction side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable PlayerEntity player) {
        this.invalidateCaps();
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Nonnull
    public static String getTileName(@Nonnull Class<? extends TileEntity> teClass) {
        return Util.getLowercaseClassName(teClass);
    }

    public void updatePacketViaState() {
        BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 8);
    }

    protected boolean dropItemInInventory(ItemStackHandler inventory, int slot) {
        if (!inventory.getStackInSlot(slot).func_190926_b()) {
            ItemStack extracted = inventory.extractItem(slot, 1, false);
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_217376_c((Entity)new ItemEntity(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, extracted));
            }
            this.func_70296_d();
            this.updatePacketViaState();
            return true;
        }
        return false;
    }
}

