/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.world;

import epicsquid.mysticallib.world.IGeneratable;
import epicsquid.mysticallib.world.StructureRegistry;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GenerationNode {
    private String structure = "";
    private Rotation rotation = Rotation.NONE;
    private Mirror mirror = Mirror.NONE;
    public BlockPos pos = new BlockPos(-1, -1, -1);
    private boolean replaceWithAir = false;
    boolean isAlive = true;
    boolean force = false;

    public GenerationNode(@Nonnull CompoundNBT tag) {
        this.read(tag);
    }

    public GenerationNode(@Nonnull BlockPos pos, @Nonnull String structure, @Nonnull Rotation rotation, @Nonnull Mirror mirror, boolean replaceWithAir, boolean force) {
        this.pos = pos;
        this.structure = structure;
        this.rotation = rotation;
        this.mirror = mirror;
        this.replaceWithAir = replaceWithAir;
        this.force = force;
    }

    public void update(@Nonnull World world) {
        if (this.structure.length() > 0) {
            IGeneratable data = StructureRegistry.structures.get(this.structure);
            if (data != null) {
                data.calcDimensions();
                if (world.func_175707_a(new BlockPos(this.pos.func_177958_n() - 8, this.pos.func_177956_o(), this.pos.func_177952_p() - 8), new BlockPos(this.pos.func_177958_n() + data.getWidth() + 8, this.pos.func_177956_o(), this.pos.func_177952_p() + data.getLength() + 8))) {
                    data.generateIn(world, this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p(), this.rotation, this.mirror, this.replaceWithAir, this.force);
                    this.isAlive = false;
                }
            } else {
                this.isAlive = false;
            }
        }
    }

    protected void read(@Nonnull CompoundNBT compound) {
        this.structure = compound.func_74779_i("structure");
        this.rotation = Rotation.values()[compound.func_74762_e("rotation")];
        this.mirror = Mirror.values()[compound.func_74762_e("mirror")];
        this.replaceWithAir = compound.func_74767_n("replaceWithAir");
        this.pos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("pos"));
    }

    @Nonnull
    public CompoundNBT write() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.pos));
        compound.func_74778_a("structure", this.structure);
        compound.func_74768_a("rotation", this.rotation.ordinal());
        compound.func_74768_a("mirror", this.mirror.ordinal());
        compound.func_74757_a("replaceWithAir", this.replaceWithAir);
        return compound;
    }
}

