/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.world;

import epicsquid.mysticallib.world.IGeneratable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class StructureData
implements IGeneratable {
    public Map<Vec3i, String> data = new HashMap<Vec3i, String>();
    public Map<String, BlockState> blocks = new HashMap<String, BlockState>();
    private int width = 0;
    private int height = 0;
    private int length = 0;

    public void addBlock(@Nonnull String string, @Nonnull BlockState state) {
        this.blocks.put(string, state);
    }

    public void addLayer(@Nonnull String[] layer, int y) {
        for (int i = 0; i < layer.length; ++i) {
            for (int j = 0; j < layer[i].length(); ++j) {
                this.data.put(new Vec3i(i, y, j), layer[i].substring(j, j + 1));
            }
        }
    }

    @Override
    public void calcDimensions() {
        int minX = 0;
        int minY = 0;
        int minZ = 0;
        int maxX = 0;
        int maxY = 0;
        int maxZ = 0;
        for (Vec3i v : this.data.keySet()) {
            if (v.func_177958_n() < minX) {
                minX = v.func_177958_n();
            }
            if (v.func_177956_o() < minY) {
                minY = v.func_177956_o();
            }
            if (v.func_177952_p() < minZ) {
                minZ = v.func_177952_p();
            }
            if (v.func_177958_n() > maxX) {
                maxX = v.func_177958_n();
            }
            if (v.func_177956_o() > maxY) {
                maxY = v.func_177956_o();
            }
            if (v.func_177956_o() <= maxZ) continue;
            maxZ = v.func_177952_p();
        }
        this.width = maxX - minX;
        this.height = maxY - minY;
        this.length = maxZ - minZ;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void generateIn(@Nonnull World world, int x, int y, int z, @Nonnull Rotation rotation, @Nonnull Mirror doMirror, boolean replaceWithAir, boolean force) {
        this.calcDimensions();
        for (Map.Entry<Vec3i, String> e : this.data.entrySet()) {
            Vec3i v = e.getKey();
            String b = e.getValue();
            if (rotation == Rotation.CLOCKWISE_180) {
                this.placeBlock(world, new BlockPos(x + v.func_177958_n(), y + v.func_177956_o(), z - v.func_177952_p() + this.length), this.blocks.get(b), rotation, doMirror, replaceWithAir, force);
            }
            if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                this.placeBlock(world, new BlockPos(x + v.func_177952_p(), y + v.func_177956_o(), z + v.func_177958_n()), this.blocks.get(b), rotation, doMirror, replaceWithAir, force);
            }
            if (rotation == Rotation.NONE) {
                this.placeBlock(world, new BlockPos(x - v.func_177958_n() + this.width, y + v.func_177956_o(), z + v.func_177952_p()), this.blocks.get(b), rotation, doMirror, replaceWithAir, force);
            }
            if (rotation != Rotation.CLOCKWISE_90) continue;
            this.placeBlock(world, new BlockPos(x - v.func_177952_p() + this.length, y + v.func_177956_o(), z - v.func_177958_n() + this.width), this.blocks.get(b), rotation, doMirror, replaceWithAir, force);
        }
    }

    private void placeBlock(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Rotation rotation, @Nonnull Mirror mirror, boolean replaceWithAir, boolean force) {
        this.placeBlock(world, pos, state, rotation, mirror, replaceWithAir, force, x -> true);
    }

    private void placeBlock(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Rotation rotation, @Nonnull Mirror mirror, boolean replaceWithAir, boolean force, Predicate<BlockState> replaceable) {
        BlockState at = world.func_180495_p(pos);
        if ((world.func_175623_d(pos) || at.func_177230_c().isReplaceableOreGen(state, (IWorldReader)world, pos, replaceable) || force) && (state.func_177230_c() != Blocks.field_150350_a || state.func_177230_c() == Blocks.field_150350_a && replaceWithAir)) {
            world.func_175656_a(pos, state.func_185907_a(rotation).func_185902_a(mirror));
        }
    }
}

