/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.traverse;

import epicsquid.mysticallib.block.BaseDoorBlock;
import epicsquid.mysticallib.block.BasePressurePlateBlock;
import epicsquid.mysticallib.block.BaseSaplingBlock;
import epicsquid.mysticallib.block.BaseTrapDoorBlock;
import epicsquid.mysticallib.block.BaseWoodButtonBlock;
import epicsquid.mysticallib.world.BaseTree;
import epicsquid.traverse.Traverse;
import epicsquid.traverse.biome.AridHighlandsBiome;
import epicsquid.traverse.biome.AutumnalWoodedHillsBiome;
import epicsquid.traverse.biome.AutumnalWoodsBiome;
import epicsquid.traverse.biome.ConiferousForestBiome;
import epicsquid.traverse.biome.ConiferousWoodedHillsBiome;
import epicsquid.traverse.biome.DesertShrublandBiome;
import epicsquid.traverse.biome.HighConiferousForestBiome;
import epicsquid.traverse.biome.LushSwampBiome;
import epicsquid.traverse.biome.MeadowBiome;
import epicsquid.traverse.biome.MiniJungleBiome;
import epicsquid.traverse.biome.PlainsPlateauBiome;
import epicsquid.traverse.biome.RockyEdgeBiome;
import epicsquid.traverse.biome.RollingHillsBiome;
import epicsquid.traverse.biome.SnowyConiferousForestBiome;
import epicsquid.traverse.biome.SnowyConiferousWoodedHillsBiome;
import epicsquid.traverse.biome.SnowyHighConiferousForestBiome;
import epicsquid.traverse.biome.WoodedPlateauBiome;
import epicsquid.traverse.blocks.ModBlocks;
import epicsquid.traverse.config.ConfigManager;
import epicsquid.traverse.world.FirTree;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.LogBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.trees.Tree;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="traverse", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistryManager {
    private static final List<Block> BLOCKS = new ArrayList<Block>();
    public static final BaseTree RED_AUTUMNAL_TREE = new BaseTree(4, () -> Blocks.field_196623_P, () -> ModBlocks.RED_AUTUMNAL_LEAVES);
    public static final BaseTree BROWN_AUTUMNAL_TREE = new BaseTree(5, () -> Blocks.field_196617_K, () -> ModBlocks.BROWN_AUTUMNAL_LEAVES);
    public static final BaseTree ORANGE_AUTUMNAL_TREE = new BaseTree(4, () -> Blocks.field_196617_K, () -> ModBlocks.ORANGE_AUTUMNAL_LEAVES);
    public static final BaseTree YELLOW_AUTUMNAL_TREE = new BaseTree(6, () -> Blocks.field_196619_M, () -> ModBlocks.YELLOW_AUTUMNAL_LEAVES);
    public static final FirTree FIR_TREE = new FirTree();

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        BLOCKS.forEach(block -> registry.register(new BlockItem(block, new Item.Properties().func_200916_a(Traverse.ITEM_GROUP)).setRegistryName(block.getRegistryName())));
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        Block.Properties saplingProps = Block.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200944_c().func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c);
        BLOCKS.add(ModBlocks.RED_AUTUMNAL_LEAVES);
        BLOCKS.add((Block)new BaseSaplingBlock((Tree)RED_AUTUMNAL_TREE, saplingProps).setRegistryName("traverse", "red_autumnal_sapling"));
        BLOCKS.add(ModBlocks.BROWN_AUTUMNAL_LEAVES);
        BLOCKS.add((Block)new BaseSaplingBlock((Tree)BROWN_AUTUMNAL_TREE, saplingProps).setRegistryName("traverse", "brown_autumnal_sapling"));
        BLOCKS.add(ModBlocks.ORANGE_AUTUMNAL_LEAVES);
        BLOCKS.add((Block)new BaseSaplingBlock((Tree)ORANGE_AUTUMNAL_TREE, saplingProps).setRegistryName("traverse", "orange_autumnal_sapling"));
        BLOCKS.add(ModBlocks.YELLOW_AUTUMNAL_LEAVES);
        BLOCKS.add((Block)new BaseSaplingBlock((Tree)YELLOW_AUTUMNAL_TREE, saplingProps).setRegistryName("traverse", "yellow_autumnal_sapling"));
        Block.Properties firWoodProps = Block.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151663_o).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a);
        Block.Properties firProps = Block.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151663_o).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a);
        Block.Properties firPropsPassable = Block.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151663_o).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a).func_200942_a();
        Block firPlanks = (Block)new Block(firProps).setRegistryName("traverse", "fir_planks");
        BLOCKS.add(firPlanks);
        BLOCKS.add(ModBlocks.FIR_LEAVES);
        BLOCKS.add((Block)new BaseSaplingBlock((Tree)FIR_TREE, saplingProps).setRegistryName("traverse", "fir_sapling"));
        BLOCKS.add(ModBlocks.FIR_LOG);
        BLOCKS.add((Block)new LogBlock(MaterialColor.field_151663_o, firWoodProps).setRegistryName("traverse", "stripped_fir_log"));
        BLOCKS.add((Block)new RotatedPillarBlock(firWoodProps).setRegistryName("traverse", "stripped_fir_wood"));
        BLOCKS.add((Block)new RotatedPillarBlock(firWoodProps).setRegistryName("traverse", "fir_wood"));
        BLOCKS.add((Block)new SlabBlock(firProps).setRegistryName("traverse", "fir_slab"));
        BLOCKS.add((Block)new BasePressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, firPropsPassable).setRegistryName("traverse", "fir_pressure_plate"));
        BLOCKS.add((Block)new FenceBlock(firProps).setRegistryName("traverse", "fir_fence"));
        BLOCKS.add((Block)new FenceGateBlock(firProps).setRegistryName("traverse", "fir_fence_gate"));
        BLOCKS.add((Block)new BaseTrapDoorBlock(firProps).setRegistryName("traverse", "fir_trapdoor"));
        BLOCKS.add((Block)new StairsBlock(() -> ((Block)firPlanks).func_176223_P(), firProps).setRegistryName("traverse", "fir_stairs"));
        BLOCKS.add((Block)new BaseWoodButtonBlock(firProps).setRegistryName("traverse", "fir_button"));
        BLOCKS.add((Block)new BaseDoorBlock(firProps).setRegistryName("traverse", "fir_door"));
        BLOCKS.forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
    }

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        IForgeRegistry registry = event.getRegistry();
        RegistryManager.registerBiome((IForgeRegistry<Biome>)registry, new AridHighlandsBiome(), "arid_highlands", ConfigManager.ARID_HIGHLANDS.getWeight(), false, BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS);
        RegistryManager.registerBiome((IForgeRegistry<Biome>)registry, new AutumnalWoodedHillsBiome(), "autumnal_wooded_hills", ConfigManager.AUTUMNAL_WOODED_HILLS.getWeight(), true, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS);
        RegistryManager.registerBiome((IForgeRegistry<Biome>)registry, new AutumnalWoodsBiome(), "autumnal_woods", ConfigManager.AUTUMNAL_WOODS.getWeight(), true, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.FOREST);
        RegistryManager.registerBiome((IForgeRegistry<Biome>)registry, new ConiferousForestBiome(), "coniferous_forest", ConfigManager.CONIFEROUS_FOREST.getWeight(), true, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS);
        RegistryManager.registerBiome((IForgeRegistry<Biome>)registry, new ConiferousWoodedHillsBiome(), "coniferous_woodland_hills_biome", ConfigManager.CONIFEROUS_WOODLAND_HILLS.getWeight(), false, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.CONIFEROUS);
        RegistryManager.registerBiome((IForgeRegistry<Biome>)registry, new DesertShrublandBiome(), "desert_shrubland", ConfigManager.DESERT_SHRUBLAND.getWeight(), false, BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.DEAD);
        RegistryManager.registerBiome((IForgeRegistry<Biome>)registry, new HighConiferousForestBiome(), "high_coniferous_forest", ConfigManager.HIGH_CONIFEROUS_FOREST.getWeight(), false, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.COLD);
        RegistryManager.registerBiome((IForgeRegistry<Biome>)registry, new LushSwampBiome(), "lush_swamp", ConfigManager.LUSH_SWAMP.getWeight(), false, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.SWAMP);
        RegistryManager.registerBiome((IForgeRegistry<Biome>)registry, new MeadowBiome(), "meadow", ConfigManager.MEADOW.getWeight(), true, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET);
        RegistryManager.registerBiome((IForgeRegistry<Biome>)registry, new MiniJungleBiome(), "mini_jungle", ConfigManager.MINI_JUNGLE.getWeight(), true, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET);
        RegistryManager.registerBiome((IForgeRegistry<Biome>)registry, new PlainsPlateauBiome(), "plains_plateau", ConfigManager.PLAINS_PLATEAU.getWeight(), false, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.HILLS);
        RegistryManager.registerBiome((IForgeRegistry<Biome>)registry, new RockyEdgeBiome(), "rock_edge", ConfigManager.ROCK_EDGE.getWeight(), false, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.HOT, BiomeDictionary.Type.MOUNTAIN);
        RegistryManager.registerBiome((IForgeRegistry<Biome>)registry, new RollingHillsBiome(), "rolling_hills", ConfigManager.ROLLING_HILLS.getWeight(), true, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.HILLS);
        RegistryManager.registerBiome((IForgeRegistry<Biome>)registry, new SnowyConiferousForestBiome(), "snowy_coniferous_forest", ConfigManager.SNOWY_CONIFEROUS_FOREST.getWeight(), true, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS);
        RegistryManager.registerBiome((IForgeRegistry<Biome>)registry, new SnowyConiferousWoodedHillsBiome(), "snowy_coniferous_wooded_hills", ConfigManager.SNOWY_CONIFEROUS_WOODED_HILLS.getWeight(), true, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.HILLS);
        RegistryManager.registerBiome((IForgeRegistry<Biome>)registry, new SnowyHighConiferousForestBiome(), "snowy_high_coniferous_forest", ConfigManager.SNOWY_HIGH_CONIFEROUS_FOREST.getWeight(), true, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS);
        RegistryManager.registerBiome((IForgeRegistry<Biome>)registry, new WoodedPlateauBiome(), "wooded_plateau", ConfigManager.WOODED_PLATEAU.getWeight(), true, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS);
        RegistryManager.registerBiome((IForgeRegistry<Biome>)registry, new AutumnalWoodsBiome(), "woodlands", ConfigManager.WOODLANDS.getWeight(), true, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.FOREST);
    }

    private static void registerBiome(IForgeRegistry<Biome> registry, Biome biome, String name, int weight, boolean spawn, BiomeManager.BiomeType type, BiomeDictionary.Type ... types) {
        registry.register(biome.setRegistryName("traverse", name));
        if (weight > 0) {
            BiomeManager.addBiome((BiomeManager.BiomeType)type, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(biome, weight));
            if (spawn) {
                BiomeManager.addSpawnBiome((Biome)biome);
            }
            BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])types);
        }
    }
}

